/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.swing;

import com.bc.ceres.core.Assert;
import com.bc.ceres.grender.AdjustableView;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.ViewportListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AdjustableViewScrollPane
extends JPanel {
    private static final long serialVersionUID = -2634482999458990218L;
    private static final int MODEL_BOUNDS_EXTENSION = 10;
    private static final int MAX_SB_VALUE = 10000;
    private JScrollBar horizontalScrollBar;
    private JScrollBar verticalScrollBar;
    private JComponent cornerComponent;
    private JComponent viewComponent;
    private AdjustableView adjustableView;
    private Rectangle2D scrollArea;
    private boolean updatingScrollBars;
    private boolean scrollBarsUpdated;
    private ViewportChangeHandler viewportChangeHandler;
    private boolean hsbVisible;
    private boolean vsbVisible;
    private boolean debug = false;

    public AdjustableViewScrollPane() {
        this((JComponent)null);
    }

    public AdjustableViewScrollPane(JComponent viewComponent) {
        super(null);
        Assert.notNull((Object)viewComponent, (String)"viewComponent");
        Assert.argument((boolean)(viewComponent instanceof AdjustableView), (String)"viewComponent");
        this.scrollArea = new Rectangle2D.Double();
        this.viewportChangeHandler = new ViewportChangeHandler();
        this.setViewComponent(viewComponent);
        this.setCornerComponent(this.createCornerComponent());
        ScrollBarChangeHandler scrollBarCH = new ScrollBarChangeHandler();
        this.horizontalScrollBar = this.createHorizontalScrollbar();
        this.horizontalScrollBar.getModel().addChangeListener(scrollBarCH);
        this.verticalScrollBar = this.createVerticalScrollBar();
        this.verticalScrollBar.getModel().addChangeListener(scrollBarCH);
        this.addComponentListener(new ResizeHandler());
    }

    public AdjustableView getAdjustableView() {
        return (AdjustableView)((Object)this.viewComponent);
    }

    public JComponent getViewComponent() {
        return this.viewComponent;
    }

    public void setViewComponent(JComponent viewComponent) {
        if (this.viewComponent != viewComponent) {
            if (this.viewComponent != null) {
                this.adjustableView.getViewport().removeListener(this.viewportChangeHandler);
                this.remove(this.viewComponent);
            }
            this.viewComponent = viewComponent;
            this.adjustableView = null;
            if (viewComponent != null) {
                this.adjustableView = (AdjustableView)((Object)viewComponent);
                this.adjustableView.getViewport().addListener(this.viewportChangeHandler);
                this.add(this.viewComponent);
            }
            this.revalidate();
            this.validate();
        }
    }

    public JComponent getCornerComponent() {
        return this.cornerComponent;
    }

    public void setCornerComponent(JComponent cornerComponent) {
        if (this.cornerComponent != cornerComponent) {
            this.cornerComponent = cornerComponent;
            this.revalidate();
            this.validate();
        }
    }

    @Override
    public void doLayout() {
        if (this.viewComponent == null || !this.viewComponent.isVisible()) {
            return;
        }
        if (!this.scrollBarsUpdated) {
            this.updateScrollBars();
            this.updateScrollBarIncrements();
        }
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.hsbVisible && this.vsbVisible) {
            Dimension hsbSize = this.horizontalScrollBar.getPreferredSize();
            Dimension vsbSize = this.verticalScrollBar.getPreferredSize();
            int x1 = insets.left;
            int y1 = insets.top;
            int w2 = vsbSize.width;
            int h2 = hsbSize.height;
            int w1 = width - w2;
            int h1 = height - h2;
            int x2 = x1 + w1;
            int y2 = y1 + h1;
            this.viewComponent.setBounds(x1, y1, w1, h1);
            this.verticalScrollBar.setBounds(x2, y1, w2, h1);
            this.horizontalScrollBar.setBounds(x1, y2, w1, h2);
            if (this.cornerComponent != null) {
                this.cornerComponent.setBounds(x2, y2, w2, h2);
            }
        } else if (this.hsbVisible) {
            Dimension hsbSize = this.horizontalScrollBar.getPreferredSize();
            int x1 = insets.left;
            int y1 = insets.top;
            int w1 = width;
            int h2 = hsbSize.height;
            int h1 = height - h2;
            int y2 = y1 + h1;
            this.viewComponent.setBounds(x1, y1, w1, h1);
            this.horizontalScrollBar.setBounds(x1, y2, w1, h2);
        } else if (this.vsbVisible) {
            Dimension vsbSize = this.verticalScrollBar.getPreferredSize();
            int x1 = insets.left;
            int y1 = insets.top;
            int w2 = vsbSize.width;
            int w1 = width - w2;
            int h1 = height;
            int x2 = x1 + w1;
            this.viewComponent.setBounds(x1, y1, w1, h1);
            this.verticalScrollBar.setBounds(x2, y1, w2, h1);
        } else {
            int x1 = insets.left;
            int y1 = insets.top;
            this.viewComponent.setBounds(x1, y1, width, height);
        }
        this.viewComponent.doLayout();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp != this.horizontalScrollBar && comp != this.verticalScrollBar && comp != this.cornerComponent && comp != this.viewComponent) {
            throw new IllegalArgumentException();
        }
        super.addImpl(comp, constraints, index);
    }

    protected JScrollBar createHorizontalScrollbar() {
        return new JScrollBar(0);
    }

    protected JScrollBar createVerticalScrollBar() {
        return new JScrollBar(1);
    }

    protected JPanel createCornerComponent() {
        return new JPanel();
    }

    private void updateViewport() {
        if (this.updatingScrollBars || this.adjustableView == null) {
            if (this.debug) {
                System.out.println("AdjustableViewScrollPane.updateViewport: return!");
            }
            return;
        }
        Rectangle va = this.getViewBounds();
        double vx = va.getX();
        double vy = va.getY();
        Rectangle2D sa = this.scrollArea;
        if (this.hsbVisible) {
            int hsbValue = this.horizontalScrollBar.getValue();
            vx = sa.getX() + (double)hsbValue * sa.getWidth() / 10000.0;
        }
        if (this.vsbVisible) {
            int vsbValue = this.verticalScrollBar.getValue();
            vy = sa.getY() + (double)vsbValue * sa.getHeight() / 10000.0;
        }
        if (this.hsbVisible || this.vsbVisible) {
            if (this.debug) {
                System.out.println("AdjustableViewScrollPane.updateViewport:");
                System.out.println("  vx = " + vx);
                System.out.println("  vy = " + vy);
                System.out.println("");
            }
            this.adjustableView.getViewport().moveViewDelta(-vx, -vy);
        }
    }

    private void updateScrollBars() {
        boolean vsbVisible;
        if (this.adjustableView == null) {
            if (this.debug) {
                System.out.println("AdjustableViewScrollPane.updateScrollBars: return!");
            }
            return;
        }
        Rectangle va = this.getViewBounds();
        if (((RectangularShape)va).isEmpty()) {
            this.remove(this.horizontalScrollBar);
            this.remove(this.verticalScrollBar);
            if (this.cornerComponent != null) {
                this.remove(this.cornerComponent);
            }
            return;
        }
        Rectangle2D ma = this.adjustableView.getViewport().getModelToViewTransform().createTransformedShape(this.adjustableView.getMaxVisibleModelBounds()).getBounds2D();
        ma.add(ma.getX() - 10.0, ma.getY() - 10.0);
        ma.add(ma.getX() + ma.getWidth() + 10.0, ma.getY() + ma.getHeight() + 10.0);
        Rectangle2D sa = ma.createUnion(va);
        double dx1 = ma.getX() - ((RectangularShape)va).getX();
        double dy1 = ma.getY() - ((RectangularShape)va).getY();
        double dx2 = ((RectangularShape)va).getX() + ((RectangularShape)va).getWidth() - (ma.getX() + ma.getWidth());
        double dy2 = ((RectangularShape)va).getY() + ((RectangularShape)va).getHeight() - (ma.getY() + ma.getHeight());
        boolean hsbVisible = dx1 < 0.0 || dx2 < 0.0;
        boolean bl = vsbVisible = dy1 < 0.0 || dy2 < 0.0;
        if (this.hsbVisible != hsbVisible || this.vsbVisible != vsbVisible) {
            if (this.hsbVisible != hsbVisible) {
                if (hsbVisible) {
                    this.add(this.horizontalScrollBar);
                } else {
                    this.remove(this.horizontalScrollBar);
                }
            }
            if (this.vsbVisible != vsbVisible) {
                if (vsbVisible) {
                    this.add(this.verticalScrollBar);
                } else {
                    this.remove(this.verticalScrollBar);
                }
            }
            if (this.cornerComponent != null) {
                if (hsbVisible && vsbVisible) {
                    this.add(this.cornerComponent);
                } else {
                    this.remove(this.cornerComponent);
                }
            }
            this.hsbVisible = hsbVisible;
            this.vsbVisible = vsbVisible;
        }
        if (this.debug) {
            System.out.println("AdjustableViewScrollPane.updateScrollBars:");
            System.out.println("  hsbVisible = " + vsbVisible);
            System.out.println("  hsbVisible = " + hsbVisible);
            System.out.println("  va = " + va);
            System.out.println("  ma = " + ma);
            System.out.println("  sa = " + sa);
            System.out.println("  dx1 = " + dx1 + ", dx2 = " + dx2);
            System.out.println("  dy1 = " + dy1 + ", dy2 = " + dy2);
            System.out.println();
        }
        this.scrollArea.setRect(sa);
        this.updatingScrollBars = true;
        if (hsbVisible) {
            int hsbValue = (int)Math.round(10000.0 * (((RectangularShape)va).getX() - sa.getX()) / sa.getWidth());
            hsbValue = AdjustableViewScrollPane.clamp(hsbValue, 0, 10000);
            int hsbExtend = (int)Math.round(10000.0 * ((RectangularShape)va).getWidth() / sa.getWidth());
            hsbExtend = AdjustableViewScrollPane.clamp(hsbExtend, 0, 10000);
            this.horizontalScrollBar.setValues(hsbValue, hsbExtend, 0, 10000);
        }
        if (vsbVisible) {
            int vsbValue = (int)Math.round(10000.0 * (((RectangularShape)va).getY() - sa.getY()) / sa.getHeight());
            vsbValue = AdjustableViewScrollPane.clamp(vsbValue, 0, 10000);
            int vsbExtend = (int)Math.round(10000.0 * ((RectangularShape)va).getHeight() / sa.getHeight());
            vsbExtend = AdjustableViewScrollPane.clamp(vsbExtend, 0, 10000);
            this.verticalScrollBar.setValues(vsbValue, vsbExtend, 0, 10000);
        }
        this.updatingScrollBars = false;
        this.scrollBarsUpdated = true;
    }

    private void updateScrollBarIncrements() {
        this.horizontalScrollBar.setUnitIncrement(Math.max(10, 200));
        this.horizontalScrollBar.setBlockIncrement(Math.max(10, 2000));
        this.verticalScrollBar.setUnitIncrement(Math.max(10, 200));
        this.verticalScrollBar.setBlockIncrement(Math.max(10, 2000));
    }

    private Rectangle getViewBounds() {
        return new Rectangle(0, 0, this.viewComponent.getWidth(), this.viewComponent.getHeight());
    }

    private static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    private class ViewportChangeHandler
    implements ViewportListener {
        boolean atWork;

        private ViewportChangeHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleViewportChanged(Viewport viewport, boolean orientationChanged) {
            if (!this.atWork) {
                try {
                    this.atWork = true;
                    AdjustableViewScrollPane.this.updateScrollBars();
                    AdjustableViewScrollPane.this.updateScrollBarIncrements();
                }
                finally {
                    this.atWork = false;
                }
            }
        }
    }

    private class ScrollBarChangeHandler
    implements ChangeListener {
        boolean atWork;

        private ScrollBarChangeHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            if (!this.atWork) {
                try {
                    this.atWork = true;
                    AdjustableViewScrollPane.this.updateViewport();
                }
                finally {
                    this.atWork = false;
                }
            }
        }
    }

    private class ResizeHandler
    extends ComponentAdapter {
        private ResizeHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            AdjustableViewScrollPane.this.updateScrollBars();
        }
    }
}

