/*
 * Decompiled with CFR 0.152.
 */
package de.jutzig.github.release.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHReleaseBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public class UploadMojo
extends AbstractMojo
implements Contextualizable {
    private String serverId;
    private String tag;
    private String releaseName;
    private String description;
    private String repositoryId;
    private Settings settings;
    private MavenSession session;
    private String artifact;
    @Requirement
    private PlexusContainer container;
    private Boolean prerelease;
    private String serverPassword;
    private String serverUsername;

    public void execute() throws MojoExecutionException {
        if (this.releaseName == null) {
            this.releaseName = this.tag;
        }
        if (this.prerelease == null) {
            this.prerelease = this.tag.endsWith("-SNAPSHOT");
        }
        this.repositoryId = this.computeRepositoryId(this.repositoryId);
        try {
            GitHub gitHub = this.createGithub(this.serverId);
            GHRepository repository = gitHub.getRepository(this.repositoryId);
            GHRelease release = this.findRelease(repository, this.releaseName);
            if (release == null) {
                this.getLog().info((CharSequence)("Creating release " + this.releaseName));
                GHReleaseBuilder builder = repository.createRelease(this.tag);
                if (this.description != null) {
                    builder.body(this.description);
                }
                builder.prerelease(this.prerelease.booleanValue());
                builder.name(this.releaseName);
                release = builder.create();
            } else {
                this.getLog().info((CharSequence)("Release " + this.releaseName + " already exists. Not creating"));
            }
            File asset = new File(this.artifact);
            URL url = new URL(MessageFormat.format("https://uploads.github.com/repos/{0}/releases/{1}/assets?name={2}", this.repositoryId, Long.toString(release.getId()), asset.getName()));
            release.uploadAsset(asset, "application/zip");
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to upload assets", (Exception)e);
        }
    }

    private GHRelease findRelease(GHRepository repository, String releaseName2) throws IOException {
        List releases = repository.getReleases();
        for (GHRelease ghRelease : releases) {
            if (!ghRelease.getName().equals(releaseName2)) continue;
            return ghRelease;
        }
        return null;
    }

    private String computeRepositoryId(String id) {
        if (id.startsWith("scm:git:https://github.com/")) {
            id = id.substring("scm:git:https://github.com/".length());
        } else if (id.startsWith("scm:git:http://github.com/")) {
            id = id.substring("scm:git:http://github.com/".length());
        } else if (id.startsWith("scm:git:git@github.com:")) {
            id = id.substring("scm:git:git@github.com:".length());
        }
        if (id.endsWith(".git")) {
            id = id.substring(0, id.length() - ".git".length());
        }
        return id;
    }

    public GitHub createGithub(String serverId) throws MojoExecutionException, IOException {
        this.serverUsername = null;
        this.serverPassword = null;
        Server server = this.getServer(this.settings, serverId);
        if (server == null) {
            throw new MojoExecutionException(MessageFormat.format("Server ''{0}'' not found in settings", serverId));
        }
        this.getLog().debug((CharSequence)MessageFormat.format("Using ''{0}'' server credentials", serverId));
        try {
            SettingsDecrypter settingsDecrypter = (SettingsDecrypter)this.container.lookup(SettingsDecrypter.class);
            SettingsDecryptionResult result = settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
            server = result.getServer();
        }
        catch (ComponentLookupException cle) {
            throw new MojoExecutionException("Unable to lookup SettingsDecrypter: " + cle.getMessage(), (Exception)((Object)cle));
        }
        this.serverUsername = server.getUsername();
        this.serverPassword = server.getPassword();
        GitHub gitHub = GitHub.connectUsingPassword((String)this.serverUsername, (String)this.serverPassword);
        return gitHub;
    }

    protected Server getServer(Settings settings, String serverId) {
        if (settings == null) {
            return null;
        }
        List servers = settings.getServers();
        if (servers == null || servers.isEmpty()) {
            return null;
        }
        for (Server server : servers) {
            if (!serverId.equals(server.getId())) continue;
            return server;
        }
        return null;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

