/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.extension;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.extension.ExtensionClassLoader;
import org.apache.guacamole.extension.ExtensionManifest;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.event.listener.Listener;
import org.apache.guacamole.resource.ClassPathResource;
import org.apache.guacamole.resource.Resource;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.ObjectMapper;

public class Extension {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String MANIFEST_NAME = "guac-manifest.json";
    private final ExtensionManifest manifest;
    private final ClassLoader classLoader;
    private final Map<String, Resource> javaScriptResources;
    private final Map<String, Resource> cssResources;
    private final Map<String, Resource> htmlResources;
    private final Map<String, Resource> translationResources;
    private final Map<String, Resource> staticResources;
    private final Collection<Class<AuthenticationProvider>> authenticationProviderClasses;
    private final Collection<Class<?>> listenerClasses;
    private final Resource smallIcon;
    private final Resource largeIcon;

    private Map<String, Resource> getClassPathResources(String mimetype, Collection<String> paths) {
        if (paths == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ClassPathResource> resources = new HashMap<String, ClassPathResource>(paths.size());
        for (String path : paths) {
            resources.put(path, new ClassPathResource(this.classLoader, mimetype, path));
        }
        return Collections.unmodifiableMap(resources);
    }

    private Map<String, Resource> getClassPathResources(Map<String, String> resourceTypes) {
        if (resourceTypes == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ClassPathResource> resources = new HashMap<String, ClassPathResource>(resourceTypes.size());
        for (Map.Entry<String, String> resource : resourceTypes.entrySet()) {
            String path = resource.getKey();
            String mimetype = resource.getValue();
            resources.put(path, new ClassPathResource(this.classLoader, mimetype, path));
        }
        return Collections.unmodifiableMap(resources);
    }

    private Class<AuthenticationProvider> getAuthenticationProviderClass(String name) throws GuacamoleException {
        try {
            Class<AuthenticationProvider> authenticationProviderClass = this.classLoader.loadClass(name);
            if (!AuthenticationProvider.class.isAssignableFrom(authenticationProviderClass)) {
                throw new GuacamoleServerException("Authentication providers MUST extend the AuthenticationProvider class.");
            }
            return authenticationProviderClass;
        }
        catch (ClassNotFoundException e) {
            throw new GuacamoleException("Authentication provider class not found.", (Throwable)e);
        }
        catch (LinkageError e) {
            throw new GuacamoleException("Authentication provider class cannot be loaded (wrong version of API?).", (Throwable)e);
        }
    }

    private Collection<Class<AuthenticationProvider>> getAuthenticationProviderClasses(Collection<String> names) throws GuacamoleException {
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<Class> classes = new ArrayList<Class>(names.size());
        for (String name : names) {
            classes.add(this.getAuthenticationProviderClass(name));
        }
        return Collections.unmodifiableCollection(classes);
    }

    private Class<Listener> getListenerClass(String name) throws GuacamoleException {
        try {
            Class<Listener> listenerClass = this.classLoader.loadClass(name);
            if (!Listener.class.isAssignableFrom(listenerClass)) {
                throw new GuacamoleServerException("Listeners MUST implement a Listener subclass.");
            }
            return listenerClass;
        }
        catch (ClassNotFoundException e) {
            throw new GuacamoleException("Listener class not found.", (Throwable)e);
        }
        catch (LinkageError e) {
            throw new GuacamoleException("Listener class cannot be loaded (wrong version of API?).", (Throwable)e);
        }
    }

    private Collection<Class<?>> getListenerClasses(Collection<String> names) throws GuacamoleException {
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<Class> classes = new ArrayList<Class>(names.size());
        for (String name : names) {
            classes.add(this.getListenerClass(name));
        }
        return Collections.unmodifiableCollection(classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extension(ClassLoader parent, File file) throws GuacamoleException {
        try {
            try (ZipFile extension = new ZipFile(file);){
                ZipEntry manifestEntry = extension.getEntry(MANIFEST_NAME);
                if (manifestEntry == null) {
                    throw new GuacamoleServerException("Extension " + file.getName() + " is missing " + MANIFEST_NAME);
                }
                this.manifest = (ExtensionManifest)mapper.readValue(extension.getInputStream(manifestEntry), ExtensionManifest.class);
                if (this.manifest == null) {
                    throw new GuacamoleServerException("Contents of guac-manifest.json must be a valid JSON object.");
                }
            }
            this.classLoader = ExtensionClassLoader.getInstance((File)file, (ClassLoader)parent);
        }
        catch (ZipException e) {
            throw new GuacamoleServerException("Extension is not a valid zip file: " + file.getName(), (Throwable)e);
        }
        catch (JsonParseException e) {
            throw new GuacamoleServerException("guac-manifest.json is not valid JSON: " + file.getName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new GuacamoleServerException("Unable to read extension: " + file.getName(), (Throwable)e);
        }
        this.cssResources = this.getClassPathResources("text/css", this.manifest.getCSSPaths());
        this.javaScriptResources = this.getClassPathResources("text/javascript", this.manifest.getJavaScriptPaths());
        this.htmlResources = this.getClassPathResources("text/html", this.manifest.getHTMLPaths());
        this.translationResources = this.getClassPathResources("application/json", this.manifest.getTranslationPaths());
        this.staticResources = this.getClassPathResources(this.manifest.getResourceTypes());
        this.authenticationProviderClasses = this.getAuthenticationProviderClasses(this.manifest.getAuthProviders());
        this.listenerClasses = this.getListenerClasses(this.manifest.getListeners());
        this.smallIcon = this.manifest.getSmallIcon() != null ? new ClassPathResource(this.classLoader, "image/png", this.manifest.getSmallIcon()) : null;
        this.largeIcon = this.manifest.getLargeIcon() != null ? new ClassPathResource(this.classLoader, "image/png", this.manifest.getLargeIcon()) : null;
    }

    public String getGuacamoleVersion() {
        return this.manifest.getGuacamoleVersion();
    }

    public String getName() {
        return this.manifest.getName();
    }

    public String getNamespace() {
        return this.manifest.getNamespace();
    }

    public Map<String, Resource> getJavaScriptResources() {
        return this.javaScriptResources;
    }

    public Map<String, Resource> getCSSResources() {
        return this.cssResources;
    }

    public Map<String, Resource> getHTMLResources() {
        return this.htmlResources;
    }

    public Map<String, Resource> getTranslationResources() {
        return this.translationResources;
    }

    public Map<String, Resource> getStaticResources() {
        return this.staticResources;
    }

    public Collection<Class<AuthenticationProvider>> getAuthenticationProviderClasses() {
        return this.authenticationProviderClasses;
    }

    public Collection<Class<?>> getListenerClasses() {
        return this.listenerClasses;
    }

    public Resource getSmallIcon() {
        return this.smallIcon;
    }

    public Resource getLargeIcon() {
        return this.largeIcon;
    }
}

