/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.extension;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.StringSetProperty;
import org.apache.guacamole.resource.ByteArrayResource;
import org.apache.guacamole.resource.Resource;
import org.apache.guacamole.resource.WebApplicationResource;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageResourceService {
    private final Logger logger = LoggerFactory.getLogger(LanguageResourceService.class);
    private static final String TRANSLATION_PATH = "/translations";
    private static final String LANGUAGE_DISPLAY_NAME_KEY = "NAME";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Pattern LANGUAGE_KEY_PATTERN = Pattern.compile(".*/([a-z]+(_[A-Z]+)?)\\.json");
    public final StringSetProperty ALLOWED_LANGUAGES = new /* Unavailable Anonymous Inner Class!! */;
    private final Set<String> allowedLanguages;
    private final Map<String, Resource> resources = new HashMap();

    public LanguageResourceService(Environment environment) {
        Set parsedAllowedLanguages;
        try {
            parsedAllowedLanguages = (Set)environment.getProperty((GuacamoleProperty)this.ALLOWED_LANGUAGES);
            this.logger.debug("Available languages will be restricted to: {}", (Object)parsedAllowedLanguages);
        }
        catch (GuacamoleException e) {
            parsedAllowedLanguages = null;
            this.logger.error("Unable to parse list of allowed languages: {}", (Object)e.getMessage());
            this.logger.debug("Error parsing list of allowed languages.", (Throwable)e);
        }
        this.allowedLanguages = parsedAllowedLanguages;
    }

    public String getLanguageKey(String path) {
        Matcher languageKeyMatcher = LANGUAGE_KEY_PATTERN.matcher(path);
        if (!languageKeyMatcher.matches()) {
            return null;
        }
        return languageKeyMatcher.group(1);
    }

    private JsonNode mergeTranslations(JsonNode original, JsonNode overlay) {
        String fieldName;
        if (!overlay.isObject() || original == null) {
            return overlay;
        }
        ObjectNode newNode = JsonNodeFactory.instance.objectNode();
        Iterator fieldNames = original.getFieldNames();
        while (fieldNames.hasNext()) {
            fieldName = (String)fieldNames.next();
            newNode.put(fieldName, original.get(fieldName));
        }
        fieldNames = overlay.getFieldNames();
        while (fieldNames.hasNext()) {
            fieldName = (String)fieldNames.next();
            newNode.put(fieldName, this.mergeTranslations(original.get(fieldName), overlay.get(fieldName)));
        }
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode parseLanguageResource(Resource resource) throws IOException {
        InputStream stream = resource.asStream();
        if (stream == null) {
            return null;
        }
        try {
            JsonNode tree;
            JsonNode jsonNode = tree = mapper.readTree(stream);
            return jsonNode;
        }
        finally {
            stream.close();
        }
    }

    private boolean isLanguageAllowed(String languageKey) {
        if (this.allowedLanguages == null) {
            return true;
        }
        return this.allowedLanguages.contains(languageKey);
    }

    public void addLanguageResource(String key, Resource resource) {
        if (!this.isLanguageAllowed(key)) {
            this.logger.debug("OMITTING language: \"{}\"", (Object)key);
            return;
        }
        Resource existing = (Resource)this.resources.get(key);
        if (existing != null) {
            try {
                JsonNode existingTree = this.parseLanguageResource(existing);
                if (existingTree == null) {
                    this.logger.warn("Base language resource \"{}\" does not exist.", (Object)key);
                    return;
                }
                JsonNode resourceTree = this.parseLanguageResource(resource);
                if (resourceTree == null) {
                    this.logger.warn("Overlay language resource \"{}\" does not exist.", (Object)key);
                    return;
                }
                JsonNode mergedTree = this.mergeTranslations(existingTree, resourceTree);
                this.resources.put(key, new ByteArrayResource("application/json", mapper.writeValueAsBytes((Object)mergedTree)));
                this.logger.debug("Merged strings with existing language: \"{}\"", (Object)key);
            }
            catch (IOException e) {
                this.logger.error("Unable to merge language resource \"{}\": {}", (Object)key, (Object)e.getMessage());
                this.logger.debug("Error merging language resource.", (Throwable)e);
            }
        } else {
            this.resources.put(key, resource);
            this.logger.debug("Added language: \"{}\"", (Object)key);
        }
    }

    public void addLanguageResources(ServletContext context) {
        Set resourcePaths = context.getResourcePaths(TRANSLATION_PATH);
        if (resourcePaths == null) {
            return;
        }
        for (Object resourcePathObject : resourcePaths) {
            String resourcePath = (String)resourcePathObject;
            String languageKey = this.getLanguageKey(resourcePath);
            if (languageKey == null) {
                this.logger.warn("Invalid language file name: \"{}\"", (Object)resourcePath);
                continue;
            }
            this.addLanguageResource(languageKey, (Resource)new WebApplicationResource(context, "application/json", resourcePath));
        }
    }

    public Set<String> getLanguageKeys() {
        return Collections.unmodifiableSet(this.resources.keySet());
    }

    public Map<String, Resource> getLanguageResources() {
        return Collections.unmodifiableMap(this.resources);
    }

    public Map<String, String> getLanguageNames() {
        HashMap<String, String> languageNames = new HashMap<String, String>();
        for (Map.Entry entry : this.resources.entrySet()) {
            String languageKey = (String)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            InputStream resourceStream = resource.asStream();
            if (resourceStream == null) {
                this.logger.warn("Expected language resource does not exist: \"{}\".", (Object)languageKey);
                continue;
            }
            try {
                String languageName;
                JsonNode tree = mapper.readTree(resourceStream);
                JsonNode nameNode = tree.get(LANGUAGE_DISPLAY_NAME_KEY);
                if (nameNode == null || (languageName = nameNode.getTextValue()) == null) {
                    this.logger.warn("Root-level \"NAME\" string missing or invalid in language \"{}\"", (Object)languageKey);
                    languageName = languageKey;
                }
                languageNames.put(languageKey, languageName);
            }
            catch (IOException e) {
                this.logger.warn("Unable to read language resource \"{}\".", (Object)languageKey);
                this.logger.debug("Error reading language resource.", (Throwable)e);
            }
        }
        return Collections.unmodifiableMap(languageNames);
    }
}

