/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.protocol.GuacamoleInstruction;
import org.apache.guacamole.protocol.GuacamoleStatus;
import org.apache.guacamole.tunnel.InterceptedStream;
import org.apache.guacamole.tunnel.StreamInterceptingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputStreamInterceptingFilter
extends StreamInterceptingFilter<OutputStream> {
    private static final Logger logger = LoggerFactory.getLogger(OutputStreamInterceptingFilter.class);
    private boolean acknowledgeBlobs = true;

    public OutputStreamInterceptingFilter(GuacamoleTunnel tunnel) {
        super(tunnel);
    }

    private void sendAck(String index, String message, GuacamoleStatus status) {
        if (status != GuacamoleStatus.SUCCESS) {
            this.closeInterceptedStream(index);
        }
        this.sendInstruction(new GuacamoleInstruction("ack", new String[]{index, message, Integer.toString(status.getGuacamoleStatusCode())}));
    }

    private GuacamoleInstruction handleBlob(GuacamoleInstruction instruction) {
        byte[] blob;
        List args = instruction.getArgs();
        if (args.size() < 2) {
            return instruction;
        }
        String index = (String)args.get(0);
        InterceptedStream stream = this.getInterceptedStream(index);
        if (stream == null) {
            return instruction;
        }
        try {
            String data = (String)args.get(1);
            blob = DatatypeConverter.parseBase64Binary((String)data);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Received base64 data for intercepted stream was invalid.");
            logger.debug("Decoding base64 data for intercepted stream failed.", (Throwable)e);
            return null;
        }
        try {
            ((OutputStream)stream.getStream()).write(blob);
            if (!this.acknowledgeBlobs) {
                this.acknowledgeBlobs = true;
                return new GuacamoleInstruction("blob", new String[]{index, ""});
            }
            this.sendAck(index, "OK", GuacamoleStatus.SUCCESS);
        }
        catch (IOException e) {
            this.sendAck(index, "FAIL", GuacamoleStatus.SERVER_ERROR);
            logger.debug("Write failed for intercepted stream.", (Throwable)e);
        }
        return null;
    }

    private void handleEnd(GuacamoleInstruction instruction) {
        List args = instruction.getArgs();
        if (args.size() < 1) {
            return;
        }
        this.closeInterceptedStream((String)args.get(0));
    }

    private void handleSync(GuacamoleInstruction instruction) {
        this.acknowledgeBlobs = false;
    }

    public GuacamoleInstruction filter(GuacamoleInstruction instruction) throws GuacamoleException {
        if (instruction.getOpcode().equals("blob")) {
            return this.handleBlob(instruction);
        }
        if (instruction.getOpcode().equals("end")) {
            this.handleEnd(instruction);
            return instruction;
        }
        if (instruction.getOpcode().equals("sync")) {
            this.handleSync(instruction);
            return instruction;
        }
        return instruction;
    }

    protected void handleInterceptedStream(InterceptedStream<OutputStream> stream) {
        this.sendAck(stream.getIndex(), "OK", GuacamoleStatus.SUCCESS);
    }
}

