/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.csa.rstb.gpf.PolOpUtils;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.nest.dataio.PolBandUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.TileIndex;

@OperatorMetadata(alias="Orientation-Angle-Correction", category="SAR Processing/Polarimetric", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Perform polarization orientation angle correction for given coherency matrix")
public final class OrientationAngleCorrectionOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    private PolBandUtils.QuadSourceBand[] srcBandList;
    private PolBandUtils.MATRIX sourceProductType;
    private static final double PI4 = 0.7853981633974483;
    private static final double PI2 = 1.5707963267948966;

    public void initialize() throws OperatorException {
        try {
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct).setAttributeInt("polsar_data", 1);
    }

    private void addSelectedBands() throws OperatorException {
        ArrayList<String> targetBandNameList = new ArrayList<String>(10);
        targetBandNameList.add("T11");
        targetBandNameList.add("T12_real");
        targetBandNameList.add("T12_imag");
        targetBandNameList.add("T13_real");
        targetBandNameList.add("T13_imag");
        targetBandNameList.add("T22");
        targetBandNameList.add("T23_real");
        targetBandNameList.add("T23_imag");
        targetBandNameList.add("T33");
        String[] bandNames = targetBandNameList.toArray(new String[targetBandNameList.size()]);
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            Band[] targetBands = OperatorUtils.addBands((Product)this.targetProduct, (String[])bandNames, (String)bandList.suffix);
            bandList.addTargetBands(targetBands);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            int maxY = y0 + h;
            int maxX = x0 + w;
            double[][] C3r = new double[3][3];
            double[][] C3i = new double[3][3];
            double[][] C4r = new double[4][4];
            double[][] C4i = new double[4][4];
            double[][] T3r = new double[3][3];
            double[][] T3i = new double[3][3];
            double[][] T4r = new double[4][4];
            double[][] T4i = new double[4][4];
            TileIndex tgtIndex = new TileIndex(targetTiles.get(this.getTargetProduct().getBandAt(0)));
            for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
                Tile[] sourceTiles = new Tile[bandList.srcBands.length];
                ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
                for (int i = 0; i < bandList.srcBands.length; ++i) {
                    sourceTiles[i] = this.getSourceTile((RasterDataNode)bandList.srcBands[i], targetRectangle);
                    dataBuffers[i] = sourceTiles[i].getDataBuffer();
                }
                TileIndex srcIndex = new TileIndex(sourceTiles[0]);
                ProductData[] targetDataBuffers = new ProductData[9];
                for (Band targetBand : bandList.targetBands) {
                    String targetBandName = targetBand.getName();
                    ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                    if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"11")) {
                        targetDataBuffers[0] = dataBuffer;
                        continue;
                    }
                    if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_real")) {
                        targetDataBuffers[1] = dataBuffer;
                        continue;
                    }
                    if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_imag")) {
                        targetDataBuffers[2] = dataBuffer;
                        continue;
                    }
                    if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_real")) {
                        targetDataBuffers[3] = dataBuffer;
                        continue;
                    }
                    if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_imag")) {
                        targetDataBuffers[4] = dataBuffer;
                        continue;
                    }
                    if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"22")) {
                        targetDataBuffers[5] = dataBuffer;
                        continue;
                    }
                    if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_real")) {
                        targetDataBuffers[6] = dataBuffer;
                        continue;
                    }
                    if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_imag")) {
                        targetDataBuffers[7] = dataBuffer;
                        continue;
                    }
                    if (!PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"33")) continue;
                    targetDataBuffers[8] = dataBuffer;
                }
                double[][] Tr = new double[3][3];
                double[][] Ti = new double[3][3];
                for (int y = y0; y < maxY; ++y) {
                    srcIndex.calculateStride(y);
                    tgtIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        int srcIdx = srcIndex.getIndex(x);
                        int tgtIdx = tgtIndex.getIndex(x);
                        if (this.sourceProductType == PolBandUtils.MATRIX.FULL) {
                            PolOpUtils.getT3(srcIdx, this.sourceProductType, dataBuffers, T3r, T3i);
                        } else if (this.sourceProductType == PolBandUtils.MATRIX.T3) {
                            PolOpUtils.getCoherencyMatrixT3(srcIdx, dataBuffers, T3r, T3i);
                        } else if (this.sourceProductType == PolBandUtils.MATRIX.T4) {
                            PolOpUtils.getCoherencyMatrixT4(srcIdx, dataBuffers, T4r, T4i);
                            PolOpUtils.t4ToT3(T4r, T4i, T3r, T3i);
                        } else if (this.sourceProductType == PolBandUtils.MATRIX.C3) {
                            PolOpUtils.getCovarianceMatrixC3(srcIdx, dataBuffers, C3r, C3i);
                            PolOpUtils.c3ToT3(C3r, C3i, T3r, T3i);
                        } else if (this.sourceProductType == PolBandUtils.MATRIX.C4) {
                            PolOpUtils.getCovarianceMatrixC4(srcIdx, dataBuffers, C4r, C4i);
                            PolOpUtils.c4ToT4(C4r, C4i, T4r, T4i);
                            PolOpUtils.t4ToT3(T4r, T4i, T3r, T3i);
                        }
                        double theta = OrientationAngleCorrectionOp.estimateOrientationAngle(T3r[1][2], T3r[1][1], T3r[2][2]);
                        double c = FastMath.cos((double)(2.0 * theta));
                        double s = FastMath.sin((double)(2.0 * theta));
                        double c2 = c * c;
                        double s2 = s * s;
                        double cs = c * s;
                        Tr[0][0] = T3r[0][0];
                        Tr[0][1] = T3r[0][1] * c - T3r[0][2] * s;
                        Ti[0][1] = T3i[0][1] * c - T3i[0][2] * s;
                        Tr[0][2] = T3r[0][1] * s + T3r[0][2] * c;
                        Ti[0][2] = T3i[0][1] * s + T3i[0][2] * c;
                        Tr[1][1] = T3r[1][1] * c2 + T3r[2][2] * s2 - 2.0 * T3r[1][2] * cs;
                        Tr[1][2] = T3r[1][2] * (c2 - s2) + (T3r[1][1] - T3r[2][2]) * cs;
                        Ti[1][2] = T3i[1][2];
                        Tr[2][2] = T3r[1][1] * s2 + T3r[2][2] * c2 + 2.0 * T3r[1][2] * cs;
                        OrientationAngleCorrectionOp.saveT3(Tr, Ti, tgtIdx, targetDataBuffers);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private static double estimateOrientationAngle(double t23Re, double t22, double t33) {
        if (t33 == 0.0) {
            return 0.0;
        }
        double theta = 0.25 * (Math.atan2(2.0 * t23Re, t33 - t22) + Math.PI);
        if (theta > 0.7853981633974483) {
            theta -= 1.5707963267948966;
        }
        return theta;
    }

    private static void saveT3(double[][] Tr, double[][] Ti, int idx, ProductData[] targetDataBuffers) {
        targetDataBuffers[0].setElemFloatAt(idx, (float)Tr[0][0]);
        targetDataBuffers[1].setElemFloatAt(idx, (float)Tr[0][1]);
        targetDataBuffers[2].setElemFloatAt(idx, (float)Ti[0][1]);
        targetDataBuffers[3].setElemFloatAt(idx, (float)Tr[0][2]);
        targetDataBuffers[4].setElemFloatAt(idx, (float)Ti[0][2]);
        targetDataBuffers[5].setElemFloatAt(idx, (float)Tr[1][1]);
        targetDataBuffers[6].setElemFloatAt(idx, (float)Tr[1][2]);
        targetDataBuffers[7].setElemFloatAt(idx, (float)Ti[1][2]);
        targetDataBuffers[8].setElemFloatAt(idx, (float)Tr[2][2]);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(OrientationAngleCorrectionOp.class);
        }
    }
}

