/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.csa.rstb.gpf.PolOpUtils;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.nest.dataio.PolBandUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.TileIndex;

@OperatorMetadata(alias="Polarimetric-Speckle-Filter", category="SAR Processing/Polarimetric", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Polarimetric Speckle Reduction")
public class PolarimetricSpeckleFilterOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct = null;
    @TargetProduct
    private Product targetProduct;
    @Parameter(valueSet={"Box Car Filter", "IDAN Filter", "Refined Lee Filter", "Improved Lee Sigma Filter"}, defaultValue="Refined Lee Filter", label="Filter")
    private String filter;
    @Parameter(description="The boxcar filter size", interval="(1, 100]", defaultValue="5", label="Filter Size")
    private int filterSize = 5;
    @Parameter(valueSet={"1", "2", "3", "4"}, defaultValue="1", label="Window Size")
    private String numLooksStr = "1";
    @Parameter(valueSet={"5x5", "7x7", "9x9", "11x11"}, defaultValue="7x7", label="Window Size")
    private String windowSize = "7x7";
    @Parameter(valueSet={"7x7", "9x9", "11x11"}, defaultValue="9x9", label="Filter Window Size")
    private String filterWindowSizeStr = "9x9";
    @Parameter(valueSet={"3x3", "5x5"}, defaultValue="3x3", label="Point target window Size")
    private String targetWindowSizeStr = "3x3";
    @Parameter(description="The Adaptive Neighbourhood size", interval="(1, 200]", defaultValue="50", label="Adaptive Neighbourhood Size")
    private int anSize = 50;
    @Parameter(valueSet={"0.5", "0.6", "0.7", "0.8", "0.9"}, defaultValue="0.9", label="Point target window Size")
    private String sigmaStr = "0.9";
    private PolBandUtils.QuadSourceBand[] srcBandList;
    private int halfFilterSize = 0;
    private int convSize;
    private int numLooks;
    private double I1;
    private double I2;
    private int sigma;
    private double sigmaVP;
    private double sigmaVPSqr;
    private int filterWindowSize = 0;
    private int targetWindowSize = 0;
    private int halfTargetWindowSize = 0;
    private int targetSize = 5;
    private double sigmaV;
    private double sigmaVSqr;
    private int stride = 0;
    private int subWindowSize = 0;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private PolBandUtils.MATRIX sourceProductType = null;
    private static final double NonValidPixelValue = -1.0;
    public static final String BOXCAR_SPECKLE_FILTER = "Box Car Filter";
    public static final String REFINED_LEE_FILTER = "Refined Lee Filter";
    public static final String IDAN_FILTER = "IDAN Filter";
    public static final String LEE_SIGMA_FILTER = "Improved Lee Sigma Filter";
    public static final String WINDOW_SIZE_3x3 = "3x3";
    public static final String WINDOW_SIZE_5x5 = "5x5";
    public static final String WINDOW_SIZE_7x7 = "7x7";
    public static final String WINDOW_SIZE_9x9 = "9x9";
    public static final String WINDOW_SIZE_11x11 = "11x11";
    public static final String SIGMA_50_PERCENT = "0.5";
    public static final String SIGMA_60_PERCENT = "0.6";
    public static final String SIGMA_70_PERCENT = "0.7";
    public static final String SIGMA_80_PERCENT = "0.8";
    public static final String SIGMA_90_PERCENT = "0.9";
    public static final String NUM_LOOKS_1 = "1";
    public static final String NUM_LOOKS_2 = "2";
    public static final String NUM_LOOKS_3 = "3";
    public static final String NUM_LOOKS_4 = "4";

    public void SetFilter(String s) {
        if (!(s.equals(BOXCAR_SPECKLE_FILTER) || s.equals(IDAN_FILTER) || s.equals(REFINED_LEE_FILTER) || s.equals(LEE_SIGMA_FILTER))) {
            throw new OperatorException(s + " is an invalid filter name.");
        }
        this.filter = s;
    }

    public void initialize() throws OperatorException {
        try {
            this.getSourceImageDimension();
            this.setParameters();
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private void setParameters() {
        switch (this.filter) {
            case "Box Car Filter": {
                this.setBoxcarParameters();
                break;
            }
            case "Refined Lee Filter": {
                this.setRefinedLeeParameters();
                break;
            }
            case "IDAN Filter": {
                this.setIDANParameters();
                break;
            }
            case "Improved Lee Sigma Filter": {
                this.setLeeSigmaParameters();
            }
        }
    }

    private void setBoxcarParameters() {
        this.halfFilterSize = this.filterSize / 2;
    }

    private void setRefinedLeeParameters() {
        this.setNumLooks();
        switch (this.windowSize) {
            case "5x5": {
                this.filterSize = 5;
                this.subWindowSize = 3;
                this.stride = 1;
                break;
            }
            case "7x7": {
                this.filterSize = 7;
                this.subWindowSize = 3;
                this.stride = 2;
                break;
            }
            case "9x9": {
                this.filterSize = 9;
                this.subWindowSize = 5;
                this.stride = 2;
                break;
            }
            case "11x11": {
                this.filterSize = 11;
                this.subWindowSize = 5;
                this.stride = 3;
                break;
            }
            default: {
                throw new OperatorException("Unknown window size: " + this.windowSize);
            }
        }
        this.halfFilterSize = this.filterSize / 2;
        this.convSize = this.filterSize * (this.halfFilterSize + 1);
        this.sigmaV = 1.0 / Math.sqrt(this.numLooks);
        this.sigmaVSqr = this.sigmaV * this.sigmaV;
    }

    private void setIDANParameters() {
        this.setNumLooks();
        this.filterSize = this.anSize * 2;
        this.halfFilterSize = this.filterSize / 2;
        this.sigmaV = 1.0 / Math.sqrt(this.numLooks);
        this.sigmaVSqr = this.sigmaV * this.sigmaV;
    }

    private void setLeeSigmaParameters() {
        this.setNumLooks();
        switch (this.sigmaStr) {
            case "0.5": {
                this.sigma = 5;
                break;
            }
            case "0.6": {
                this.sigma = 6;
                break;
            }
            case "0.7": {
                this.sigma = 7;
                break;
            }
            case "0.8": {
                this.sigma = 8;
                break;
            }
            case "0.9": {
                this.sigma = 9;
                break;
            }
            default: {
                throw new OperatorException("Unknown sigma: " + this.sigmaStr);
            }
        }
        switch (this.filterWindowSizeStr) {
            case "7x7": {
                this.filterWindowSize = 7;
                break;
            }
            case "9x9": {
                this.filterWindowSize = 9;
                break;
            }
            case "11x11": {
                this.filterWindowSize = 11;
                break;
            }
            default: {
                throw new OperatorException("Unknown filter window size: " + this.filterWindowSizeStr);
            }
        }
        switch (this.targetWindowSizeStr) {
            case "3x3": {
                this.targetWindowSize = 3;
                break;
            }
            case "5x5": {
                this.targetWindowSize = 5;
                break;
            }
            default: {
                throw new OperatorException("Unknown target window size: " + this.targetWindowSizeStr);
            }
        }
        this.halfFilterSize = this.filterWindowSize / 2;
        this.halfTargetWindowSize = this.targetWindowSize / 2;
        this.sigmaV = 1.0 / Math.sqrt(this.numLooks);
        this.sigmaVSqr = this.sigmaV * this.sigmaV;
        this.setSigmaRange();
    }

    private void setNumLooks() {
        this.numLooks = Integer.parseInt(this.numLooksStr);
    }

    private void setSigmaRange() {
        if (this.numLooks == 1) {
            if (this.sigma == 5) {
                this.I1 = 0.436;
                this.I2 = 1.92;
                this.sigmaVP = 0.4057;
            } else if (this.sigma == 6) {
                this.I1 = 0.343;
                this.I2 = 2.21;
                this.sigmaVP = 0.4954;
            } else if (this.sigma == 7) {
                this.I1 = 0.254;
                this.I2 = 2.582;
                this.sigmaVP = 0.5911;
            } else if (this.sigma == 8) {
                this.I1 = 0.168;
                this.I2 = 3.094;
                this.sigmaVP = 0.6966;
            } else if (this.sigma == 9) {
                this.I1 = 0.084;
                this.I2 = 3.941;
                this.sigmaVP = 0.8191;
            }
        } else if (this.numLooks == 2) {
            if (this.sigma == 5) {
                this.I1 = 0.582;
                this.I2 = 1.584;
                this.sigmaVP = 0.2763;
            } else if (this.sigma == 6) {
                this.I1 = 0.501;
                this.I2 = 1.755;
                this.sigmaVP = 0.3388;
            } else if (this.sigma == 7) {
                this.I1 = 0.418;
                this.I2 = 1.972;
                this.sigmaVP = 0.4062;
            } else if (this.sigma == 8) {
                this.I1 = 0.327;
                this.I2 = 2.26;
                this.sigmaVP = 0.481;
            } else if (this.sigma == 9) {
                this.I1 = 0.221;
                this.I2 = 2.744;
                this.sigmaVP = 0.5699;
            }
        } else if (this.numLooks == 3) {
            if (this.sigma == 5) {
                this.I1 = 0.652;
                this.I2 = 1.458;
                this.sigmaVP = 0.2222;
            } else if (this.sigma == 6) {
                this.I1 = 0.58;
                this.I2 = 1.586;
                this.sigmaVP = 0.2736;
            } else if (this.sigma == 7) {
                this.I1 = 0.505;
                this.I2 = 1.751;
                this.sigmaVP = 0.328;
            } else if (this.sigma == 8) {
                this.I1 = 0.419;
                this.I2 = 1.965;
                this.sigmaVP = 0.3892;
            } else if (this.sigma == 9) {
                this.I1 = 0.313;
                this.I2 = 2.32;
                this.sigmaVP = 0.4624;
            }
        } else if (this.numLooks == 4) {
            if (this.sigma == 5) {
                this.I1 = 0.694;
                this.I2 = 1.385;
                this.sigmaVP = 0.1921;
            } else if (this.sigma == 6) {
                this.I1 = 0.63;
                this.I2 = 1.495;
                this.sigmaVP = 0.2348;
            } else if (this.sigma == 7) {
                this.I1 = 0.56;
                this.I2 = 1.627;
                this.sigmaVP = 0.2825;
            } else if (this.sigma == 8) {
                this.I1 = 0.48;
                this.I2 = 1.804;
                this.sigmaVP = 0.3354;
            } else if (this.sigma == 9) {
                this.I1 = 0.378;
                this.I2 = 2.094;
                this.sigmaVP = 0.3991;
            }
        }
        this.sigmaVPSqr = this.sigmaVP * this.sigmaVP;
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
        AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct).setAttributeInt("polsar_data", 1);
    }

    private void addSelectedBands() throws OperatorException {
        String[] bandNames = null;
        boolean copyInputBands = false;
        if (this.sourceProductType == PolBandUtils.MATRIX.FULL) {
            bandNames = PolBandUtils.getT3BandNames();
        } else {
            copyInputBands = true;
        }
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            String suffix = bandList.suffix;
            if (copyInputBands) {
                bandNames = new String[bandList.srcBands.length];
                int i = 0;
                for (Band band : bandList.srcBands) {
                    bandNames[i++] = band.getName();
                }
                suffix = "";
            }
            Band[] targetBands = OperatorUtils.addBands((Product)this.targetProduct, (String[])bandNames, (String)suffix);
            bandList.addTargetBands(targetBands);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            switch (this.filter) {
                case "Box Car Filter": {
                    if (this.sourceProductType == PolBandUtils.MATRIX.FULL) {
                        this.boxcarFilterFullPol(targetTiles, targetRectangle);
                        return;
                    }
                    if (this.sourceProductType != PolBandUtils.MATRIX.C3 && this.sourceProductType != PolBandUtils.MATRIX.T3 && this.sourceProductType != PolBandUtils.MATRIX.C4) {
                        if (this.sourceProductType != PolBandUtils.MATRIX.T4) throw new OperatorException("For Boxcar filter, only C3, T3, C4 and T4 are supported currently");
                    }
                    this.boxcarFilterC3T3C4T4(targetTiles, targetRectangle);
                    return;
                }
                case "Refined Lee Filter": {
                    if (this.sourceProductType == PolBandUtils.MATRIX.FULL) {
                        this.refinedLeeFilterFullPol(targetTiles, targetRectangle);
                        return;
                    }
                    if (this.sourceProductType != PolBandUtils.MATRIX.C3 && this.sourceProductType != PolBandUtils.MATRIX.T3 && this.sourceProductType != PolBandUtils.MATRIX.C4) {
                        if (this.sourceProductType != PolBandUtils.MATRIX.T4) throw new OperatorException("For Refined Lee filter, only C3, T3, C4 and T4 are supported currently");
                    }
                    this.refinedLeeFilterC3T3C4T4(targetTiles, targetRectangle);
                    return;
                }
                case "IDAN Filter": {
                    if (this.sourceProductType != PolBandUtils.MATRIX.FULL && this.sourceProductType != PolBandUtils.MATRIX.C3) {
                        if (this.sourceProductType != PolBandUtils.MATRIX.T3) throw new OperatorException("For IDAN filter, only C3 and T3 are supported currently");
                    }
                    this.idanFilter(targetTiles, targetRectangle);
                    return;
                }
                case "Improved Lee Sigma Filter": {
                    if (this.sourceProductType != PolBandUtils.MATRIX.FULL && this.sourceProductType != PolBandUtils.MATRIX.C3) {
                        if (this.sourceProductType != PolBandUtils.MATRIX.T3) throw new OperatorException("For Lee Sigma filter, only C3 and T3 are supported currently");
                    }
                    this.leeSigmaFilter(targetTiles, targetRectangle);
                    return;
                }
            }
            return;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            return;
        }
        finally {
            pm.done();
        }
    }

    private void boxcarFilterFullPol(Map<Band, Tile> targetTiles, Rectangle targetRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.getTargetProduct().getBandAt(0)));
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            Rectangle sourceRectangle = this.getSourceTileRectangle(x0, y0, w, h);
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int idx = trgIndex.getIndex(x);
                    PolOpUtils.getMeanCoherencyMatrix(x, y, this.halfFilterSize, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, srcIndex, dataBuffers, Tr, Ti);
                    for (Band targetBand : bandList.targetBands) {
                        String targetBandName = targetBand.getName();
                        ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                        if (targetBandName.equals("T11") || targetBandName.contains("T11_")) {
                            dataBuffer.setElemFloatAt(idx, (float)Tr[0][0]);
                            continue;
                        }
                        if (targetBandName.contains("T12_real")) {
                            dataBuffer.setElemFloatAt(idx, (float)Tr[0][1]);
                            continue;
                        }
                        if (targetBandName.contains("T12_imag")) {
                            dataBuffer.setElemFloatAt(idx, (float)Ti[0][1]);
                            continue;
                        }
                        if (targetBandName.contains("T13_real")) {
                            dataBuffer.setElemFloatAt(idx, (float)Tr[0][2]);
                            continue;
                        }
                        if (targetBandName.contains("T13_imag")) {
                            dataBuffer.setElemFloatAt(idx, (float)Ti[0][2]);
                            continue;
                        }
                        if (targetBandName.equals("T22") || targetBandName.contains("T22_")) {
                            dataBuffer.setElemFloatAt(idx, (float)Tr[1][1]);
                            continue;
                        }
                        if (targetBandName.contains("T23_real")) {
                            dataBuffer.setElemFloatAt(idx, (float)Tr[1][2]);
                            continue;
                        }
                        if (targetBandName.contains("T23_imag")) {
                            dataBuffer.setElemFloatAt(idx, (float)Ti[1][2]);
                            continue;
                        }
                        if (!targetBandName.equals("T33") && !targetBandName.contains("T33_")) continue;
                        dataBuffer.setElemFloatAt(idx, (float)Tr[2][2]);
                    }
                }
            }
        }
    }

    private void boxcarFilterC3T3C4T4(Map<Band, Tile> targetTiles, Rectangle targetRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        Rectangle sourceTileRectangle = this.getSourceTileRectangle(x0, y0, w, h);
        int sx0 = sourceTileRectangle.x;
        int sy0 = sourceTileRectangle.y;
        int sw = sourceTileRectangle.width;
        int sh = sourceTileRectangle.height;
        double[] neighborValues = new double[this.filterSize * this.filterSize];
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            for (Band targetBand : bandList.targetBands) {
                Tile targetTile = targetTiles.get(targetBand);
                ProductData dataBuffer = targetTile.getDataBuffer();
                Tile sourceTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(targetBand.getName()), sourceTileRectangle);
                for (int y = y0; y < maxY; ++y) {
                    for (int x = x0; x < maxX; ++x) {
                        int idx = targetTile.getDataBufferIndex(x, y);
                        this.getNeighborValues(x, y, sx0, sy0, sw, sh, sourceTile, neighborValues);
                        dataBuffer.setElemFloatAt(idx, (float)PolarimetricSpeckleFilterOp.getMeanValue(neighborValues));
                    }
                }
            }
        }
    }

    private void refinedLeeFilterFullPol(Map<Band, Tile> targetTiles, Rectangle targetRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        Rectangle sourceRectangle = this.getSourceTileRectangle(x0, y0, w, h);
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        double[][] data11Real = new double[sh][sw];
        double[][] data12Real = new double[sh][sw];
        double[][] data12Imag = new double[sh][sw];
        double[][] data13Real = new double[sh][sw];
        double[][] data13Imag = new double[sh][sw];
        double[][] data22Real = new double[sh][sw];
        double[][] data23Real = new double[sh][sw];
        double[][] data23Imag = new double[sh][sw];
        double[][] data33Real = new double[sh][sw];
        double[][] span = new double[sh][sw];
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.getTargetProduct().getBandAt(0)));
        int filterSize2 = this.filterSize * this.filterSize;
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            this.createT3SpanImage(bandList.srcBands[0], sourceRectangle, dataBuffers, data11Real, data12Real, data12Imag, data13Real, data13Imag, data22Real, data23Real, data23Imag, data33Real, span);
            double[][] neighborSpanValues = new double[this.filterSize][this.filterSize];
            double[][] neighborPixelValues = new double[this.filterSize][this.filterSize];
            ProductData[] targetDataBuffers = new ProductData[9];
            for (Band targetBand : bandList.targetBands) {
                String trgBandName = targetBand.getName();
                ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                if (targetDataBuffers[0] == null && (trgBandName.equals("T11") || trgBandName.contains("T11_"))) {
                    targetDataBuffers[0] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[1] == null && trgBandName.contains("T12_real")) {
                    targetDataBuffers[1] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[2] == null && trgBandName.contains("T12_imag")) {
                    targetDataBuffers[2] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[3] == null && trgBandName.contains("T13_real")) {
                    targetDataBuffers[3] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[4] == null && trgBandName.contains("T13_imag")) {
                    targetDataBuffers[4] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[5] == null && (trgBandName.equals("T22") || trgBandName.contains("T22_"))) {
                    targetDataBuffers[5] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[6] == null && trgBandName.contains("T23_real")) {
                    targetDataBuffers[6] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[7] == null && trgBandName.contains("T23_imag")) {
                    targetDataBuffers[7] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[8] != null || !trgBandName.equals("T33") && !trgBandName.contains("T33_")) continue;
                targetDataBuffers[8] = dataBuffer;
            }
            int i = 0;
            for (T3Elem elem : T3Elem.values()) {
                for (int y = y0; y < maxY; ++y) {
                    trgIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        int idx = trgIndex.getIndex(x);
                        int n = 0;
                        switch (elem) {
                            case T11: {
                                n = this.getLocalData(x, y, sourceRectangle, data11Real, span, neighborPixelValues, neighborSpanValues);
                                i = 0;
                                break;
                            }
                            case T12_real: {
                                n = this.getLocalData(x, y, sourceRectangle, data12Real, span, neighborPixelValues, neighborSpanValues);
                                i = 1;
                                break;
                            }
                            case T12_imag: {
                                n = this.getLocalData(x, y, sourceRectangle, data12Imag, span, neighborPixelValues, neighborSpanValues);
                                i = 2;
                                break;
                            }
                            case T13_real: {
                                n = this.getLocalData(x, y, sourceRectangle, data13Real, span, neighborPixelValues, neighborSpanValues);
                                i = 3;
                                break;
                            }
                            case T13_imag: {
                                n = this.getLocalData(x, y, sourceRectangle, data13Imag, span, neighborPixelValues, neighborSpanValues);
                                i = 4;
                                break;
                            }
                            case T22: {
                                n = this.getLocalData(x, y, sourceRectangle, data22Real, span, neighborPixelValues, neighborSpanValues);
                                i = 5;
                                break;
                            }
                            case T23_real: {
                                n = this.getLocalData(x, y, sourceRectangle, data23Real, span, neighborPixelValues, neighborSpanValues);
                                i = 6;
                                break;
                            }
                            case T23_imag: {
                                n = this.getLocalData(x, y, sourceRectangle, data23Imag, span, neighborPixelValues, neighborSpanValues);
                                i = 7;
                                break;
                            }
                            case T33: {
                                n = this.getLocalData(x, y, sourceRectangle, data33Real, span, neighborPixelValues, neighborSpanValues);
                                i = 8;
                                break;
                            }
                        }
                        if (n < filterSize2) {
                            targetDataBuffers[i].setElemFloatAt(idx, (float)this.computePixelValueUsingLocalStatistics(neighborPixelValues));
                            continue;
                        }
                        targetDataBuffers[i].setElemFloatAt(idx, (float)this.computePixelValueUsingEdgeDetection(neighborPixelValues, neighborSpanValues));
                    }
                }
            }
        }
    }

    private void refinedLeeFilterC3T3C4T4(Map<Band, Tile> targetTiles, Rectangle targetRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        Rectangle sourceTileRectangle = this.getSourceTileRectangle(x0, y0, w, h);
        int sx0 = sourceTileRectangle.x;
        int sy0 = sourceTileRectangle.y;
        int sw = sourceTileRectangle.width;
        int sh = sourceTileRectangle.height;
        int filterSize2 = this.filterSize * this.filterSize;
        double[][] neighborSpanValues = new double[this.filterSize][this.filterSize];
        double[][] neighborPixelValues = new double[this.filterSize][this.filterSize];
        int syMax = sy0 + sh;
        int sxMax = sx0 + sw;
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            double[][] span = new double[sh][sw];
            this.createSpanImage(bandList.srcBands, sourceTileRectangle, span);
            for (Band targetBand : bandList.targetBands) {
                Tile targetTile = targetTiles.get(targetBand);
                Tile sourceTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(targetBand.getName()), sourceTileRectangle);
                TileIndex trgIndex = new TileIndex(targetTile);
                TileIndex srcIndex = new TileIndex(sourceTile);
                ProductData dataBuffer = targetTile.getDataBuffer();
                float[] srcData = sourceTile.getDataBufferFloat();
                for (int y = y0; y < maxY; ++y) {
                    trgIndex.calculateStride(y);
                    int yhalf = y - this.halfFilterSize;
                    for (int x = x0; x < maxX; ++x) {
                        int xhalf = x - this.halfFilterSize;
                        int n = this.getNeighborValuesWithoutBorderExt(xhalf, yhalf, sx0, sy0, syMax, sxMax, neighborPixelValues, span, neighborSpanValues, srcIndex, srcData);
                        double v = n < filterSize2 ? this.computePixelValueUsingLocalStatistics(neighborPixelValues) : this.computePixelValueUsingEdgeDetection(neighborPixelValues, neighborSpanValues);
                        dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)v);
                    }
                }
            }
        }
    }

    private Rectangle getSourceTileRectangle(int x0, int y0, int w, int h) {
        int sx0 = x0;
        int sy0 = y0;
        int sw = w;
        int sh = h;
        if (x0 >= this.halfFilterSize) {
            sx0 -= this.halfFilterSize;
            sw += this.halfFilterSize;
        }
        if (y0 >= this.halfFilterSize) {
            sy0 -= this.halfFilterSize;
            sh += this.halfFilterSize;
        }
        if (x0 + w + this.halfFilterSize <= this.sourceImageWidth) {
            sw += this.halfFilterSize;
        }
        if (y0 + h + this.halfFilterSize <= this.sourceImageHeight) {
            sh += this.halfFilterSize;
        }
        return new Rectangle(sx0, sy0, sw, sh);
    }

    private void getNeighborValues(int x, int y, int sx0, int sy0, int sw, int sh, Tile sourceTile, double[] neighborValues) {
        ProductData sourceData = sourceTile.getDataBuffer();
        for (int i = 0; i < this.filterSize; ++i) {
            int xi = x - this.halfFilterSize + i;
            if (xi < sx0) {
                xi = sx0;
            } else if (xi >= sx0 + sw) {
                xi = sx0 + sw - 1;
            }
            int stride = i * this.filterSize;
            for (int j = 0; j < this.filterSize; ++j) {
                int yj = y - this.halfFilterSize + j;
                if (yj < sy0) {
                    yj = sy0;
                } else if (yj >= sy0 + sh) {
                    yj = sy0 + sh - 1;
                }
                neighborValues[j + stride] = sourceData.getElemDoubleAt(sourceTile.getDataBufferIndex(xi, yj));
            }
        }
    }

    private static double getMeanValue(double[] neighborValues) {
        double mean = 0.0;
        for (double neighborValue : neighborValues) {
            mean += neighborValue;
        }
        return mean /= (double)neighborValues.length;
    }

    private static double getVarianceValue(double[] neighborValues, double mean) {
        double var = 0.0;
        if (neighborValues.length > 1) {
            for (double neighborValue : neighborValues) {
                double diff = neighborValue - mean;
                var += diff * diff;
            }
            var /= (double)(neighborValues.length - 1);
        }
        return var;
    }

    private void createSpanImage(Band[] sourceBands, Rectangle sourceTileRectangle, double[][] span) {
        Tile[] sourceTiles;
        if (this.sourceProductType == PolBandUtils.MATRIX.C3 || this.sourceProductType == PolBandUtils.MATRIX.T3) {
            sourceTiles = new Tile[3];
        } else if (this.sourceProductType == PolBandUtils.MATRIX.C4 || this.sourceProductType == PolBandUtils.MATRIX.T4) {
            sourceTiles = new Tile[4];
        } else {
            throw new OperatorException("Polarimetric Matrix not supported");
        }
        for (Band band : sourceBands) {
            String bandName = band.getName();
            if (PolBandUtils.isBandForMatrixElement((String)bandName, (String)"11")) {
                sourceTiles[0] = this.getSourceTile((RasterDataNode)band, sourceTileRectangle);
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)bandName, (String)"22")) {
                sourceTiles[1] = this.getSourceTile((RasterDataNode)band, sourceTileRectangle);
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)bandName, (String)"33")) {
                sourceTiles[2] = this.getSourceTile((RasterDataNode)band, sourceTileRectangle);
                continue;
            }
            if (!PolBandUtils.isBandForMatrixElement((String)bandName, (String)"44")) continue;
            sourceTiles[3] = this.getSourceTile((RasterDataNode)band, sourceTileRectangle);
        }
        int sx0 = sourceTileRectangle.x;
        int sy0 = sourceTileRectangle.y;
        int sw = sourceTileRectangle.width;
        int sh = sourceTileRectangle.height;
        int maxY = sy0 + sh;
        int maxX = sx0 + sw;
        TileIndex srcIndex = new TileIndex(sourceTiles[0]);
        for (int y = sy0; y < maxY; ++y) {
            srcIndex.calculateStride(y);
            int spanY = y - sy0;
            for (int x = sx0; x < maxX; ++x) {
                int index = srcIndex.getIndex(x);
                double sum = 0.0;
                for (Tile srcTile : sourceTiles) {
                    sum += srcTile.getDataBuffer().getElemDoubleAt(index);
                }
                span[spanY][x - sx0] = sum / 4.0;
            }
        }
    }

    private int getNeighborValuesWithoutBorderExt(int xhalf, int yhalf, int sx0, int sy0, int syMax, int sxMax, double[][] neighborPixelValues, double[][] span, double[][] neighborSpanValues, TileIndex srcIndex, float[] srcData) {
        int k = 0;
        for (int j = 0; j < this.filterSize; ++j) {
            int yj = yhalf + j;
            if (yj < sy0 || yj >= syMax) {
                for (int i = 0; i < this.filterSize; ++i) {
                    neighborPixelValues[j][i] = -1.0;
                    neighborSpanValues[j][i] = -1.0;
                }
                continue;
            }
            int spanY = yj - sy0;
            srcIndex.calculateStride(yj);
            for (int i = 0; i < this.filterSize; ++i) {
                int xi = xhalf + i;
                if (xi < sx0 || xi >= sxMax) {
                    neighborPixelValues[j][i] = -1.0;
                    neighborSpanValues[j][i] = -1.0;
                    continue;
                }
                neighborPixelValues[j][i] = srcData[srcIndex.getIndex(xi)];
                neighborSpanValues[j][i] = span[spanY][xi - sx0];
                ++k;
            }
        }
        return k;
    }

    private double computePixelValueUsingLocalStatistics(double[][] neighborPixelValues) {
        double meanY = this.getLocalMeanValue(neighborPixelValues);
        double varY = this.getLocalVarianceValue(meanY, neighborPixelValues);
        if (varY == 0.0) {
            return 0.0;
        }
        double varX = (varY - meanY * meanY * this.sigmaVSqr) / (1.0 + this.sigmaVSqr);
        if (varX < 0.0) {
            varX = 0.0;
        }
        double b = varX / varY;
        return meanY + b * (neighborPixelValues[this.halfFilterSize][this.halfFilterSize] - meanY);
    }

    private double computePixelValueUsingEdgeDetection(double[][] neighborPixelValues, double[][] neighborSpanValues) {
        double[][] subAreaMeans = new double[3][3];
        PolarimetricSpeckleFilterOp.computeSubAreaMeans(this.stride, this.subWindowSize, neighborSpanValues, subAreaMeans);
        int d = PolarimetricSpeckleFilterOp.getDirection(subAreaMeans);
        double[] spanPixels = new double[this.convSize];
        this.getNonEdgeAreaPixelValues(neighborSpanValues, d, spanPixels);
        double meanY = PolarimetricSpeckleFilterOp.getMeanValue(spanPixels);
        double varY = PolarimetricSpeckleFilterOp.getVarianceValue(spanPixels, meanY);
        if (varY == 0.0) {
            return 0.0;
        }
        double varX = (varY - meanY * meanY * this.sigmaVSqr) / (1.0 + this.sigmaVSqr);
        if (varX < 0.0) {
            varX = 0.0;
        }
        double b = varX / varY;
        double[] covElemPixels = new double[this.convSize];
        this.getNonEdgeAreaPixelValues(neighborPixelValues, d, covElemPixels);
        double meanZ = PolarimetricSpeckleFilterOp.getMeanValue(covElemPixels);
        return meanZ + b * (neighborPixelValues[this.halfFilterSize][this.halfFilterSize] - meanZ);
    }

    private double getLocalMeanValue(double[][] neighborPixelValues) {
        int k = 0;
        double mean = 0.0;
        for (int j = 0; j < this.filterSize; ++j) {
            for (int i = 0; i < this.filterSize; ++i) {
                if (neighborPixelValues[j][i] == -1.0) continue;
                mean += neighborPixelValues[j][i];
                ++k;
            }
        }
        return mean / (double)k;
    }

    private double getLocalVarianceValue(double mean, double[][] neighborPixelValues) {
        int k = 0;
        double var = 0.0;
        for (int j = 0; j < this.filterSize; ++j) {
            for (int i = 0; i < this.filterSize; ++i) {
                if (neighborPixelValues[j][i] == -1.0) continue;
                double diff = neighborPixelValues[j][i] - mean;
                var += diff * diff;
                ++k;
            }
        }
        return var / (double)(k - 1);
    }

    private static void computeSubAreaMeans(int stride, int subWindowSize, double[][] neighborPixelValues, double[][] subAreaMeans) {
        double subWindowSizeSqr = subWindowSize * subWindowSize;
        for (int j = 0; j < 3; ++j) {
            int y0 = j * stride;
            for (int i = 0; i < 3; ++i) {
                int x0 = i * stride;
                double mean = 0.0;
                for (int y = y0; y < y0 + subWindowSize; ++y) {
                    for (int x = x0; x < x0 + subWindowSize; ++x) {
                        mean += neighborPixelValues[y][x];
                    }
                }
                subAreaMeans[j][i] = mean / subWindowSizeSqr;
            }
        }
    }

    private static int getDirection(double[][] subAreaMeans) {
        double[] gradient = new double[]{subAreaMeans[0][2] + subAreaMeans[1][2] + subAreaMeans[2][2] - subAreaMeans[0][0] - subAreaMeans[1][0] - subAreaMeans[2][0], subAreaMeans[0][1] + subAreaMeans[0][2] + subAreaMeans[1][2] - subAreaMeans[1][0] - subAreaMeans[2][0] - subAreaMeans[2][1], subAreaMeans[0][0] + subAreaMeans[0][1] + subAreaMeans[0][2] - subAreaMeans[2][0] - subAreaMeans[2][1] - subAreaMeans[2][2], subAreaMeans[0][0] + subAreaMeans[0][1] + subAreaMeans[1][0] - subAreaMeans[1][2] - subAreaMeans[2][1] - subAreaMeans[2][2]};
        int direction = 0;
        double maxGradient = -1.0;
        for (int i = 0; i < 4; ++i) {
            double absGrad = Math.abs(gradient[i]);
            if (!(maxGradient < absGrad)) continue;
            maxGradient = absGrad;
            direction = i;
        }
        if (gradient[direction] > 0.0) {
            direction += 4;
        }
        return direction;
    }

    private void getNonEdgeAreaPixelValues(double[][] neighborPixelValues, int d, double[] pixels) {
        switch (d) {
            case 0: {
                int k = 0;
                for (int y = 0; y < this.filterSize; ++y) {
                    for (int x = this.halfFilterSize; x < this.filterSize; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 1: {
                int k = 0;
                for (int y = 0; y < this.filterSize; ++y) {
                    for (int x = y; x < this.filterSize; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 2: {
                int k = 0;
                for (int y = 0; y <= this.halfFilterSize; ++y) {
                    for (int x = 0; x < this.filterSize; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 3: {
                int k = 0;
                for (int y = 0; y < this.filterSize; ++y) {
                    for (int x = 0; x < this.filterSize - y; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 4: {
                int k = 0;
                for (int y = 0; y < this.filterSize; ++y) {
                    for (int x = 0; x <= this.halfFilterSize; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 5: {
                int k = 0;
                for (int y = 0; y < this.filterSize; ++y) {
                    for (int x = 0; x < y + 1; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 6: {
                int k = 0;
                for (int y = this.halfFilterSize; y < this.filterSize; ++y) {
                    for (int x = 0; x < this.filterSize; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 7: {
                int k = 0;
                for (int y = 0; y < this.filterSize; ++y) {
                    for (int x = this.filterSize - 1 - y; x < this.filterSize; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
        }
    }

    private int getLocalData(int xc, int yc, Rectangle sourceRectangle, double[][] data, double[][] span, double[][] neighborPixelValues, double[][] neighborSpanValues) {
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        int syMax = sy0 + sh;
        int sxMax = sx0 + sw;
        int yhalf = yc - this.halfFilterSize;
        int xhalf = xc - this.halfFilterSize;
        int k = 0;
        for (int j = 0; j < this.filterSize; ++j) {
            int yj = yhalf + j;
            if (yj < sy0 || yj >= syMax) {
                for (int i = 0; i < this.filterSize; ++i) {
                    neighborPixelValues[j][i] = -1.0;
                    neighborSpanValues[j][i] = -1.0;
                }
                continue;
            }
            int spanY = yj - sy0;
            for (int i = 0; i < this.filterSize; ++i) {
                int xi = xhalf + i;
                if (xi < sx0 || xi >= sxMax) {
                    neighborPixelValues[j][i] = -1.0;
                    neighborSpanValues[j][i] = -1.0;
                    continue;
                }
                neighborPixelValues[j][i] = data[spanY][xi - sx0];
                neighborSpanValues[j][i] = span[spanY][xi - sx0];
                ++k;
            }
        }
        return k;
    }

    private void createT3SpanImage(Band srcBand0, Rectangle sourceRectangle, ProductData[] dataBuffers, double[][] data11Real, double[][] data12Real, double[][] data12Imag, double[][] data13Real, double[][] data13Imag, double[][] data22Real, double[][] data23Real, double[][] data23Imag, double[][] data33Real, double[][] span) {
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        int maxY = sy0 + sh;
        int maxX = sx0 + sw;
        TileIndex srcIndex = new TileIndex(this.getSourceTile((RasterDataNode)srcBand0, sourceRectangle));
        double[][] Mr = new double[3][3];
        double[][] Mi = new double[3][3];
        if (this.sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[][] Sr = new double[2][2];
            double[][] Si = new double[2][2];
            for (int y = sy0; y < maxY; ++y) {
                int j = y - sy0;
                srcIndex.calculateStride(y);
                for (int x = sx0; x < maxX; ++x) {
                    int i = x - sx0;
                    int index = srcIndex.getIndex(x);
                    PolOpUtils.getComplexScatterMatrix(index, dataBuffers, Sr, Si);
                    PolOpUtils.computeCoherencyMatrixT3(Sr, Si, Mr, Mi);
                    data11Real[j][i] = Mr[0][0];
                    data12Real[j][i] = Mr[0][1];
                    data12Imag[j][i] = Mi[0][1];
                    data13Real[j][i] = Mr[0][2];
                    data13Imag[j][i] = Mi[0][2];
                    data22Real[j][i] = Mr[1][1];
                    data23Real[j][i] = Mr[1][2];
                    data23Imag[j][i] = Mi[1][2];
                    data33Real[j][i] = Mr[2][2];
                    span[j][i] = (Mr[0][0] + Mr[1][1] + Mr[2][2]) / 4.0;
                }
            }
        } else if (this.sourceProductType == PolBandUtils.MATRIX.T3) {
            for (int y = sy0; y < maxY; ++y) {
                int j = y - sy0;
                srcIndex.calculateStride(y);
                for (int x = sx0; x < maxX; ++x) {
                    int i = x - sx0;
                    int index = srcIndex.getIndex(x);
                    PolOpUtils.getCoherencyMatrixT3(index, dataBuffers, Mr, Mi);
                    data11Real[j][i] = Mr[0][0];
                    data12Real[j][i] = Mr[0][1];
                    data12Imag[j][i] = Mi[0][1];
                    data13Real[j][i] = Mr[0][2];
                    data13Imag[j][i] = Mi[0][2];
                    data22Real[j][i] = Mr[1][1];
                    data23Real[j][i] = Mr[1][2];
                    data23Imag[j][i] = Mi[1][2];
                    data33Real[j][i] = Mr[2][2];
                    span[j][i] = (Mr[0][0] + Mr[1][1] + Mr[2][2]) / 4.0;
                }
            }
        } else if (this.sourceProductType == PolBandUtils.MATRIX.C3) {
            for (int y = sy0; y < maxY; ++y) {
                int j = y - sy0;
                srcIndex.calculateStride(y);
                for (int x = sx0; x < maxX; ++x) {
                    int i = x - sx0;
                    int index = srcIndex.getIndex(x);
                    PolOpUtils.getCovarianceMatrixC3(index, dataBuffers, Mr, Mi);
                    data11Real[j][i] = Mr[0][0];
                    data12Real[j][i] = Mr[0][1];
                    data12Imag[j][i] = Mi[0][1];
                    data13Real[j][i] = Mr[0][2];
                    data13Imag[j][i] = Mi[0][2];
                    data22Real[j][i] = Mr[1][1];
                    data23Real[j][i] = Mr[1][2];
                    data23Imag[j][i] = Mi[1][2];
                    data33Real[j][i] = Mr[2][2];
                    span[j][i] = (Mr[0][0] + Mr[1][1] + Mr[2][2]) / 4.0;
                }
            }
        } else {
            throw new OperatorException("Polarimetric Matrix not supported");
        }
    }

    private void idanFilter(Map<Band, Tile> targetTiles, Rectangle targetRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        Rectangle sourceRectangle = this.getSourceTileRectangle(x0, y0, w, h);
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        double[][] data11Real = new double[sh][sw];
        double[][] data12Real = new double[sh][sw];
        double[][] data12Imag = new double[sh][sw];
        double[][] data13Real = new double[sh][sw];
        double[][] data13Imag = new double[sh][sw];
        double[][] data22Real = new double[sh][sw];
        double[][] data23Real = new double[sh][sw];
        double[][] data23Imag = new double[sh][sw];
        double[][] data33Real = new double[sh][sw];
        double[][] span = new double[sh][sw];
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.getTargetProduct().getBandAt(0)));
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            this.createT3SpanImage(bandList.srcBands[0], sourceRectangle, dataBuffers, data11Real, data12Real, data12Imag, data13Real, data13Imag, data22Real, data23Real, data23Imag, data33Real, span);
            ProductData[] targetDataBuffers = new ProductData[9];
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"11")) {
                    targetDataBuffers[0] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_real")) {
                    targetDataBuffers[1] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_imag")) {
                    targetDataBuffers[2] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_real")) {
                    targetDataBuffers[3] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_imag")) {
                    targetDataBuffers[4] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"22")) {
                    targetDataBuffers[5] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_real")) {
                    targetDataBuffers[6] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_imag")) {
                    targetDataBuffers[7] = dataBuffer;
                    continue;
                }
                if (!PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"33")) continue;
                targetDataBuffers[8] = dataBuffer;
            }
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int idx = trgIndex.getIndex(x);
                    Seed seed = PolarimetricSpeckleFilterOp.getInitialSeed(x, y, sx0, sy0, sw, sh, data11Real, data22Real, data33Real);
                    Pix[] anPixelList = this.getIDANPixels(x, y, sx0, sy0, sw, sh, data11Real, data22Real, data33Real, seed);
                    double b = this.computeFilterScaleParam(sx0, sy0, anPixelList, span);
                    int i = 0;
                    double value = 0.0;
                    for (T3Elem elem : T3Elem.values()) {
                        switch (elem) {
                            case T11: {
                                value = PolarimetricSpeckleFilterOp.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data11Real, b);
                                i = 0;
                                break;
                            }
                            case T12_real: {
                                value = PolarimetricSpeckleFilterOp.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data12Real, b);
                                i = 1;
                                break;
                            }
                            case T12_imag: {
                                value = PolarimetricSpeckleFilterOp.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data12Imag, b);
                                i = 2;
                                break;
                            }
                            case T13_real: {
                                value = PolarimetricSpeckleFilterOp.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data13Real, b);
                                i = 3;
                                break;
                            }
                            case T13_imag: {
                                value = PolarimetricSpeckleFilterOp.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data13Imag, b);
                                i = 4;
                                break;
                            }
                            case T22: {
                                value = PolarimetricSpeckleFilterOp.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data22Real, b);
                                i = 5;
                                break;
                            }
                            case T23_real: {
                                value = PolarimetricSpeckleFilterOp.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data23Real, b);
                                i = 6;
                                break;
                            }
                            case T23_imag: {
                                value = PolarimetricSpeckleFilterOp.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data23Imag, b);
                                i = 7;
                                break;
                            }
                            case T33: {
                                value = PolarimetricSpeckleFilterOp.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data33Real, b);
                                i = 8;
                                break;
                            }
                        }
                        targetDataBuffers[i].setElemFloatAt(idx, (float)value);
                    }
                }
            }
        }
    }

    private static Seed getInitialSeed(int xc, int yc, int sx0, int sy0, int sw, int sh, double[][] data11Real, double[][] data22Real, double[][] data33Real) {
        double[] d11 = new double[9];
        double[] d22 = new double[9];
        double[] d33 = new double[9];
        int k = 0;
        for (int y = yc - 1; y <= yc + 1; ++y) {
            for (int x = xc - 1; x <= xc + 1; ++x) {
                if (x < sx0 || x >= sx0 + sw || y < sy0 || y >= sy0 + sh) continue;
                int r = y - sy0;
                int c = x - sx0;
                d11[k] = data11Real[r][c];
                d22[k] = data22Real[r][c];
                d33[k] = data33Real[r][c];
                ++k;
            }
        }
        Arrays.sort(d11, 0, k);
        Arrays.sort(d22, 0, k);
        Arrays.sort(d33, 0, k);
        int med = k / 2;
        Seed seed = new Seed();
        seed.value[0] = d11[med];
        seed.value[1] = d22[med];
        seed.value[2] = d33[med];
        seed.calculateAbsolutes();
        return seed;
    }

    private Pix[] getIDANPixels(int xc, int yc, int sx0, int sy0, int sw, int sh, double[][] data11Real, double[][] data22Real, double[][] data33Real, Seed seed) {
        double threshold50 = 2.0 * this.sigmaV;
        ArrayList<Pix> anPixelList = new ArrayList<Pix>(this.anSize);
        Pix[] bgPixelList = this.regionGrowing(xc, yc, sx0, sy0, sw, sh, data11Real, data22Real, data33Real, seed, threshold50, anPixelList);
        Seed newSeed = new Seed();
        if (!anPixelList.isEmpty()) {
            for (Pix pixel : anPixelList) {
                newSeed.value[0] = newSeed.value[0] + data11Real[pixel.y - sy0][pixel.x - sx0];
                newSeed.value[1] = newSeed.value[1] + data22Real[pixel.y - sy0][pixel.x - sx0];
                newSeed.value[2] = newSeed.value[2] + data33Real[pixel.y - sy0][pixel.x - sx0];
            }
            newSeed.value[0] = newSeed.value[0] / (double)anPixelList.size();
            newSeed.value[1] = newSeed.value[1] / (double)anPixelList.size();
            newSeed.value[2] = newSeed.value[2] / (double)anPixelList.size();
        } else {
            newSeed.value[0] = seed.value[0];
            newSeed.value[1] = seed.value[1];
            newSeed.value[2] = seed.value[2];
        }
        newSeed.calculateAbsolutes();
        double threshold95 = 6.0 * this.sigmaV;
        PolarimetricSpeckleFilterOp.reExamBackgroundPixels(sx0, sy0, data11Real, data22Real, data33Real, newSeed, threshold95, anPixelList, bgPixelList);
        if (anPixelList.isEmpty()) {
            return new Pix[]{new Pix(xc, yc)};
        }
        return anPixelList.toArray(new Pix[anPixelList.size()]);
    }

    private Pix[] regionGrowing(int xc, int yc, int sx0, int sy0, int sw, int sh, double[][] data11Real, double[][] data22Real, double[][] data33Real, Seed seed, double threshold, List<Pix> anPixelList) {
        int rc = yc - sy0;
        int cc = xc - sx0;
        HashMap<Integer, Boolean> visited = new HashMap<Integer, Boolean>(this.anSize + 8);
        ArrayList<Pix> bgPixelList = new ArrayList<Pix>(this.anSize);
        if (PolarimetricSpeckleFilterOp.distance(data11Real[rc][cc], data22Real[rc][cc], data33Real[rc][cc], seed) < threshold) {
            anPixelList.add(new Pix(xc, yc));
        } else {
            bgPixelList.add(new Pix(xc, yc));
        }
        visited.put(rc * sw + cc, true);
        ArrayList<Pix> front = new ArrayList<Pix>(this.anSize);
        front.add(new Pix(xc, yc));
        ArrayList<Pix> newfront = new ArrayList<Pix>(this.anSize);
        int width = sx0 + sw;
        int height = sy0 + sh;
        while (anPixelList.size() < this.anSize && !front.isEmpty()) {
            newfront.clear();
            for (Pix p : front) {
                int[] x = new int[]{p.x - 1, p.x, p.x + 1, p.x - 1, p.x + 1, p.x - 1, p.x, p.x + 1};
                int[] y = new int[]{p.y - 1, p.y - 1, p.y - 1, p.y, p.y, p.y + 1, p.y + 1, p.y + 1};
                for (int i = 0; i < 8; ++i) {
                    int c;
                    int r;
                    Integer index;
                    if (x[i] < sx0 || x[i] >= width || y[i] < sy0 || y[i] >= height || visited.get(index = Integer.valueOf((r = y[i] - sy0) * sw + (c = x[i] - sx0))) != null) continue;
                    visited.put(index, true);
                    Pix newPos = new Pix(x[i], y[i]);
                    if (PolarimetricSpeckleFilterOp.distance(data11Real[r][c], data22Real[r][c], data33Real[r][c], seed) < threshold) {
                        anPixelList.add(newPos);
                        newfront.add(newPos);
                        continue;
                    }
                    bgPixelList.add(newPos);
                }
                if (anPixelList.size() <= this.anSize) continue;
                break;
            }
            front.clear();
            front.addAll(newfront);
        }
        return bgPixelList.toArray(new Pix[bgPixelList.size()]);
    }

    private static double distance(double p0, double p1, double p2, Seed seed) {
        return Math.abs(p0 - seed.value[0]) / seed.absValue[0] + Math.abs(p1 - seed.value[1]) / seed.absValue[1] + Math.abs(p2 - seed.value[2]) / seed.absValue[2];
    }

    private static void reExamBackgroundPixels(int sx0, int sy0, double[][] data11Real, double[][] data22Real, double[][] data33Real, Seed seed, double threshold, List<Pix> anPixelList, Pix[] bgPixelList) {
        for (Pix pixel : bgPixelList) {
            int r = pixel.y - sy0;
            int c = pixel.x - sx0;
            if (!(PolarimetricSpeckleFilterOp.distance(data11Real[r][c], data22Real[r][c], data33Real[r][c], seed) < threshold)) continue;
            anPixelList.add(new Pix(pixel.x, pixel.y));
        }
    }

    private double computeFilterScaleParam(int sx0, int sy0, Pix[] anPixelList, double[][] span) {
        double[] spanPixels = new double[anPixelList.length];
        int k = 0;
        for (Pix pixel : anPixelList) {
            spanPixels[k++] = span[pixel.y - sy0][pixel.x - sx0];
        }
        return PolarimetricSpeckleFilterOp.computeMMSEWeight(spanPixels, this.sigmaVSqr);
    }

    private static double getIDANFilteredValue(int x, int y, int sx0, int sy0, Pix[] anPixelList, double[][] data, double b) {
        double mean = 0.0;
        for (Pix pixel : anPixelList) {
            mean += data[pixel.y - sy0][pixel.x - sx0];
        }
        return (mean /= (double)anPixelList.length) + b * (data[y - sy0][x - sx0] - mean);
    }

    private void leeSigmaFilter(Map<Band, Tile> targetTiles, Rectangle targetRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        Rectangle sourceRectangle = this.getSourceTileRectangle(x0, y0, w, h);
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.getTargetProduct().getBandAt(0)));
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] sourceDataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                sourceDataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            ProductData[] targetDataBuffers = new ProductData[9];
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"11")) {
                    targetDataBuffers[0] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_real")) {
                    targetDataBuffers[1] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_imag")) {
                    targetDataBuffers[2] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_real")) {
                    targetDataBuffers[3] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_imag")) {
                    targetDataBuffers[4] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"22")) {
                    targetDataBuffers[5] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_real")) {
                    targetDataBuffers[6] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_imag")) {
                    targetDataBuffers[7] = dataBuffer;
                    continue;
                }
                if (!PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"33")) continue;
                targetDataBuffers[8] = dataBuffer;
            }
            Z98 z98 = new Z98();
            this.computeZ98Values(sourceTiles[0], sourceRectangle, sourceDataBuffers, z98);
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            boolean[][] isPointTarget = new boolean[h][w];
            T3[][] filterWindowT3 = null;
            T3[][] targetWindowT3 = null;
            for (int y = y0; y < maxY; ++y) {
                int yy = y - y0;
                trgIndex.calculateStride(y);
                srcIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int xx = x - x0;
                    int trgIdx = trgIndex.getIndex(x);
                    int srcIdx = srcIndex.getIndex(x);
                    PolOpUtils.getT3(srcIdx, this.sourceProductType, sourceDataBuffers, Tr, Ti);
                    if (isPointTarget[yy][xx]) {
                        PolarimetricSpeckleFilterOp.saveT3(Tr, Ti, trgIdx, targetDataBuffers);
                        continue;
                    }
                    if (y - this.halfFilterSize < sy0 || y + this.halfFilterSize > sy0 + sh - 1 || x - this.halfFilterSize < sx0 || x + this.halfFilterSize > sx0 + sw - 1) {
                        filterWindowT3 = new T3[this.filterWindowSize][this.filterWindowSize];
                        this.getWindowPixelT3s(x, y, sourceDataBuffers, sx0, sy0, sw, sh, sourceTiles[0], filterWindowT3);
                        int n = this.setPixelsInSigmaRange(filterWindowT3);
                        this.computeFilteredT3(filterWindowT3, n, this.sigmaVSqr, Tr, Ti);
                        PolarimetricSpeckleFilterOp.saveT3(Tr, Ti, trgIdx, targetDataBuffers);
                        continue;
                    }
                    targetWindowT3 = new T3[this.targetWindowSize][this.targetWindowSize];
                    this.getWindowPixelT3s(x, y, sourceDataBuffers, sx0, sy0, sw, sh, sourceTiles[0], targetWindowT3);
                    if (this.checkPointTarget(z98, targetWindowT3, isPointTarget, x0, y0, w, h)) {
                        PolarimetricSpeckleFilterOp.saveT3(Tr, Ti, trgIdx, targetDataBuffers);
                        continue;
                    }
                    double[] sigmaRangeT11 = new double[2];
                    double[] sigmaRangeT22 = new double[2];
                    double[] sigmaRangeT33 = new double[2];
                    this.computeSigmaRange(targetWindowT3, 0, sigmaRangeT11);
                    this.computeSigmaRange(targetWindowT3, 1, sigmaRangeT22);
                    this.computeSigmaRange(targetWindowT3, 2, sigmaRangeT33);
                    filterWindowT3 = new T3[this.filterWindowSize][this.filterWindowSize];
                    this.getWindowPixelT3s(x, y, sourceDataBuffers, sx0, sy0, sw, sh, sourceTiles[0], filterWindowT3);
                    int n = this.selectPixelsInSigmaRange(sigmaRangeT11, sigmaRangeT22, sigmaRangeT33, filterWindowT3);
                    if (n == 0) {
                        PolarimetricSpeckleFilterOp.saveT3(Tr, Ti, trgIdx, targetDataBuffers);
                        continue;
                    }
                    this.computeFilteredT3(filterWindowT3, n, this.sigmaVPSqr, Tr, Ti);
                    PolarimetricSpeckleFilterOp.saveT3(Tr, Ti, trgIdx, targetDataBuffers);
                }
            }
        }
    }

    private void computeZ98Values(Tile sourceTile, Rectangle sourceRectangle, ProductData[] sourceDataBuffers, Z98 z98) {
        TileIndex srcIndex = new TileIndex(sourceTile);
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        int maxY = sy0 + sh;
        int maxX = sx0 + sw;
        int z98Index = (int)((double)(sw * sh) * 0.98) - 1;
        double[] t11 = new double[sw * sh];
        double[] t22 = new double[sw * sh];
        double[] t33 = new double[sw * sh];
        double[][] Tr = new double[3][3];
        double[][] Ti = new double[3][3];
        int k = 0;
        for (int y = sy0; y < maxY; ++y) {
            srcIndex.calculateStride(y);
            for (int x = sx0; x < maxX; ++x) {
                int index = srcIndex.getIndex(x);
                PolOpUtils.getT3(index, this.sourceProductType, sourceDataBuffers, Tr, Ti);
                t11[k] = Tr[0][0];
                t22[k] = Tr[1][1];
                t33[k] = Tr[2][2];
                ++k;
            }
        }
        Arrays.sort(t11);
        Arrays.sort(t22);
        Arrays.sort(t33);
        z98.t11 = t11[z98Index];
        z98.t22 = t22[z98Index];
        z98.t33 = t33[z98Index];
    }

    private static void saveT3(double[][] Tr, double[][] Ti, int idx, ProductData[] targetDataBuffers) {
        targetDataBuffers[0].setElemFloatAt(idx, (float)Tr[0][0]);
        targetDataBuffers[1].setElemFloatAt(idx, (float)Tr[0][1]);
        targetDataBuffers[2].setElemFloatAt(idx, (float)Ti[0][1]);
        targetDataBuffers[3].setElemFloatAt(idx, (float)Tr[0][2]);
        targetDataBuffers[4].setElemFloatAt(idx, (float)Ti[0][2]);
        targetDataBuffers[5].setElemFloatAt(idx, (float)Tr[1][1]);
        targetDataBuffers[6].setElemFloatAt(idx, (float)Tr[1][2]);
        targetDataBuffers[7].setElemFloatAt(idx, (float)Ti[1][2]);
        targetDataBuffers[8].setElemFloatAt(idx, (float)Tr[2][2]);
    }

    private void getWindowPixelT3s(int x, int y, ProductData[] sourceDataBuffers, int sx0, int sy0, int sw, int sh, Tile sourceTile, T3[][] windowPixelT3) {
        TileIndex srcIndex = new TileIndex(sourceTile);
        int windowSize = windowPixelT3.length;
        int halfWindowSize = windowSize / 2;
        double[][] Tr = new double[3][3];
        double[][] Ti = new double[3][3];
        for (int j = 0; j < windowSize; ++j) {
            int yy = y - halfWindowSize + j;
            srcIndex.calculateStride(yy);
            for (int i = 0; i < windowSize; ++i) {
                int xx = x - halfWindowSize + i;
                if (yy < sy0 || yy > sy0 + sh - 1 || xx < sx0 || xx > sx0 + sw - 1) continue;
                int srcIdx = srcIndex.getIndex(xx);
                PolOpUtils.getT3(srcIdx, this.sourceProductType, sourceDataBuffers, Tr, Ti);
                windowPixelT3[j][i] = new T3(xx, yy, Tr, Ti);
            }
        }
    }

    private boolean checkPointTarget(Z98 z98, T3[][] targetWindowT3, boolean[][] isPointTarget, int x0, int y0, int w, int h) {
        if (targetWindowT3[this.halfTargetWindowSize][this.halfTargetWindowSize].Tr[0][0] > z98.t11 && this.getClusterSize(z98.t11, targetWindowT3, 0) > this.targetSize) {
            this.markClusterPixels(isPointTarget, z98.t11, targetWindowT3, x0, y0, w, h, 0);
            return true;
        }
        if (targetWindowT3[this.halfTargetWindowSize][this.halfTargetWindowSize].Tr[1][1] > z98.t22 && this.getClusterSize(z98.t22, targetWindowT3, 1) > this.targetSize) {
            this.markClusterPixels(isPointTarget, z98.t22, targetWindowT3, x0, y0, w, h, 1);
            return true;
        }
        if (targetWindowT3[this.halfTargetWindowSize][this.halfTargetWindowSize].Tr[2][2] > z98.t33 && this.getClusterSize(z98.t33, targetWindowT3, 2) > this.targetSize) {
            this.markClusterPixels(isPointTarget, z98.t33, targetWindowT3, x0, y0, w, h, 2);
            return true;
        }
        return false;
    }

    private int getClusterSize(double threshold, T3[][] targetWindowT3, int elemIdx) {
        int clusterSize = 0;
        for (int j = 0; j < this.targetWindowSize; ++j) {
            for (int i = 0; i < this.targetWindowSize; ++i) {
                if (!(targetWindowT3[j][i].Tr[elemIdx][elemIdx] > threshold)) continue;
                ++clusterSize;
            }
        }
        return clusterSize;
    }

    private void markClusterPixels(boolean[][] isPointTarget, double threshold, T3[][] targetWindowT3, int x0, int y0, int w, int h, int elemIdx) {
        for (int j = 0; j < this.targetWindowSize; ++j) {
            for (int i = 0; i < this.targetWindowSize; ++i) {
                if (!(targetWindowT3[j][i].Tr[elemIdx][elemIdx] > threshold) || targetWindowT3[j][i].y < y0 || targetWindowT3[j][i].y >= y0 + h || targetWindowT3[j][i].x < x0 || targetWindowT3[j][i].x >= x0 + w) continue;
                isPointTarget[targetWindowT3[j][i].y - y0][targetWindowT3[j][i].x - x0] = true;
            }
        }
    }

    private void computeSigmaRange(T3[][] targetWindowT3, int elemIdx, double[] sigmaRange) {
        double[] data = new double[this.targetWindowSize * this.targetWindowSize];
        int k = 0;
        double mean = 0.0;
        for (int j = 0; j < this.targetWindowSize; ++j) {
            for (int i = 0; i < this.targetWindowSize; ++i) {
                data[k] = targetWindowT3[j][i].Tr[elemIdx][elemIdx];
                mean += data[k];
                ++k;
            }
        }
        double b = PolarimetricSpeckleFilterOp.computeMMSEWeight(data, this.sigmaVSqr);
        double filtered = (mean /= (double)k) + b * (data[k / 2] - mean);
        sigmaRange[0] = filtered * this.I1;
        sigmaRange[1] = filtered * this.I2;
    }

    private static double computeMMSEWeight(double[] dataArray, double sigmaVSqr) {
        double meanY = PolarimetricSpeckleFilterOp.getMeanValue(dataArray);
        double varY = PolarimetricSpeckleFilterOp.getVarianceValue(dataArray, meanY);
        if (varY == 0.0) {
            return 0.0;
        }
        double varX = (varY - meanY * meanY * sigmaVSqr) / (1.0 + sigmaVSqr);
        if (varX < 0.0) {
            varX = 0.0;
        }
        return varX / varY;
    }

    private int setPixelsInSigmaRange(T3[][] filterWindowT3) {
        int n = 0;
        for (int j = 0; j < this.filterWindowSize; ++j) {
            for (int i = 0; i < this.filterWindowSize; ++i) {
                if (filterWindowT3[j][i] == null) continue;
                filterWindowT3[j][i].inSigmaRange = true;
                ++n;
            }
        }
        return n;
    }

    private int selectPixelsInSigmaRange(double[] sigmaRangeT11, double[] sigmaRangeT22, double[] sigmaRangeT33, T3[][] filterWindowT3) {
        int numPixelsInSigmaRange = 0;
        for (int j = 0; j < this.filterWindowSize; ++j) {
            for (int i = 0; i < this.filterWindowSize; ++i) {
                if (filterWindowT3[j][i] == null || !(filterWindowT3[j][i].Tr[0][0] >= sigmaRangeT11[0]) || !(filterWindowT3[j][i].Tr[0][0] <= sigmaRangeT11[1]) || !(filterWindowT3[j][i].Tr[1][1] >= sigmaRangeT22[0]) || !(filterWindowT3[j][i].Tr[1][1] <= sigmaRangeT22[1]) || !(filterWindowT3[j][i].Tr[2][2] >= sigmaRangeT33[0]) || !(filterWindowT3[j][i].Tr[2][2] <= sigmaRangeT33[1])) continue;
                filterWindowT3[j][i].inSigmaRange = true;
                ++numPixelsInSigmaRange;
            }
        }
        return numPixelsInSigmaRange;
    }

    private void computeFilteredT3(T3[][] filterWindowT3, int n, double sigmaVSqr, double[][] Tr, double[][] Ti) {
        double[] span = new double[n];
        this.getSpan(filterWindowT3, span);
        double b = PolarimetricSpeckleFilterOp.computeMMSEWeight(span, sigmaVSqr);
        this.filterT3(filterWindowT3, b, n, Tr, Ti);
    }

    private void getSpan(T3[][] filterWindowT3, double[] span) {
        int k = 0;
        for (int j = 0; j < this.filterWindowSize; ++j) {
            for (int i = 0; i < this.filterWindowSize; ++i) {
                if (filterWindowT3[j][i] == null || !filterWindowT3[j][i].inSigmaRange) continue;
                span[k++] = filterWindowT3[j][i].Tr[0][0] + filterWindowT3[j][i].Tr[1][1] + filterWindowT3[j][i].Tr[2][2];
            }
        }
    }

    private void filterT3(T3[][] filterWindowT3, double b, int numPixelsInSigmaRange, double[][] filteredTr, double[][] filteredTi) {
        int n;
        int m;
        double[][] meanTr = new double[3][3];
        double[][] meanTi = new double[3][3];
        for (int j = 0; j < this.filterWindowSize; ++j) {
            for (int i = 0; i < this.filterWindowSize; ++i) {
                if (filterWindowT3[j][i] == null || !filterWindowT3[j][i].inSigmaRange) continue;
                for (int m2 = 0; m2 < 3; ++m2) {
                    for (int n2 = 0; n2 < 3; ++n2) {
                        double[] dArray = meanTr[m2];
                        int n3 = n2;
                        dArray[n3] = dArray[n3] + filterWindowT3[j][i].Tr[m2][n2];
                        double[] dArray2 = meanTi[m2];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + filterWindowT3[j][i].Ti[m2][n2];
                    }
                }
            }
        }
        for (m = 0; m < 3; ++m) {
            n = 0;
            while (n < 3) {
                double[] dArray = meanTr[m];
                int n5 = n;
                dArray[n5] = dArray[n5] / (double)numPixelsInSigmaRange;
                double[] dArray3 = meanTi[m];
                int n6 = n++;
                dArray3[n6] = dArray3[n6] / (double)numPixelsInSigmaRange;
            }
        }
        for (m = 0; m < 3; ++m) {
            for (n = 0; n < 3; ++n) {
                filteredTr[m][n] = (1.0 - b) * meanTr[m][n] + b * filterWindowT3[this.halfFilterSize][this.halfFilterSize].Tr[m][n];
                filteredTi[m][n] = (1.0 - b) * meanTi[m][n] + b * filterWindowT3[this.halfFilterSize][this.halfFilterSize].Ti[m][n];
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(PolarimetricSpeckleFilterOp.class);
        }
    }

    public static final class T3 {
        public int x = -1;
        public int y = -1;
        public final double[][] Tr = new double[3][3];
        public final double[][] Ti = new double[3][3];
        public boolean inSigmaRange = false;

        public T3(int x, int y, double[][] Tr, double[][] Ti) {
            this.x = x;
            this.y = y;
            for (int a = 0; a < Tr.length; ++a) {
                System.arraycopy(Tr[a], 0, this.Tr[a], 0, Tr[a].length);
                System.arraycopy(Ti[a], 0, this.Ti[a], 0, Ti[a].length);
            }
        }

        public T3() {
        }
    }

    public static final class Z98 {
        public double t11;
        public double t22;
        public double t33;
    }

    private static class Seed {
        final double[] value = new double[3];
        final double[] absValue = new double[3];

        private Seed() {
        }

        public void calculateAbsolutes() {
            this.absValue[0] = Math.abs(this.value[0]);
            this.absValue[1] = Math.abs(this.value[1]);
            this.absValue[2] = Math.abs(this.value[2]);
        }
    }

    private static final class Pix {
        final int x;
        final int y;

        public Pix(int xx, int yy) {
            this.x = xx;
            this.y = yy;
        }
    }

    public static enum T3Elem {
        T11,
        T12_real,
        T12_imag,
        T13_real,
        T13_imag,
        T22,
        T23_real,
        T23_imag,
        T33;

    }
}

