/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.gpf;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.beam.framework.ui.AppContext;
import org.esa.snap.gpf.ui.BaseOperatorUI;
import org.esa.snap.gpf.ui.UIValidation;
import org.esa.snap.util.DialogUtils;

public class PolarimetricSpeckleFilterOpUI
extends BaseOperatorUI {
    private final JComboBox filter = new JComboBox<String>(new String[]{"Box Car Filter", "IDAN Filter", "Refined Lee Filter", "Improved Lee Sigma Filter"});
    private final JComboBox numLooks = new JComboBox<String>(new String[]{"1", "2", "3", "4"});
    private final JComboBox windowSize = new JComboBox<String>(new String[]{"5x5", "7x7", "9x9", "11x11"});
    private final JComboBox filterWindowSize = new JComboBox<String>(new String[]{"7x7", "9x9", "11x11"});
    private final JComboBox targetWindowSize = new JComboBox<String>(new String[]{"3x3", "5x5"});
    private final JComboBox sigmaStr = new JComboBox<String>(new String[]{"0.5", "0.6", "0.7", "0.8", "0.9"});
    private static final JLabel filterLabel = new JLabel("Speckle Filter:");
    private static final JLabel filterSizeLabel = new JLabel("Filter Size:   ");
    private static final JLabel numLooksLabel = new JLabel("Number of Looks:");
    private static final JLabel windowSizeLabel = new JLabel("Window Size:");
    private static final JLabel filterWindowSizeLabel = new JLabel("Filter Window Size:");
    private static final JLabel targetWindowSizeLabel = new JLabel("Target Window Size:");
    private static final JLabel anSizeLabel = new JLabel("Adaptive Neighbourhood Size:");
    private static final JLabel sigmaStrLabel = new JLabel("Sigma:");
    private final JTextField filterSize = new JTextField("");
    private final JTextField anSize = new JTextField("");

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.filter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                PolarimetricSpeckleFilterOpUI.this.updateFilterSelection();
            }
        });
        this.updateFilterSelection();
        this.initParameters();
        return panel;
    }

    public void initParameters() {
        this.filter.setSelectedItem(this.paramMap.get("filter"));
        this.filterSize.setText(String.valueOf(this.paramMap.get("filterSize")));
        this.numLooks.setSelectedItem(this.paramMap.get("numLooksStr"));
        this.windowSize.setSelectedItem(this.paramMap.get("windowSize"));
        this.filterWindowSize.setSelectedItem(this.paramMap.get("filterWindowSizeStr"));
        this.targetWindowSize.setSelectedItem(this.paramMap.get("targetWindowSizeStr"));
        this.sigmaStr.setSelectedItem(this.paramMap.get("sigmaStr"));
        this.anSize.setText(String.valueOf(this.paramMap.get("anSize")));
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("filter", this.filter.getSelectedItem());
        this.paramMap.put("filterSize", Integer.parseInt(this.filterSize.getText()));
        this.paramMap.put("numLooksStr", this.numLooks.getSelectedItem());
        this.paramMap.put("windowSize", this.windowSize.getSelectedItem());
        this.paramMap.put("filterWindowSizeStr", this.filterWindowSize.getSelectedItem());
        this.paramMap.put("targetWindowSizeStr", this.targetWindowSize.getSelectedItem());
        this.paramMap.put("sigmaStr", this.sigmaStr.getSelectedItem());
        this.paramMap.put("anSize", Integer.parseInt(this.anSize.getText()));
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)filterLabel, (JComponent)this.filter);
        int savedY = ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)filterSizeLabel, (JComponent)this.filterSize);
        DialogUtils.enableComponents((JComponent)filterSizeLabel, (JComponent)this.filterSize, (boolean)true);
        gbc.gridy = savedY + 1;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)numLooksLabel, (JComponent)this.numLooks);
        DialogUtils.enableComponents((JComponent)numLooksLabel, (JComponent)this.numLooks, (boolean)false);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)windowSizeLabel, (JComponent)this.windowSize);
        DialogUtils.enableComponents((JComponent)windowSizeLabel, (JComponent)this.windowSize, (boolean)false);
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)anSizeLabel, (JComponent)this.anSize);
        DialogUtils.enableComponents((JComponent)anSizeLabel, (JComponent)this.anSize, (boolean)false);
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)sigmaStrLabel, (JComponent)this.sigmaStr);
        DialogUtils.enableComponents((JComponent)sigmaStrLabel, (JComponent)this.sigmaStr, (boolean)false);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)filterWindowSizeLabel, (JComponent)this.filterWindowSize);
        DialogUtils.enableComponents((JComponent)filterWindowSizeLabel, (JComponent)this.filterWindowSize, (boolean)false);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)targetWindowSizeLabel, (JComponent)this.targetWindowSize);
        DialogUtils.enableComponents((JComponent)targetWindowSizeLabel, (JComponent)this.targetWindowSize, (boolean)false);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private void updateFilterSelection() {
        String item;
        switch (item = (String)this.filter.getSelectedItem()) {
            case "Refined Lee Filter": {
                DialogUtils.enableComponents((JComponent)numLooksLabel, (JComponent)this.numLooks, (boolean)true);
                DialogUtils.enableComponents((JComponent)windowSizeLabel, (JComponent)this.windowSize, (boolean)true);
                DialogUtils.enableComponents((JComponent)filterSizeLabel, (JComponent)this.filterSize, (boolean)false);
                DialogUtils.enableComponents((JComponent)anSizeLabel, (JComponent)this.anSize, (boolean)false);
                DialogUtils.enableComponents((JComponent)sigmaStrLabel, (JComponent)this.sigmaStr, (boolean)false);
                DialogUtils.enableComponents((JComponent)filterWindowSizeLabel, (JComponent)this.filterWindowSize, (boolean)false);
                DialogUtils.enableComponents((JComponent)targetWindowSizeLabel, (JComponent)this.targetWindowSize, (boolean)false);
                break;
            }
            case "IDAN Filter": {
                DialogUtils.enableComponents((JComponent)numLooksLabel, (JComponent)this.numLooks, (boolean)true);
                DialogUtils.enableComponents((JComponent)anSizeLabel, (JComponent)this.anSize, (boolean)true);
                DialogUtils.enableComponents((JComponent)windowSizeLabel, (JComponent)this.windowSize, (boolean)false);
                DialogUtils.enableComponents((JComponent)filterSizeLabel, (JComponent)this.filterSize, (boolean)false);
                DialogUtils.enableComponents((JComponent)sigmaStrLabel, (JComponent)this.sigmaStr, (boolean)false);
                DialogUtils.enableComponents((JComponent)filterWindowSizeLabel, (JComponent)this.filterWindowSize, (boolean)false);
                DialogUtils.enableComponents((JComponent)targetWindowSizeLabel, (JComponent)this.targetWindowSize, (boolean)false);
                break;
            }
            case "Improved Lee Sigma Filter": {
                DialogUtils.enableComponents((JComponent)numLooksLabel, (JComponent)this.numLooks, (boolean)true);
                DialogUtils.enableComponents((JComponent)sigmaStrLabel, (JComponent)this.sigmaStr, (boolean)true);
                DialogUtils.enableComponents((JComponent)filterWindowSizeLabel, (JComponent)this.filterWindowSize, (boolean)true);
                DialogUtils.enableComponents((JComponent)targetWindowSizeLabel, (JComponent)this.targetWindowSize, (boolean)true);
                DialogUtils.enableComponents((JComponent)anSizeLabel, (JComponent)this.anSize, (boolean)false);
                DialogUtils.enableComponents((JComponent)windowSizeLabel, (JComponent)this.windowSize, (boolean)false);
                DialogUtils.enableComponents((JComponent)filterSizeLabel, (JComponent)this.filterSize, (boolean)false);
                break;
            }
            default: {
                DialogUtils.enableComponents((JComponent)numLooksLabel, (JComponent)this.numLooks, (boolean)false);
                DialogUtils.enableComponents((JComponent)windowSizeLabel, (JComponent)this.windowSize, (boolean)false);
                DialogUtils.enableComponents((JComponent)filterSizeLabel, (JComponent)this.filterSize, (boolean)true);
                DialogUtils.enableComponents((JComponent)anSizeLabel, (JComponent)this.anSize, (boolean)false);
                DialogUtils.enableComponents((JComponent)sigmaStrLabel, (JComponent)this.sigmaStr, (boolean)false);
                DialogUtils.enableComponents((JComponent)filterWindowSizeLabel, (JComponent)this.filterWindowSize, (boolean)false);
                DialogUtils.enableComponents((JComponent)targetWindowSizeLabel, (JComponent)this.targetWindowSize, (boolean)false);
            }
        }
    }
}

