/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.gpf.decompositions;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.gpf.PolOpUtils;
import org.csa.rstb.gpf.decompositions.Decomposition;
import org.csa.rstb.gpf.decompositions.DecompositionBase;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.Tile;
import org.esa.nest.dataio.PolBandUtils;
import org.esa.snap.gpf.TileIndex;

public class Cloude
extends DecompositionBase
implements Decomposition {
    public Cloude(PolBandUtils.QuadSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight) {
        super(srcBandList, sourceProductType, windowSize, srcImageWidth, srcImageHeight);
    }

    @Override
    public String[] getTargetBandNames() {
        return new String[]{"Cloude_dbl_r", "Cloude_vol_g", "Cloude_surf_b"};
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        targetBand.setUnit("intensity_db");
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            DecompositionBase.TargetInfo[] targetInfo = new DecompositionBase.TargetInfo[bandList.targetBands.length];
            int j = 0;
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                if (targetBandName.contains("Cloude_dbl_r")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.R);
                } else if (targetBandName.contains("Cloude_vol_g")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.G);
                } else if (targetBandName.contains("Cloude_surf_b")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.B);
                }
                ++j;
            }
            TileIndex trgIndex = new TileIndex(targetInfo[0].tile);
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = op.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            double[][] EigenVectRe = new double[3][3];
            double[][] EigenVectIm = new double[3][3];
            double[] EigenVal = new double[3];
            double v = 0.0;
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    PolOpUtils.getMeanCoherencyMatrix(x, y, this.halfWindowSize, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, srcIndex, dataBuffers, Tr, Ti);
                    PolOpUtils.eigenDecomposition(3, Tr, Ti, EigenVectRe, EigenVectIm, EigenVal);
                    double t11 = EigenVal[0] * (EigenVectRe[0][0] * EigenVectRe[0][0] + EigenVectIm[0][0] * EigenVectIm[0][0]);
                    double t22 = EigenVal[0] * (EigenVectRe[1][0] * EigenVectRe[1][0] + EigenVectIm[1][0] * EigenVectIm[1][0]);
                    double t33 = EigenVal[0] * (EigenVectRe[2][0] * EigenVectRe[2][0] + EigenVectIm[2][0] * EigenVectIm[2][0]);
                    for (DecompositionBase.TargetInfo target : targetInfo) {
                        if (target.colour == DecompositionBase.TargetBandColour.R) {
                            v = t22;
                        } else if (target.colour == DecompositionBase.TargetBandColour.G) {
                            v = t33;
                        } else if (target.colour == DecompositionBase.TargetBandColour.B) {
                            v = t11;
                        }
                        if (v < 1.0E-15) {
                            v = 1.0E-15;
                        }
                        v = 10.0 * Math.log10(v);
                        target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)v);
                    }
                }
            }
        }
    }
}

