/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.gpf.decompositions;

import java.awt.Dimension;
import java.awt.Rectangle;
import org.csa.rstb.gpf.PolOpUtils;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.Tile;
import org.esa.nest.dataio.PolBandUtils;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.StatusProgressMonitor;
import org.esa.snap.gpf.ThreadManager;

public class DecompositionBase {
    protected PolBandUtils.QuadSourceBand[] srcBandList;
    protected final PolBandUtils.MATRIX sourceProductType;
    protected final int windowSize;
    protected final int halfWindowSize;
    protected final int sourceImageWidth;
    protected final int sourceImageHeight;

    public DecompositionBase(PolBandUtils.QuadSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight) {
        this.srcBandList = srcBandList;
        this.sourceProductType = sourceProductType;
        this.windowSize = windowSize;
        this.sourceImageWidth = srcImageWidth;
        this.sourceImageHeight = srcImageHeight;
        this.halfWindowSize = windowSize / 2;
    }

    protected Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th) {
        int x0 = Math.max(0, tx0 - this.halfWindowSize);
        int y0 = Math.max(0, ty0 - this.halfWindowSize);
        int xMax = Math.min(tx0 + tw - 1 + this.halfWindowSize, this.sourceImageWidth - 1);
        int yMax = Math.min(ty0 + th - 1 + this.halfWindowSize, this.sourceImageHeight - 1);
        int w = xMax - x0 + 1;
        int h = yMax - y0 + 1;
        return new Rectangle(x0, y0, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MinMax computeSpanMinMax(final Operator op, final PolBandUtils.QuadSourceBand bandList) throws OperatorException {
        final MinMax minMaxValue = new MinMax();
        Dimension tileSize = new Dimension(256, 256);
        Rectangle[] tileRectangles = OperatorUtils.getAllTileRectangles((Product)op.getSourceProduct(), (Dimension)tileSize, (int)25);
        final double[][] Cr = new double[3][3];
        final double[][] Ci = new double[3][3];
        StatusProgressMonitor status = new StatusProgressMonitor((float)tileRectangles.length, "Computing min max span... ");
        status.setAllowStdOut(false);
        try {
            ThreadManager threadManager = new ThreadManager();
            int tileCnt = 0;
            for (final Rectangle rectangle : tileRectangles) {
                Thread worker = new Thread(){
                    double span = 0.0;
                    final int xMax;
                    final int yMax;
                    final Tile[] sourceTiles;
                    final ProductData[] dataBuffers;
                    {
                        this.xMax = rectangle.x + rectangle.width;
                        this.yMax = rectangle.y + rectangle.height;
                        this.sourceTiles = new Tile[bandList.srcBands.length];
                        this.dataBuffers = new ProductData[bandList.srcBands.length];
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            for (int i = 0; i < this.sourceTiles.length; ++i) {
                                this.sourceTiles[i] = op.getSourceTile((RasterDataNode)bandList.srcBands[i], rectangle);
                                this.dataBuffers[i] = this.sourceTiles[i].getDataBuffer();
                            }
                            for (int y = rectangle.y; y < this.yMax; ++y) {
                                for (int x = rectangle.x; x < this.xMax; ++x) {
                                    MinMax minMax;
                                    PolOpUtils.getMeanCovarianceMatrix(x, y, DecompositionBase.this.halfWindowSize, DecompositionBase.this.sourceImageWidth, DecompositionBase.this.sourceImageHeight, DecompositionBase.this.sourceProductType, this.sourceTiles, this.dataBuffers, Cr, Ci);
                                    this.span = Cr[0][0] + Cr[1][1] + Cr[2][2];
                                    if (minMaxValue.min > this.span) {
                                        minMax = minMaxValue;
                                        synchronized (minMax) {
                                            minMaxValue.min = this.span;
                                        }
                                    }
                                    if (!(minMaxValue.max < this.span)) continue;
                                    minMax = minMaxValue;
                                    synchronized (minMax) {
                                        minMaxValue.max = this.span;
                                        continue;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(tileCnt++);
            }
            threadManager.finish();
            if (minMaxValue.min < 1.0E-15) {
                minMaxValue.min = 1.0E-15;
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(op.getId() + " computeMinMaxSpan "), (Throwable)e);
        }
        finally {
            status.done();
        }
        return minMaxValue;
    }

    protected static double scaleDb(double p, double spanMin, double spanMax) {
        if (p > spanMax) {
            p = spanMax;
        }
        if (p < 1.0E-15) {
            p = spanMin;
        }
        return 10.0 * Math.log10(p);
    }

    protected synchronized void setSpanMinMax(Operator op, PolBandUtils.QuadSourceBand bandList) throws OperatorException {
        if (bandList.spanMinMaxSet) {
            return;
        }
        MinMax span = this.computeSpanMinMax(op, bandList);
        bandList.spanMin = span.min;
        bandList.spanMax = span.max;
        bandList.spanMinMaxSet = true;
    }

    public static class TargetInfo {
        public final Tile tile;
        public final ProductData dataBuffer;
        public final TargetBandColour colour;

        public TargetInfo(Tile tile, TargetBandColour col) {
            this.tile = tile;
            this.dataBuffer = tile.getDataBuffer();
            this.colour = col;
        }
    }

    public static class MinMax {
        public double min = 1.0E30;
        public double max = -this.min;
    }

    public static enum TargetBandColour {
        R,
        G,
        B;

    }
}

