/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.gpf.decompositions;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.gpf.PolOpUtils;
import org.csa.rstb.gpf.decompositions.Decomposition;
import org.csa.rstb.gpf.decompositions.DecompositionBase;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.Tile;
import org.esa.nest.dataio.PolBandUtils;
import org.esa.snap.gpf.TileIndex;

public class Sinclair
extends DecompositionBase
implements Decomposition {
    public Sinclair(PolBandUtils.QuadSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight) {
        super(srcBandList, sourceProductType, windowSize, srcImageWidth, srcImageHeight);
    }

    @Override
    public String[] getTargetBandNames() {
        return new String[]{"Sinclair_r", "Sinclair_g", "Sinclair_b"};
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        targetBand.setUnit("intensity_db");
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            DecompositionBase.TargetInfo[] targetInfo = new DecompositionBase.TargetInfo[bandList.targetBands.length];
            int j = 0;
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                if (targetBandName.contains("Sinclair_r")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.R);
                } else if (targetBandName.contains("Sinclair_g")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.G);
                } else if (targetBandName.contains("Sinclair_b")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.B);
                }
                ++j;
            }
            TileIndex trgIndex = new TileIndex(targetInfo[0].tile);
            double[][] Sr = new double[2][2];
            double[][] Si = new double[2][2];
            double[][] Cr = new double[3][3];
            double[][] Ci = new double[3][3];
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = op.getSourceTile((RasterDataNode)bandList.srcBands[i], targetRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            double re = 0.0;
            double im = 0.0;
            double v = 0.0;
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int index = trgIndex.getIndex(x);
                    if (this.sourceProductType == PolBandUtils.MATRIX.FULL) {
                        PolOpUtils.getComplexScatterMatrix(index, dataBuffers, Sr, Si);
                        for (DecompositionBase.TargetInfo target : targetInfo) {
                            if (target.colour == DecompositionBase.TargetBandColour.R) {
                                re = Sr[1][1];
                                im = Si[1][1];
                            } else if (target.colour == DecompositionBase.TargetBandColour.G) {
                                re = 0.5 * (Sr[0][1] + Sr[1][0]);
                                im = 0.5 * (Si[0][1] + Si[1][0]);
                            } else if (target.colour == DecompositionBase.TargetBandColour.B) {
                                re = Sr[0][0];
                                im = Si[0][0];
                            }
                            v = re * re + im * im;
                            if (v < 1.0E-15) {
                                v = 1.0E-15;
                            }
                            v = 10.0 * Math.log10(v);
                            target.dataBuffer.setElemFloatAt(index, (float)v);
                        }
                        continue;
                    }
                    if (this.sourceProductType == PolBandUtils.MATRIX.C3) {
                        PolOpUtils.getCovarianceMatrixC3(index, dataBuffers, Cr, Ci);
                        for (DecompositionBase.TargetInfo target : targetInfo) {
                            if (target.colour == DecompositionBase.TargetBandColour.R) {
                                v = Cr[2][2];
                            } else if (target.colour == DecompositionBase.TargetBandColour.G) {
                                v = 0.5 * Cr[1][1];
                            } else if (target.colour == DecompositionBase.TargetBandColour.B) {
                                v = Cr[0][0];
                            }
                            if (v < 1.0E-15) {
                                v = 1.0E-15;
                            }
                            v = 10.0 * Math.log10(v);
                            target.dataBuffer.setElemFloatAt(index, (float)v);
                        }
                        continue;
                    }
                    if (this.sourceProductType != PolBandUtils.MATRIX.T3) continue;
                    PolOpUtils.getCoherencyMatrixT3(index, dataBuffers, Tr, Ti);
                    for (DecompositionBase.TargetInfo target : targetInfo) {
                        if (target.colour == DecompositionBase.TargetBandColour.R) {
                            v = 0.5 * (Tr[0][0] + Tr[1][1]) - Tr[0][1];
                        } else if (target.colour == DecompositionBase.TargetBandColour.G) {
                            v = 0.5 * Tr[2][2];
                        } else if (target.colour == DecompositionBase.TargetBandColour.B) {
                            v = 0.5 * (Tr[0][0] + Tr[1][1]) + Tr[0][1];
                        }
                        if (v < 1.0E-15) {
                            v = 1.0E-15;
                        }
                        v = 10.0 * Math.log10(v);
                        target.dataBuffer.setElemFloatAt(index, (float)v);
                    }
                }
            }
        }
    }
}

