/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.gpf.decompositions;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.gpf.PolOpUtils;
import org.csa.rstb.gpf.decompositions.Decomposition;
import org.csa.rstb.gpf.decompositions.DecompositionBase;
import org.csa.rstb.gpf.decompositions.FreemanDurden;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.Tile;
import org.esa.nest.dataio.PolBandUtils;
import org.esa.snap.gpf.TileIndex;

public class Yamaguchi
extends DecompositionBase
implements Decomposition {
    public Yamaguchi(PolBandUtils.QuadSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight) {
        super(srcBandList, sourceProductType, windowSize, srcImageWidth, srcImageHeight);
    }

    @Override
    public String[] getTargetBandNames() {
        return new String[]{"Yamaguchi_dbl_r", "Yamaguchi_vol_g", "Yamaguchi_surf_b", "Yamaguchi_hlx"};
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        targetBand.setUnit("intensity_db");
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            DecompositionBase.TargetInfo[] targetInfo = new DecompositionBase.TargetInfo[bandList.targetBands.length];
            int j = 0;
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                if (targetBandName.contains("Yamaguchi_dbl_r")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.R);
                } else if (targetBandName.contains("Yamaguchi_vol_g")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.G);
                } else if (targetBandName.contains("Yamaguchi_surf_b")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.B);
                } else if (targetBandName.contains("Yamaguchi_hlx")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), null);
                }
                ++j;
            }
            TileIndex trgIndex = new TileIndex(targetInfo[0].tile);
            double[][] Cr = new double[3][3];
            double[][] Ci = new double[3][3];
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            if (!bandList.spanMinMaxSet) {
                this.setSpanMinMax(op, bandList);
            }
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = op.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    double pd;
                    double ps;
                    double k3;
                    double k2;
                    double k1;
                    PolOpUtils.getMeanCovarianceMatrix(x, y, this.halfWindowSize, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, sourceTiles, dataBuffers, Cr, Ci);
                    PolOpUtils.c3ToT3(Cr, Ci, Tr, Ti);
                    double span = Tr[0][0] + Tr[1][1] + Tr[2][2];
                    double pc = 2.0 * Math.abs(Ti[1][2]);
                    double ratio = 10.0 * Math.log10(Cr[2][2] / Cr[0][0]);
                    if (ratio <= -2.0) {
                        k1 = 0.16666666666666666;
                        k2 = 0.23333333333333334;
                        k3 = 0.26666666666666666;
                    } else if (ratio > 2.0) {
                        k1 = -0.16666666666666666;
                        k2 = 0.23333333333333334;
                        k3 = 0.26666666666666666;
                    } else {
                        k1 = 0.0;
                        k2 = 0.25;
                        k3 = 0.25;
                    }
                    double pv = (Tr[2][2] - 0.5 * pc) / k3;
                    if (pv <= 0.0) {
                        pc = 0.0;
                        FreemanDurden.FDD data = FreemanDurden.getFreemanDurdenDecomposition(Cr, Ci);
                        ps = data.ps;
                        pd = data.pd;
                        pv = data.pv;
                    } else {
                        double s = Tr[0][0] - 0.5 * pv;
                        double d = Tr[1][1] - k2 * pv - 0.5 * pc;
                        double cR = Tr[0][1] - k1 * pv;
                        double cI = Ti[0][1];
                        if (pv + pc < span) {
                            double c0 = Cr[0][2] - 0.5 * Cr[1][1] + 0.5 * pc;
                            if (c0 < 0.0) {
                                ps = s - (cR * cR + cI * cI) / d;
                                pd = d + (cR * cR + cI * cI) / d;
                            } else {
                                ps = s + (cR * cR + cI * cI) / s;
                                pd = d - (cR * cR + cI * cI) / s;
                            }
                            if (ps > 0.0 && pd < 0.0) {
                                pd = 0.0;
                                ps = span - pv - pc;
                            } else if (ps < 0.0 && pd > 0.0) {
                                ps = 0.0;
                                pd = span - pv - pc;
                            } else if (ps < 0.0 && pd < 0.0) {
                                ps = 0.0;
                                pd = 0.0;
                                pv = span - pc;
                            }
                        } else {
                            ps = 0.0;
                            pd = 0.0;
                            pv = span - pc;
                        }
                    }
                    ps = Yamaguchi.scaleDb(ps, bandList.spanMin, bandList.spanMax);
                    pd = Yamaguchi.scaleDb(pd, bandList.spanMin, bandList.spanMax);
                    pv = Yamaguchi.scaleDb(pv, bandList.spanMin, bandList.spanMax);
                    pc = Yamaguchi.scaleDb(pc, bandList.spanMin, bandList.spanMax);
                    for (DecompositionBase.TargetInfo target : targetInfo) {
                        if (target.colour == DecompositionBase.TargetBandColour.R) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)pd);
                            continue;
                        }
                        if (target.colour == DecompositionBase.TargetBandColour.G) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)pv);
                            continue;
                        }
                        if (target.colour == DecompositionBase.TargetBandColour.B) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)ps);
                            continue;
                        }
                        target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)pc);
                    }
                }
            }
        }
    }
}

