/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.gpf.decompositions;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.csa.rstb.gpf.PolOpUtils;
import org.csa.rstb.gpf.decompositions.Decomposition;
import org.csa.rstb.gpf.decompositions.DecompositionBase;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.Tile;
import org.esa.nest.dataio.PolBandUtils;
import org.esa.snap.gpf.TileIndex;

public class hAAlpha
extends DecompositionBase
implements Decomposition {
    private final boolean outputHAAlpha;
    private final boolean outputBetaDeltaGammaLambda;
    private final boolean outputAlpha123;
    private final boolean outputLambda123;
    private static final double LOG_3 = Math.log(3.0);

    public hAAlpha(PolBandUtils.QuadSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight, boolean outputHAAlpha, boolean outputBetaDeltaGammaLambda, boolean outputAlpha123, boolean outputLambda123) {
        super(srcBandList, sourceProductType, windowSize, srcImageWidth, srcImageHeight);
        this.outputHAAlpha = outputHAAlpha;
        this.outputBetaDeltaGammaLambda = outputBetaDeltaGammaLambda;
        this.outputAlpha123 = outputAlpha123;
        this.outputLambda123 = outputLambda123;
    }

    @Override
    public String[] getTargetBandNames() {
        ArrayList<String> targetBandNameList = new ArrayList<String>(4);
        if (!(this.outputHAAlpha || this.outputBetaDeltaGammaLambda || this.outputAlpha123 || this.outputLambda123)) {
            throw new OperatorException("Please select decomposition parameters to output");
        }
        if (this.outputHAAlpha) {
            targetBandNameList.add("Entropy");
            targetBandNameList.add("Anisotropy");
            targetBandNameList.add("Alpha");
        }
        if (this.outputBetaDeltaGammaLambda) {
            targetBandNameList.add("Beta");
            targetBandNameList.add("Delta");
            targetBandNameList.add("Gamma");
            targetBandNameList.add("Lambda");
        }
        if (this.outputAlpha123) {
            targetBandNameList.add("Alpha1");
            targetBandNameList.add("Alpha2");
            targetBandNameList.add("Alpha3");
        }
        if (this.outputLambda123) {
            targetBandNameList.add("Lambda1");
            targetBandNameList.add("Lambda2");
            targetBandNameList.add("Lambda3");
        }
        return targetBandNameList.toArray(new String[targetBandNameList.size()]);
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        if (targetBandName.contains("Entropy")) {
            targetBand.setUnit("entropy");
        } else if (targetBandName.contains("Anisotropy")) {
            targetBand.setUnit("anisotropy");
        } else if (targetBandName.equals("Alpha") || targetBandName.contains("Alpha_")) {
            targetBand.setUnit("deg");
        } else if (targetBandName.contains("Alpha1")) {
            targetBand.setUnit("deg");
        } else if (targetBandName.contains("Alpha2")) {
            targetBand.setUnit("deg");
        } else if (targetBandName.contains("Alpha3")) {
            targetBand.setUnit("deg");
        } else if (targetBandName.contains("Beta")) {
            targetBand.setUnit("deg");
        } else if (targetBandName.contains("Delta")) {
            targetBand.setUnit("deg");
        } else if (targetBandName.contains("Gamma")) {
            targetBand.setUnit("deg");
        } else if (targetBandName.equals("Lambda") || targetBandName.contains("Lambda_")) {
            targetBand.setUnit("lambda");
        } else if (targetBandName.contains("Lambda1")) {
            targetBand.setUnit("lambda");
        } else if (targetBandName.contains("Lambda2")) {
            targetBand.setUnit("lambda");
        } else if (targetBandName.contains("Lambda3")) {
            targetBand.setUnit("lambda");
        }
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        TileIndex trgIndex = new TileIndex(targetTiles.get(op.getTargetProduct().getBandAt(0)));
        double[][] Tr = new double[3][3];
        double[][] Ti = new double[3][3];
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = op.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int idx = trgIndex.getIndex(x);
                    PolOpUtils.getMeanCoherencyMatrix(x, y, this.halfWindowSize, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, srcIndex, dataBuffers, Tr, Ti);
                    HAAlpha data = hAAlpha.computeHAAlpha(Tr, Ti);
                    for (Band band : bandList.targetBands) {
                        String targetBandName = band.getName();
                        ProductData dataBuffer = targetTiles.get(band).getDataBuffer();
                        if (this.outputHAAlpha) {
                            if (targetBandName.contains("Entropy")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.entropy);
                            } else if (targetBandName.contains("Anisotropy")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.anisotropy);
                            } else if (targetBandName.equals("Alpha") || targetBandName.contains("Alpha_")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.alpha);
                            }
                        }
                        if (this.outputBetaDeltaGammaLambda) {
                            if (targetBandName.contains("Beta")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.beta);
                            } else if (targetBandName.contains("Delta")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.delta);
                            } else if (targetBandName.contains("Gamma")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.gamma);
                            } else if (targetBandName.equals("Lambda") || targetBandName.contains("Lambda_")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.lambda);
                            }
                        }
                        if (this.outputAlpha123) {
                            if (targetBandName.contains("Alpha1")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.alpha1);
                            } else if (targetBandName.contains("Alpha2")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.alpha2);
                            } else if (targetBandName.contains("Alpha3")) {
                                dataBuffer.setElemFloatAt(idx, (float)data.alpha3);
                            }
                        }
                        if (!this.outputLambda123) continue;
                        if (targetBandName.contains("Lambda1")) {
                            dataBuffer.setElemFloatAt(idx, (float)data.lambda1);
                            continue;
                        }
                        if (targetBandName.contains("Lambda2")) {
                            dataBuffer.setElemFloatAt(idx, (float)data.lambda2);
                            continue;
                        }
                        if (!targetBandName.contains("Lambda3")) continue;
                        dataBuffer.setElemFloatAt(idx, (float)data.lambda3);
                    }
                }
            }
        }
    }

    public static HAAlpha computeHAAlpha(double[][] Tr, double[][] Ti) {
        double[][] EigenVectRe = new double[3][3];
        double[][] EigenVectIm = new double[3][3];
        double[] EigenVal = new double[3];
        double[] lambda = new double[3];
        double[] p = new double[3];
        double[] alpha = new double[3];
        double[] phi = new double[3];
        double[] beta = new double[3];
        double[] delta = new double[3];
        double[] gamma = new double[3];
        PolOpUtils.eigenDecomposition(3, Tr, Ti, EigenVectRe, EigenVectIm, EigenVal);
        double sum = 0.0;
        for (int i = 0; i < 3; ++i) {
            lambda[i] = EigenVal[i];
            sum += lambda[i];
        }
        double EPS = 1.0E-15;
        for (int j = 0; j < 3; ++j) {
            alpha[j] = FastMath.acos((double)hAAlpha.norm(EigenVectRe[0][j], EigenVectIm[0][j])) * 57.29577951308232;
            beta[j] = Math.atan2(hAAlpha.norm(EigenVectRe[2][j], EigenVectIm[2][j]), 1.0E-15 + hAAlpha.norm(EigenVectRe[1][j], EigenVectIm[1][j])) * 57.29577951308232;
            phi[j] = Math.atan2(EigenVectIm[0][j], 1.0E-15 + EigenVectRe[0][j]);
            delta[j] = Math.atan2(EigenVectIm[1][j], 1.0E-15 + EigenVectRe[1][j]) - phi[j];
            delta[j] = Math.atan2(FastMath.sin((double)delta[j]), FastMath.cos((double)delta[j]) + 1.0E-15) * 57.29577951308232;
            gamma[j] = Math.atan2(EigenVectIm[2][j], 1.0E-15 + EigenVectRe[2][j]) - phi[j];
            gamma[j] = Math.atan2(FastMath.sin((double)gamma[j]), FastMath.cos((double)gamma[j]) + 1.0E-15) * 57.29577951308232;
            p[j] = lambda[j] / sum;
            if (p[j] < 0.0) {
                p[j] = 0.0;
                continue;
            }
            if (!(p[j] > 1.0)) continue;
            p[j] = 1.0;
        }
        double meanLambda = 0.0;
        double meanAlpha = 0.0;
        double meanBeta = 0.0;
        double meanDelta = 0.0;
        double meanGamma = 0.0;
        double entropy = 0.0;
        for (int k = 0; k < 3; ++k) {
            meanLambda += p[k] * lambda[k];
            meanAlpha += p[k] * alpha[k];
            meanBeta += p[k] * beta[k];
            meanDelta += p[k] * delta[k];
            meanGamma += p[k] * gamma[k];
            entropy -= p[k] * Math.log(p[k] + 1.0E-15);
        }
        double anisotropy = (p[1] - p[2]) / (p[1] + p[2] + 1.0E-15);
        return new HAAlpha(entropy /= LOG_3, anisotropy, meanAlpha, meanBeta, meanDelta, meanGamma, meanLambda, alpha[0], alpha[1], alpha[2], lambda[0], lambda[1], lambda[2]);
    }

    public static double norm(double real, double imag) {
        return Math.sqrt(real * real + imag * imag);
    }

    public static class HAAlpha {
        public final double entropy;
        public final double anisotropy;
        public final double alpha;
        public final double beta;
        public final double delta;
        public final double gamma;
        public final double lambda;
        public final double alpha1;
        public final double alpha2;
        public final double alpha3;
        public final double lambda1;
        public final double lambda2;
        public final double lambda3;

        public HAAlpha(double H, double A, double alpha, double beta, double delta, double gamma, double lambda, double alpha1, double alpha2, double alpha3, double lambda1, double lambda2, double lambda3) {
            this.entropy = H;
            this.anisotropy = A;
            this.alpha = alpha;
            this.beta = beta;
            this.delta = delta;
            this.gamma = gamma;
            this.lambda = lambda;
            this.alpha1 = alpha1;
            this.alpha2 = alpha2;
            this.alpha3 = alpha3;
            this.lambda1 = lambda1;
            this.lambda2 = lambda2;
            this.lambda3 = lambda3;
        }
    }
}

