/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.gpf.decompositions;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.gpf.PolOpUtils;
import org.csa.rstb.gpf.decompositions.Decomposition;
import org.csa.rstb.gpf.decompositions.DecompositionBase;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.Tile;
import org.esa.nest.dataio.PolBandUtils;
import org.esa.snap.gpf.TileIndex;

public class vanZyl
extends DecompositionBase
implements Decomposition {
    public vanZyl(PolBandUtils.QuadSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight) {
        super(srcBandList, sourceProductType, windowSize, srcImageWidth, srcImageHeight);
    }

    @Override
    public String[] getTargetBandNames() {
        return new String[]{"vanZyl_dbl_r", "vanZyl_vol_g", "vanZyl_surf_b"};
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        targetBand.setUnit("intensity_db");
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (PolBandUtils.QuadSourceBand bandList : this.srcBandList) {
            DecompositionBase.TargetInfo[] targetInfo = new DecompositionBase.TargetInfo[bandList.targetBands.length];
            int j = 0;
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                if (targetBandName.contains("vanZyl_dbl_r")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.R);
                } else if (targetBandName.contains("vanZyl_vol_g")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.G);
                } else if (targetBandName.contains("vanZyl_surf_b")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.B);
                }
                ++j;
            }
            TileIndex trgIndex = new TileIndex(targetInfo[0].tile);
            double[][] Cr = new double[3][3];
            double[][] Ci = new double[3][3];
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            if (!bandList.spanMinMaxSet) {
                this.setSpanMinMax(op, bandList);
            }
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = op.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    if (this.sourceProductType == PolBandUtils.MATRIX.FULL || this.sourceProductType == PolBandUtils.MATRIX.C3) {
                        PolOpUtils.getMeanCovarianceMatrix(x, y, this.halfWindowSize, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, sourceTiles, dataBuffers, Cr, Ci);
                        PolOpUtils.c3ToT3(Cr, Ci, Tr, Ti);
                    } else if (this.sourceProductType == PolBandUtils.MATRIX.T3) {
                        PolOpUtils.getMeanCoherencyMatrix(x, y, this.halfWindowSize, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, srcIndex, dataBuffers, Tr, Ti);
                        PolOpUtils.t3ToC3(Tr, Ti, Cr, Ci);
                    }
                    double alpha = Cr[0][0];
                    double mu = Cr[2][2] / Cr[0][0];
                    double eta = Cr[1][1] / Cr[0][0];
                    double rhoRe = Cr[0][2] / Cr[0][0];
                    double rhoIm = Ci[0][2] / Cr[0][0];
                    double rho2 = rhoRe * rhoRe + rhoIm * rhoIm;
                    double delta = Math.sqrt((1.0 - mu) * (1.0 - mu) + 4.0 * rho2);
                    double lambda1 = 0.5 * alpha * (1.0 + mu + delta);
                    double lambda2 = 0.5 * alpha * (1.0 + mu - delta);
                    double lambda3 = alpha * eta;
                    double tmp1 = (mu - 1.0 + delta) * (mu - 1.0 + delta);
                    double tmp2 = tmp1 + 4.0 * rho2;
                    double fs = lambda1 * tmp1 / tmp2;
                    tmp1 = (mu - 1.0 - delta) * (mu - 1.0 - delta);
                    tmp2 = tmp1 + 4.0 * rho2;
                    double fd = lambda2 * tmp1 / tmp2;
                    double fv = lambda3;
                    fs = vanZyl.scaleDb(fs, bandList.spanMin, bandList.spanMax);
                    fd = vanZyl.scaleDb(fd, bandList.spanMin, bandList.spanMax);
                    fv = vanZyl.scaleDb(fv, bandList.spanMin, bandList.spanMax);
                    for (DecompositionBase.TargetInfo target : targetInfo) {
                        if (target.colour == DecompositionBase.TargetBandColour.R) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)fd);
                            continue;
                        }
                        if (target.colour == DecompositionBase.TargetBandColour.G) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)fv);
                            continue;
                        }
                        if (target.colour != DecompositionBase.TargetBandColour.B) continue;
                        target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)fs);
                    }
                }
            }
        }
    }
}

