/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;

public class CeosFileReader {
    private static final String EM_EXPECTED_X_FOUND_Y_BYTES = "Expected bytes to read %d, but only found %d";
    private static final String EM_READING_X_TYPE = "Reading '%s'-Type";
    private static final String EM_NOT_PARSABLE_X_STRING = "Not able to parse %s string";
    private ImageInputStream _stream;

    public CeosFileReader(ImageInputStream stream) {
        this._stream = stream;
    }

    public void close() throws IOException {
        this._stream.close();
    }

    public void seek(long pos) throws IOException {
        this._stream.seek(pos);
    }

    public void skipBytes(long numBytes) throws IOException {
        this._stream.skipBytes(numBytes);
    }

    public int readB1() throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        try {
            return this._stream.readByte() & 0xFF;
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "B1");
            throw new IllegalCeosFormatException(message, streamPosition, e);
        }
    }

    public short readB2() throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        try {
            return this._stream.readShort();
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "B2");
            throw new IllegalCeosFormatException(message, streamPosition, e);
        }
    }

    public int readB4() throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        try {
            return this._stream.readInt();
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "B4");
            throw new IllegalCeosFormatException(message, streamPosition, e);
        }
    }

    public long readB8() throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        try {
            return this._stream.readLong();
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "B8");
            throw new IllegalCeosFormatException(message, streamPosition, e);
        }
    }

    public void readB4(int[] array) throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        for (int i = 0; i < array.length; ++i) {
            try {
                array[i] = this.readB4();
                continue;
            }
            catch (IllegalCeosFormatException e) {
                String message = String.format(EM_READING_X_TYPE, "B4[]");
                throw new IllegalCeosFormatException(message, streamPosition, e);
            }
        }
    }

    public void readB8(long[] array) throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        for (int i = 0; i < array.length; ++i) {
            try {
                array[i] = this.readB8();
                continue;
            }
            catch (IllegalCeosFormatException e) {
                String message = String.format(EM_READING_X_TYPE, "B8[]");
                throw new IllegalCeosFormatException(message, streamPosition, e);
            }
        }
    }

    public int readI4() throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        try {
            return (int)this.readIn(4);
        }
        catch (IllegalCeosFormatException e) {
            String message = String.format(EM_READING_X_TYPE, "In");
            throw new IllegalCeosFormatException(message, streamPosition, e);
        }
    }

    public long readIn(int n) throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        String longStr = this.readAn(n).trim();
        return this.parseLong(longStr, streamPosition);
    }

    private long parseLong(String integerStr, long streamPosition) throws IllegalCeosFormatException {
        long number;
        try {
            number = Long.parseLong(integerStr);
        }
        catch (NumberFormatException e) {
            String message = String.format(EM_NOT_PARSABLE_X_STRING, "integer");
            throw new IllegalCeosFormatException(message, streamPosition, e);
        }
        return number;
    }

    public void readB1(byte[] array) throws IOException, IllegalCeosFormatException {
        int bytesRead;
        long streamPosition = this._stream.getStreamPosition();
        try {
            bytesRead = this._stream.read(array);
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "B1[]");
            throw new IllegalCeosFormatException(message, streamPosition, e);
        }
        if (bytesRead != array.length) {
            String message = String.format(EM_EXPECTED_X_FOUND_Y_BYTES, array.length, bytesRead);
            throw new IllegalCeosFormatException(message, streamPosition);
        }
    }

    public double readFn(int n) throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        String doubleString = this.readAn(n).trim();
        try {
            return Double.parseDouble(doubleString);
        }
        catch (NumberFormatException e) {
            String message = String.format(EM_NOT_PARSABLE_X_STRING, "double");
            throw new IllegalCeosFormatException(message, streamPosition, e);
        }
    }

    public double readEn(int n) throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        try {
            return this.readFn(n);
        }
        catch (IllegalCeosFormatException e) {
            String message = String.format(EM_READING_X_TYPE, "En");
            throw new IllegalCeosFormatException(message, streamPosition, e);
        }
    }

    public double readGn(int n) throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        try {
            return this.readFn(n);
        }
        catch (IllegalCeosFormatException e) {
            String message = String.format(EM_READING_X_TYPE, "Gn");
            throw new IllegalCeosFormatException(message, streamPosition, e);
        }
    }

    public void readGn(int n, double[] numbers) throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        for (int i = 0; i < numbers.length; ++i) {
            try {
                numbers[i] = this.readGn(n);
                continue;
            }
            catch (IllegalCeosFormatException e) {
                String message = String.format(EM_READING_X_TYPE, "Gn[]");
                throw new IllegalCeosFormatException(message, streamPosition, e);
            }
        }
    }

    public String readAn(int n) throws IOException, IllegalCeosFormatException {
        int bytesRead;
        long streamPosition = this._stream.getStreamPosition();
        byte[] bytes = new byte[n];
        try {
            bytesRead = this._stream.read(bytes);
        }
        catch (IOException e) {
            String message = String.format(EM_READING_X_TYPE, "An");
            throw new IllegalCeosFormatException(message, streamPosition, e);
        }
        if (bytesRead != n) {
            String message = String.format(EM_EXPECTED_X_FOUND_Y_BYTES, n, bytesRead);
            throw new IllegalCeosFormatException(message, streamPosition);
        }
        return new String(bytes);
    }

    public int[] readInArray(int arraySize, int intValLength) throws IOException, IllegalCeosFormatException {
        long streamPosition = this._stream.getStreamPosition();
        int[] ints = new int[arraySize];
        for (int i = 0; i < ints.length; ++i) {
            String integerString = this.readAn(intValLength).trim();
            if (integerString.length() <= 0) continue;
            ints[i] = (int)this.parseLong(integerString, streamPosition + (long)(i * intValLength));
        }
        return ints;
    }

    public long getCurrentPos() throws IOException {
        return this._stream.getStreamPosition();
    }
}

