/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.avnir2;

import java.io.IOException;
import java.util.Calendar;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.avnir2.records.Avnir2Ancillary1Record;
import org.esa.beam.dataio.ceos.avnir2.records.Avnir2Ancillary2Record;
import org.esa.beam.dataio.ceos.avnir2.records.Avnir2LeaderFDR;
import org.esa.beam.dataio.ceos.avnir2.records.Avnir2SceneHeaderRecord;
import org.esa.beam.dataio.ceos.records.Ancillary3Record;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;

class Avnir2LeaderFile {
    private static final String UNIT_METER = "meter";
    private static final String UNIT_KILOMETER = "kilometer";
    private static final String UNIT_DEGREE = "degree";
    private static final String UNIT_SECOND = "second";
    private static final String UNIT_METER_PER_SECOND = "m/sec";
    private static final String UNIT_DEGREE_PER_SECOND = "deg/sec";
    private static final String PROJECTION_KEY_RAW = "NNNNN";
    private static final String PROJECTION_KEY_UTM = "YNNNN";
    private static final String PROJECTION_KEY_PS = "NNNNY";
    public final Avnir2LeaderFDR _leaderFDR;
    public final Avnir2SceneHeaderRecord _sceneHeaderRecord;
    public final Avnir2Ancillary1Record _ancillary1Record;
    public final Avnir2Ancillary2Record _ancillary2Record;
    public final Ancillary3Record _ancillary3Record;
    public CeosFileReader _reader;

    public Avnir2LeaderFile(ImageInputStream leaderStream) throws IOException, IllegalCeosFormatException {
        this._reader = new CeosFileReader(leaderStream);
        this._leaderFDR = new Avnir2LeaderFDR(this._reader);
        this._sceneHeaderRecord = new Avnir2SceneHeaderRecord(this._reader);
        this._ancillary1Record = new Avnir2Ancillary1Record(this._reader);
        this._ancillary2Record = new Avnir2Ancillary2Record(this._reader);
        this._ancillary3Record = new Ancillary3Record(this._reader);
    }

    public String getProductLevel() throws IOException, IllegalCeosFormatException {
        return this._sceneHeaderRecord.getProductLevel();
    }

    public String getProcessingCode() throws IOException, IllegalCeosFormatException {
        return this._sceneHeaderRecord.getProcessingCode();
    }

    public Calendar getDateImageWasTaken() {
        return this._sceneHeaderRecord.getDateImageWasTaken();
    }

    public double[] getLatCorners() throws IOException, IllegalCeosFormatException {
        double latUL = this._sceneHeaderRecord.getSceneCornerUpperLeftLat();
        double latUR = this._sceneHeaderRecord.getSceneCornerUpperRightLat();
        double latLL = this._sceneHeaderRecord.getSceneCornerLowerLeftLat();
        double latLR = this._sceneHeaderRecord.getSceneCornerLowerRightLat();
        return new double[]{latUL, latUR, latLL, latLR};
    }

    public double[] getLonCorners() throws IOException, IllegalCeosFormatException {
        double lonUL = this._sceneHeaderRecord.getSceneCornerUpperLeftLon();
        double lonUR = this._sceneHeaderRecord.getSceneCornerUpperRightLon();
        double lonLL = this._sceneHeaderRecord.getSceneCornerLowerLeftLon();
        double lonLR = this._sceneHeaderRecord.getSceneCornerLowerLeftLat();
        return new double[]{lonUL, lonUR, lonLL, lonLR};
    }

    public String getUsedProjection() throws IOException, IllegalCeosFormatException {
        return this._sceneHeaderRecord.getMapProjectionMethod().trim();
    }

    public long getNominalPixelsPerLine_1A_1B1() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNumNominalPixelsPerLine_1A_1B1();
    }

    public long getNominalLinesPerScene_1A_1B1() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNumNominalLinesPerScene_1A_1B1();
    }

    public double getNominalInterPixelDistance_1A_1B1() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNominalInterPixelDistance_1A_1B1();
    }

    public double getNominalInterLineDistance_1A_1B1() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNominalInterLineDistance_1A_1B1();
    }

    public double getImageSkew() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getImageSkew();
    }

    private double getNumNominalPixelsPerLine() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNumNominalPixelsPerLine();
    }

    private double getNumNominalLinesPerScene() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNumNominalLinesPerScene();
    }

    public double getNominalInterPixelDistance() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNominalInterPixelDistance();
    }

    public double getNominalInterLineDistance() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNominalInterLineDistance();
    }

    public String getReferenceEllipsoidName() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getReferenceEllipsoid();
    }

    public double getSemiMinorAxis() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getSemiminorAxisOfReferenceEllipsoid();
    }

    public double getSemiMajorAxis() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getSemimajorAxisOfReferenceEllipsoid();
    }

    public String getDatumName() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getGeodeticCoordinateName();
    }

    public long getUTMZoneIndex() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getUTMZoneNumber();
    }

    public boolean isUTMSouthHemisphere() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getHemisphere() == 1;
    }

    public double getUTMEasting() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getSceneCenterEasting();
    }

    public double getUTMNorthing() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getSceneCenterNorthing();
    }

    public double getUTMOrientationAngle() throws IOException, IllegalCeosFormatException {
        double radian = this._ancillary1Record.getAngleBetweenMapUTMVerticalAndTrueNorth();
        return Math.toDegrees(radian);
    }

    public GeoPos getPSProjectionOrigin() throws IOException, IllegalCeosFormatException {
        double lat = this._ancillary1Record.getMapProjOriginLat();
        double lon = this._ancillary1Record.getMapProjOriginLon();
        return new GeoPos((float)lat, (float)lon);
    }

    public GeoPos getPSReferencePoint() throws IOException, IllegalCeosFormatException {
        double lat = this._ancillary1Record.getPSReferenceLat();
        double lon = this._ancillary1Record.getPSReferenceLon();
        return new GeoPos((float)lat, (float)lon);
    }

    public double getPSXCoordinate() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getSceneCenterX();
    }

    public double getPSYCoordinate() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getSceneCenterY();
    }

    public double getPSOrientationAngle() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getAngleBetweenMapPSVerticalAndTrueNorth();
    }

    public double[][] getCorrectedTransformationCoeffs() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getTransformationCoeffsL1B2();
    }

    public double[][] getUncorrectedTransformationCoeffs(int bandIndex) throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getTransformationCoefficientsFor(bandIndex);
    }

    public double getAbsoluteCalibrationGain(int bandIndex) throws IOException, IllegalCeosFormatException {
        return this._ancillary2Record.getAbsoluteCalibrationGain(bandIndex);
    }

    public double getAbsoluteCalibrationOffset(int bandIndex) throws IOException, IllegalCeosFormatException {
        return this._ancillary2Record.getAbsoluteCalibrationOffset(bandIndex);
    }

    public double[] getAbsoluteCalibrationGains() throws IOException, IllegalCeosFormatException {
        double[] gains = new double[4];
        for (int i = 0; i < gains.length; ++i) {
            gains[i] = this.getAbsoluteCalibrationGain(i + 1);
        }
        return gains;
    }

    public double[] getAbsoluteCalibrationOffsets() throws IOException, IllegalCeosFormatException {
        double[] offsets = new double[4];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = this.getAbsoluteCalibrationOffset(i + 1);
        }
        return offsets;
    }

    public String getSensorMode() throws IOException, IllegalCeosFormatException {
        return this._ancillary2Record.getSensorOperationMode();
    }

    public int getLowerLimitStrength() throws IOException, IllegalCeosFormatException {
        return this._ancillary2Record.getLowerLimitOfStrengthAfterCorrection();
    }

    public int getUpperLimitStrength() throws IOException, IllegalCeosFormatException {
        return this._ancillary2Record.getLowerLimitOfStrengthAfterCorrection();
    }

    public double[] getExposureCoefficients() throws IOException, IllegalCeosFormatException {
        double[] exposureCoeffs = new double[4];
        for (int i = 0; i < exposureCoeffs.length; ++i) {
            exposureCoeffs[i] = this._ancillary2Record.getExposureCoefficient(i + 1);
        }
        return exposureCoeffs;
    }

    public char[] getSensorGains() throws IOException, IllegalCeosFormatException {
        String gains = this._ancillary2Record.getSensorGains();
        return gains.toCharArray();
    }

    public double[] getDetectorTemperatures() throws IOException, IllegalCeosFormatException {
        double[] temperatures = new double[4];
        for (int i = 0; i < temperatures.length; ++i) {
            temperatures[i] = this._ancillary2Record.getDetectorTemperature(i + 1);
        }
        return temperatures;
    }

    public double[] getDetectorAssemblyTemperatures() throws IOException, IllegalCeosFormatException {
        double[] temperatures = new double[4];
        for (int i = 0; i < temperatures.length; ++i) {
            temperatures[i] = this._ancillary2Record.getDetectorAssemblyTemperature(i + 1);
        }
        return temperatures;
    }

    public double getSignalProcessingUnitTemperature() throws IOException, IllegalCeosFormatException {
        return this._ancillary2Record.getSignalProcessingUnitTemperature();
    }

    public int getNumEffectiveDataPoints() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getNumDataPoints();
    }

    public int getYearOfFirstPoint() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getFirstPointYear();
    }

    public int getMonthOfFirstPoint() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getFirstPointMonth();
    }

    public int getDayOfFirstPoint() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getFirstPointDay();
    }

    public int getTotalDaysOfFirstPoint() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getFirstPointTotalDays();
    }

    public double getTotalSecondsOfFirstPoint() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getFirstPointTotalSeconds();
    }

    public double getPointsInterval() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getIntervalTimeBetweenPoints();
    }

    public String getPlatformtReferenceCoordinateSystem() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getReferenceCoordinateSystem();
    }

    public double getFlightDirectionPositionalError() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getPositionalErrorFlightDirection();
    }

    public double getFlightDirectionPositionaVerticallError() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getPositionalErrorFlightVerticalDirection();
    }

    public double getRadiusDirectionPositionalError() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getPositionalErrorRadiusDirection();
    }

    public double getFlightDirectionVelocityError() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getVelocityErrorFlightDirection();
    }

    public double getFlightDirectionVelocityVerticalError() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getVelocityErrorFlightVerticalDirection();
    }

    public double getRadiusDirectionVelocityError() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getVelocityErrorRadiusDirection();
    }

    public Ancillary3Record.DataPoint[] getDataPoints() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getDataPoints();
    }

    public boolean isLeapSecondUsed() throws IOException, IllegalCeosFormatException {
        return this._ancillary3Record.getFlagLeapSecond() == 1;
    }

    public double[] getF4Coefficients() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getF4FunctionCoeffs_1B2();
    }

    public MetadataElement getMapProjectionMetadata() throws IOException, IllegalCeosFormatException {
        MetadataElement projMetadata = new MetadataElement("Map Projection");
        this.addGeneralProjectionMetadata(projMetadata);
        String usedProjection = this.getUsedProjection();
        if (usedProjection.equalsIgnoreCase(PROJECTION_KEY_RAW)) {
            this.addRawProjectionMetadata(projMetadata);
        } else if (usedProjection.equalsIgnoreCase(PROJECTION_KEY_UTM)) {
            this.addGeneralCorrectedMetadata(projMetadata);
            this.addUTMProjectionMetadata(projMetadata);
        } else if (usedProjection.equalsIgnoreCase(PROJECTION_KEY_PS)) {
            this.addGeneralCorrectedMetadata(projMetadata);
            this.addPSProjectionMetadata(projMetadata);
        }
        return projMetadata;
    }

    public MetadataElement getRadiometricMetadata() throws IOException, IllegalCeosFormatException {
        MetadataElement radioMetadata = new MetadataElement("Radiometric Calibration");
        this.addAttribute(radioMetadata, "SENSOR_MODE", ProductData.createInstance((String)this.getSensorMode()));
        this.addAttribute(radioMetadata, "LOWER_LIMIT_STRENGTH", ProductData.createInstance((int[])new int[]{this.getLowerLimitStrength()}));
        this.addAttribute(radioMetadata, "UPPER_LIMIT_STRENGTH", ProductData.createInstance((int[])new int[]{this.getUpperLimitStrength()}));
        this.addAttribute(radioMetadata, "EXPOSURE_COEFFICIENT_BAND", ProductData.createInstance((double[])this.getExposureCoefficients()));
        char[] gains = this.getSensorGains();
        this.addAttribute(radioMetadata, "SENSOR_GAIN_BAND.1", ProductData.createInstance((String)(gains[0] == ' ' ? "" : "Gain " + gains[0])));
        this.addAttribute(radioMetadata, "SENSOR_GAIN_BAND.2", ProductData.createInstance((String)(gains[1] == ' ' ? "" : "Gain " + gains[1])));
        this.addAttribute(radioMetadata, "SENSOR_GAIN_BAND.3", ProductData.createInstance((String)(gains[2] == ' ' ? "" : "Gain " + gains[2])));
        this.addAttribute(radioMetadata, "SENSOR_GAIN_BAND.4", ProductData.createInstance((String)(gains[3] == ' ' ? "" : "Gain " + gains[3])));
        this.addAttribute(radioMetadata, "DETECTOR_TEMPERATURE_BAND", ProductData.createInstance((double[])this.getDetectorTemperatures()), UNIT_DEGREE);
        this.addAttribute(radioMetadata, "DETECTOR_ASSEMBLY_TEMPERATURE_BAND", ProductData.createInstance((double[])this.getDetectorAssemblyTemperatures()), UNIT_DEGREE);
        this.addAttribute(radioMetadata, "SIGNAL_PROCESSING_UNIT_TEMPERATURE", ProductData.createInstance((double[])new double[]{this.getSignalProcessingUnitTemperature()}), UNIT_DEGREE);
        double[] absGains = this.getAbsoluteCalibrationGains();
        double[] absOffsets = this.getAbsoluteCalibrationOffsets();
        this.addAttribute(radioMetadata, "ABSOLUTE_GAIN_BAND", ProductData.createInstance((double[])absGains));
        this.addAttribute(radioMetadata, "ABSOLUTE_OFFSET_BAND", ProductData.createInstance((double[])absOffsets));
        return radioMetadata;
    }

    public MetadataElement getPlatformMetadata() throws IOException, IllegalCeosFormatException {
        MetadataElement platformMeta = new MetadataElement("Platform Position Data");
        this.addAttribute(platformMeta, "NUMBER_EFFECTIVE_DATA_POINTS", ProductData.createInstance((int[])new int[]{this.getNumEffectiveDataPoints()}));
        this.addAttribute(platformMeta, "YEAR_OF_FIRST_POINT", ProductData.createInstance((int[])new int[]{this.getYearOfFirstPoint()}));
        this.addAttribute(platformMeta, "MONTH_OF_FIRST_POINT", ProductData.createInstance((int[])new int[]{this.getMonthOfFirstPoint()}));
        this.addAttribute(platformMeta, "DAY_OF_FIRST_POINT", ProductData.createInstance((int[])new int[]{this.getDayOfFirstPoint()}));
        this.addAttribute(platformMeta, "TOTAL_DAYS_OF_FIRST_POINT", ProductData.createInstance((int[])new int[]{this.getTotalDaysOfFirstPoint()}));
        this.addAttribute(platformMeta, "TOTAL_SECONDS_OF_FIRST_POINT", ProductData.createInstance((double[])new double[]{this.getTotalSecondsOfFirstPoint()}));
        this.addAttribute(platformMeta, "POINTS_INTERVAL_TIME", ProductData.createInstance((double[])new double[]{this.getPointsInterval()}), UNIT_SECOND);
        this.addAttribute(platformMeta, "REFERENCE_COORDINATE_SYSTEM", ProductData.createInstance((String)this.getPlatformtReferenceCoordinateSystem()));
        this.addAttribute(platformMeta, "POSITIONAL_ERROR_FLIGHT_DIRECTION", ProductData.createInstance((double[])new double[]{this.getFlightDirectionPositionalError()}), UNIT_METER);
        this.addAttribute(platformMeta, "POSITIONAL_ERROR_VERTICAL_FLIGHT_DIRECTION", ProductData.createInstance((double[])new double[]{this.getFlightDirectionPositionaVerticallError()}), UNIT_METER);
        this.addAttribute(platformMeta, "POSITIONAL_ERROR_RADIUS_DIRECTION", ProductData.createInstance((double[])new double[]{this.getRadiusDirectionPositionalError()}), UNIT_METER_PER_SECOND);
        this.addAttribute(platformMeta, "VELOCITY_ERROR_FLIGHT_DIRECTION", ProductData.createInstance((double[])new double[]{this.getFlightDirectionVelocityError()}), UNIT_METER_PER_SECOND);
        this.addAttribute(platformMeta, "VELOCITY_ERROR_VERTICAL_FLIGHT_DIRECTION", ProductData.createInstance((double[])new double[]{this.getFlightDirectionVelocityVerticalError()}), UNIT_METER_PER_SECOND);
        this.addAttribute(platformMeta, "VELOCITY_ERROR_RADIUS_DIRECTION", ProductData.createInstance((double[])new double[]{this.getRadiusDirectionVelocityError()}), UNIT_DEGREE_PER_SECOND);
        Ancillary3Record.DataPoint[] dataPoints = this.getDataPoints();
        for (int i = 0; i < dataPoints.length; ++i) {
            int pIndex = i + 1;
            Ancillary3Record.DataPoint dataPoint = dataPoints[i];
            this.addAttribute(platformMeta, "DATA_POINT_" + pIndex + "_POSITIONAL_VECTOR_X", ProductData.createInstance((double[])new double[]{dataPoint.getPositionalVectorDataPointX()}));
            this.addAttribute(platformMeta, "DATA_POINT_" + pIndex + "_POSITIONAL_VECTOR_Y", ProductData.createInstance((double[])new double[]{dataPoint.getPositionalVectorDataPointY()}));
            this.addAttribute(platformMeta, "DATA_POINT_" + pIndex + "_POSITIONAL_VECTOR_Z", ProductData.createInstance((double[])new double[]{dataPoint.getPositionalVectorDataPointZ()}));
            this.addAttribute(platformMeta, "DATA_POINT_" + pIndex + "_VELOCITY_VECTOR_X", ProductData.createInstance((double[])new double[]{dataPoint.getVelocityVectorDataPointX()}));
            this.addAttribute(platformMeta, "DATA_POINT_" + pIndex + "_VELOCITY_VECTOR_Y", ProductData.createInstance((double[])new double[]{dataPoint.getVelocityVectorDataPointY()}));
            this.addAttribute(platformMeta, "DATA_POINT_" + pIndex + "_VELOCITY_VECTOR_Z", ProductData.createInstance((double[])new double[]{dataPoint.getVelocityVectorDataPointZ()}));
        }
        this.addAttribute(platformMeta, "LEAP_SECOND", ProductData.createInstance((String)String.valueOf(this.isLeapSecondUsed())));
        return platformMeta;
    }

    public void close() throws IOException {
        this._reader.close();
        this._reader = null;
    }

    private void addGeneralProjectionMetadata(MetadataElement projMeta) throws IOException, IllegalCeosFormatException {
        this.addAttribute(projMeta, "REFERENCE_ELLIPSOID", ProductData.createInstance((String)this.getReferenceEllipsoidName()));
        this.addAttribute(projMeta, "SEMI_MAJOR_AXIS", ProductData.createInstance((double[])new double[]{this.getSemiMajorAxis()}), UNIT_METER);
        this.addAttribute(projMeta, "SEMI_MINOR_AXIS", ProductData.createInstance((double[])new double[]{this.getSemiMinorAxis()}), UNIT_METER);
        this.addAttribute(projMeta, "GEODETIC_DATUM", ProductData.createInstance((String)this.getDatumName()));
        double[] latCorners = this.getLatCorners();
        double[] lonCorners = this.getLonCorners();
        this.addAttribute(projMeta, "SCENE_UPPER_LEFT_LATITUDE", ProductData.createInstance((double[])new double[]{latCorners[0]}), UNIT_DEGREE);
        this.addAttribute(projMeta, "SCENE_UPPER_LEFT_LONGITUDE", ProductData.createInstance((double[])new double[]{lonCorners[0]}), UNIT_DEGREE);
        this.addAttribute(projMeta, "SCENE_UPPER_RIGHT_LATITUDE", ProductData.createInstance((double[])new double[]{latCorners[1]}), UNIT_DEGREE);
        this.addAttribute(projMeta, "SCENE_UPPER_RIGHT_LONGITUDE", ProductData.createInstance((double[])new double[]{lonCorners[1]}), UNIT_DEGREE);
        this.addAttribute(projMeta, "SCENE_LOWER_LEFT_LATITUDE", ProductData.createInstance((double[])new double[]{latCorners[2]}), UNIT_DEGREE);
        this.addAttribute(projMeta, "SCENE_LOWER_LEFT_LONGITUDE", ProductData.createInstance((double[])new double[]{lonCorners[2]}), UNIT_DEGREE);
        this.addAttribute(projMeta, "SCENE_LOWER_RIGHT_LATITUDE", ProductData.createInstance((double[])new double[]{latCorners[3]}), UNIT_DEGREE);
        this.addAttribute(projMeta, "SCENE_LOWER_RIGHT_LONGITUDE", ProductData.createInstance((double[])new double[]{lonCorners[3]}), UNIT_DEGREE);
    }

    private void addRawProjectionMetadata(MetadataElement projMeta) throws IOException, IllegalCeosFormatException {
        for (int i = 1; i <= 4; ++i) {
            int j;
            double[][] uncorrectedTransformationCoeffs = this.getUncorrectedTransformationCoeffs(i);
            for (j = 0; j < uncorrectedTransformationCoeffs[0].length; ++j) {
                double coeffLat = uncorrectedTransformationCoeffs[0][j];
                this.addAttribute(projMeta, "BAND[" + i + "]_COEFFICIENTS_LATITUDE." + j, ProductData.createInstance((double[])new double[]{coeffLat}));
            }
            for (j = 0; j < uncorrectedTransformationCoeffs[1].length; ++j) {
                double coeffLon = uncorrectedTransformationCoeffs[1][j];
                this.addAttribute(projMeta, "BAND[" + i + "]_COEFFICIENTS_LONGITUDE." + j, ProductData.createInstance((double[])new double[]{coeffLon}));
            }
            for (j = 0; j < uncorrectedTransformationCoeffs[2].length; ++j) {
                double coeffX = uncorrectedTransformationCoeffs[2][j];
                this.addAttribute(projMeta, "BAND[" + i + "]_COEFFICIENTS_X." + j, ProductData.createInstance((double[])new double[]{coeffX}));
            }
            for (j = 0; j < uncorrectedTransformationCoeffs[3].length; ++j) {
                double coeffY = uncorrectedTransformationCoeffs[3][j];
                this.addAttribute(projMeta, "BAND[" + i + "]_COEFFICIENTS_Y." + j, ProductData.createInstance((double[])new double[]{coeffY}));
            }
        }
        this.addAttribute(projMeta, "PIXELS_PER_LINE", ProductData.createInstance((long[])new long[]{this.getNominalPixelsPerLine_1A_1B1()}));
        this.addAttribute(projMeta, "LINES_PER_SCENE", ProductData.createInstance((long[])new long[]{this.getNominalLinesPerScene_1A_1B1()}));
        this.addAttribute(projMeta, "PIXEL_SIZE_X_CENTER", ProductData.createInstance((double[])new double[]{this.getNominalInterPixelDistance_1A_1B1()}), UNIT_METER);
        this.addAttribute(projMeta, "PIXEL_SIZE_Y_CENTER", ProductData.createInstance((double[])new double[]{this.getNominalInterLineDistance_1A_1B1()}), UNIT_METER);
        this.addAttribute(projMeta, "IMAGE_SKEW_CENTER", ProductData.createInstance((double[])new double[]{this.getImageSkew()}), "milliradian");
    }

    private void addUTMProjectionMetadata(MetadataElement projMeta) throws IOException, IllegalCeosFormatException {
        this.addAttribute(projMeta, "HEMISPHERE", ProductData.createInstance((String)(this.isUTMSouthHemisphere() ? "South" : "North")));
        this.addAttribute(projMeta, "UTM_ZONE_NUMBER", ProductData.createInstance((long[])new long[]{this.getUTMZoneIndex()}));
        this.addAttribute(projMeta, "UTM_NORTHING", ProductData.createInstance((double[])new double[]{this.getUTMNorthing()}), UNIT_KILOMETER);
        this.addAttribute(projMeta, "UTM_EASTING", ProductData.createInstance((double[])new double[]{this.getUTMEasting()}), UNIT_KILOMETER);
        MetadataAttribute orientation = this.addAttribute(projMeta, "ORIENTATION", ProductData.createInstance((double[])new double[]{this.getUTMOrientationAngle()}), UNIT_DEGREE);
        orientation.setDescription("Angle between the map projection vertical axis and the true north at scene center");
    }

    private void addPSProjectionMetadata(MetadataElement projMeta) throws IOException, IllegalCeosFormatException {
        GeoPos origin = this.getPSProjectionOrigin();
        this.addAttribute(projMeta, "MAP_PROJECTION_ORIGIN", ProductData.createInstance((String)(origin.getLatString() + " , " + origin.getLonString())));
        GeoPos reference = this.getPSReferencePoint();
        this.addAttribute(projMeta, "REFERENCE_POINT", ProductData.createInstance((String)(reference.getLatString() + " , " + reference.getLonString())));
        this.addAttribute(projMeta, "COORDINATE_CENTER_X", ProductData.createInstance((double[])new double[]{this.getPSXCoordinate()}), UNIT_KILOMETER);
        this.addAttribute(projMeta, "COORDINATE_CENTER_Y)", ProductData.createInstance((double[])new double[]{this.getPSYCoordinate()}), UNIT_KILOMETER);
        MetadataAttribute orientation = this.addAttribute(projMeta, "ORIENTATION", ProductData.createInstance((double[])new double[]{this.getPSOrientationAngle()}), UNIT_DEGREE);
        orientation.setDescription("Angle between the map projection vertical axis and the true north at scene center");
    }

    private void addGeneralCorrectedMetadata(MetadataElement projMeta) throws IllegalCeosFormatException, IOException {
        this.addAttribute(projMeta, "PIXELS_PER_LINE", ProductData.createInstance((double[])new double[]{this.getNumNominalPixelsPerLine()}));
        this.addAttribute(projMeta, "LINES_PER_SCENE", ProductData.createInstance((double[])new double[]{this.getNumNominalLinesPerScene()}));
        this.addAttribute(projMeta, "PIXEL_SIZE_X_CENTER", ProductData.createInstance((double[])new double[]{this.getNominalInterPixelDistance()}), UNIT_METER);
        this.addAttribute(projMeta, "PIXEL_SIZE_Y_CENTER", ProductData.createInstance((double[])new double[]{this.getNominalInterLineDistance()}), UNIT_METER);
    }

    private MetadataAttribute createAttribute(String name, ProductData data) {
        return new MetadataAttribute(name.toUpperCase(), data, true);
    }

    private MetadataAttribute addAttribute(MetadataElement platformMetadata, String name, ProductData data) {
        return this.addAttribute(platformMetadata, name, data, null);
    }

    private MetadataAttribute addAttribute(MetadataElement platformMetadata, String name, ProductData data, String unit) {
        MetadataAttribute attribute = this.createAttribute(name, data);
        if (unit != null) {
            attribute.setUnit(unit);
        }
        platformMetadata.addAttribute(attribute);
        return attribute;
    }
}

