/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.avnir2;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.ceos.CeosHelper;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.avnir2.Avnir2ImageFile;
import org.esa.beam.dataio.ceos.avnir2.Avnir2LeaderFile;
import org.esa.beam.dataio.ceos.avnir2.Avnir2SupplementalFile;
import org.esa.beam.dataio.ceos.avnir2.Avnir2TrailerFile;
import org.esa.beam.dataio.ceos.avnir2.Avnir2VolumeDirectoryFile;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FXYGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.dataop.maptransf.Ellipsoid;
import org.esa.beam.framework.dataop.maptransf.MapInfo;
import org.esa.beam.framework.dataop.maptransf.MapProjection;
import org.esa.beam.framework.dataop.maptransf.MapTransform;
import org.esa.beam.framework.dataop.maptransf.MapTransformFactory;
import org.esa.beam.framework.dataop.maptransf.StereographicDescriptor;
import org.esa.beam.framework.dataop.maptransf.UTM;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.TreeNode;
import org.esa.beam.util.math.FXYSum;

class Avnir2ProductDirectory {
    private static final double UTM_FALSE_EASTING = 500000.0;
    private static final double UTM_FALSE_NORTHING = 1.0E7;
    private static final int METER_PER_KILOMETER = 1000;
    private final File _baseDir;
    private Avnir2VolumeDirectoryFile _volumeDirectoryFile;
    private Avnir2ImageFile[] _imageFiles;
    private Map<Band, Avnir2ImageFile> _imageFileMap;
    private Avnir2LeaderFile _leaderFile;
    private Avnir2TrailerFile _trailerFile;
    private Avnir2SupplementalFile _supplementalFile = null;
    private final int _sceneWidth;
    private final int _sceneHeight;

    Avnir2ProductDirectory(File dir) throws IOException, IllegalCeosFormatException {
        File supplementalFile;
        Guardian.assertNotNull((String)"dir", (Object)dir);
        this._baseDir = dir;
        this._volumeDirectoryFile = new Avnir2VolumeDirectoryFile(this._baseDir);
        this._leaderFile = new Avnir2LeaderFile(this.createInputStream(this._volumeDirectoryFile.getLeaderFileName()));
        this._trailerFile = new Avnir2TrailerFile(this.createInputStream(this._volumeDirectoryFile.getTrailerFileName()));
        if (!this._leaderFile.getProductLevel().equalsIgnoreCase("1B2") && (supplementalFile = new File(this._baseDir, this._volumeDirectoryFile.getSupplementalFileName())).exists()) {
            this._supplementalFile = new Avnir2SupplementalFile(this.createInputStream(this._volumeDirectoryFile.getSupplementalFileName()));
        }
        String[] imageFileNames = this._volumeDirectoryFile.getImageFileNames();
        this._imageFiles = new Avnir2ImageFile[imageFileNames.length];
        for (int i = 0; i < this._imageFiles.length; ++i) {
            this._imageFiles[i] = new Avnir2ImageFile(this.createInputStream(imageFileNames[i]));
        }
        this._sceneWidth = this._imageFiles[0].getRasterWidth();
        this._sceneHeight = this._imageFiles[0].getRasterHeight();
        this.assertSameWidthAndHeightForAllImages();
    }

    Product createProduct() throws IOException, IllegalCeosFormatException {
        Product product = new Product(this._volumeDirectoryFile.getProductName(), this.getProductType(), this._sceneWidth, this._sceneHeight);
        product.setFileLocation(this._baseDir);
        this._imageFileMap = new HashMap<Band, Avnir2ImageFile>(this._imageFiles.length);
        for (Avnir2ImageFile avnir2ImageFile : this._imageFiles) {
            Band band = this.createBand(avnir2ImageFile);
            product.addBand(band);
            this._imageFileMap.put(band, avnir2ImageFile);
        }
        product.setStartTime(this.getUTCScanStartTime());
        product.setEndTime(this.getUTCScanStopTime());
        product.setDescription(this.getProductDescription());
        this.addGeoCoding(product);
        this.addMetaData(product);
        return product;
    }

    TreeNode<File> getProductComponents() {
        try {
            File parentDir = this._baseDir.getParentFile();
            TreeNode root = new TreeNode(parentDir.getCanonicalPath());
            root.setContent((Object)parentDir);
            TreeNode dir = new TreeNode(this._baseDir.getName());
            dir.setContent((Object)this._baseDir);
            root.addChild(dir);
            File volumeFile = CeosHelper.getVolumeFile(this._baseDir);
            this.addFileToDir((TreeNode<File>)dir, volumeFile);
            this.addFileToDir((TreeNode<File>)dir, new File(this._volumeDirectoryFile.getLeaderFileName()));
            this.addFileToDir((TreeNode<File>)dir, new File(this._volumeDirectoryFile.getTrailerFileName()));
            String supplemental = this._volumeDirectoryFile.getSupplementalFileName();
            if (StringUtils.isNotNullAndNotEmpty((String)supplemental)) {
                this.addFileToDir((TreeNode<File>)dir, new File(supplemental));
            }
            String[] imageFileNames = this._volumeDirectoryFile.getImageFileNames();
            for (int i = 0; i < imageFileNames.length; ++i) {
                this.addFileToDir((TreeNode<File>)dir, new File(imageFileNames[i]));
            }
            return root;
        }
        catch (IOException e) {
            return null;
        }
        catch (IllegalCeosFormatException e) {
            return null;
        }
    }

    private void addFileToDir(TreeNode<File> dir, File file) {
        TreeNode fileNode = new TreeNode(file.getName());
        fileNode.setContent((Object)file);
        dir.addChild(fileNode);
    }

    private String getProductType() throws IOException, IllegalCeosFormatException {
        return "AV2_" + this._leaderFile.getProductLevel();
    }

    private void addGeoCoding(Product product) throws IllegalCeosFormatException, IOException {
        String usedProjection = this._leaderFile.getUsedProjection();
        if ("NNNNN".equalsIgnoreCase(usedProjection)) {
            Band[] bands = product.getBands();
            for (int i = 0; i < bands.length; ++i) {
                Band band = bands[i];
                Avnir2ImageFile imageFile = this.getImageFile(band);
                int bandIndex = imageFile.getBandIndex();
                double[][] uncorrectedCoeffs = this._leaderFile.getUncorrectedTransformationCoeffs(bandIndex);
                FXYSum.Cubic funcLat = new FXYSum.Cubic(CeosHelper.sortToFXYSumOrder(uncorrectedCoeffs[0]));
                FXYSum.Cubic funcLon = new FXYSum.Cubic(CeosHelper.sortToFXYSumOrder(uncorrectedCoeffs[1]));
                FXYSum.Cubic funcX = new FXYSum.Cubic(CeosHelper.sortToFXYSumOrder(uncorrectedCoeffs[2]));
                FXYSum.Cubic funcY = new FXYSum.Cubic(CeosHelper.sortToFXYSumOrder(uncorrectedCoeffs[3]));
                FXYGeoCoding gc = new FXYGeoCoding(0.0f, 0.0f, 1.0f, 1.0f, (FXYSum)funcX, (FXYSum)funcY, (FXYSum)funcLat, (FXYSum)funcLon, Datum.ITRF_97);
                band.setGeoCoding((GeoCoding)gc);
            }
        } else if ("YNNNN".equalsIgnoreCase(usedProjection)) {
            int zoneIndex = (int)this._leaderFile.getUTMZoneIndex();
            boolean isSouth = this._leaderFile.isUTMSouthHemisphere();
            double easting = this._leaderFile.getUTMEasting() * 1000.0;
            double northing = this._leaderFile.getUTMNorthing() * 1000.0;
            double pixelSizeX = this._leaderFile.getNominalInterPixelDistance();
            double pixelSizeY = this._leaderFile.getNominalInterLineDistance();
            float orientationAngle = (float)this._leaderFile.getUTMOrientationAngle();
            MapInfo mapInfo = new MapInfo((MapProjection)UTM.createProjection((int)(zoneIndex - 1), (boolean)isSouth), (float)this._sceneWidth * 0.5f, (float)this._sceneHeight * 0.5f, (float)easting, (float)northing, (float)pixelSizeX, (float)pixelSizeY, Datum.ITRF_97);
            mapInfo.setOrientation(-orientationAngle);
            mapInfo.setSceneWidth(this._sceneWidth);
            mapInfo.setSceneHeight(this._sceneHeight);
            product.setGeoCoding((GeoCoding)new MapGeoCoding(mapInfo));
        } else if ("NNNNY".equalsIgnoreCase(usedProjection)) {
            double[] parameterValues = StereographicDescriptor.PARAMETER_DEFAULT_VALUES;
            parameterValues[0] = Ellipsoid.GRS_80.getSemiMajor();
            parameterValues[1] = Ellipsoid.GRS_80.getSemiMinor();
            GeoPos psReferencePoint = this._leaderFile.getPSReferencePoint();
            GeoPos psProjectionOrigin = this._leaderFile.getPSProjectionOrigin();
            parameterValues[2] = psProjectionOrigin.getLat();
            parameterValues[3] = psReferencePoint.getLon();
            MapTransform transform = MapTransformFactory.createTransform((String)"Stereographic", (double[])parameterValues);
            MapProjection projection = new MapProjection("Stereographic", transform);
            double pixelSizeX = this._leaderFile.getNominalInterPixelDistance();
            double pixelSizeY = this._leaderFile.getNominalInterLineDistance();
            double easting = this._leaderFile.getPSXCoordinate() * 1000.0;
            double northing = this._leaderFile.getPSYCoordinate() * 1000.0;
            int sceneRasterWidth = product.getSceneRasterWidth();
            int sceneRasterHeight = product.getSceneRasterHeight();
            MapInfo mapInfo = new MapInfo(projection, (float)sceneRasterWidth * 0.5f, (float)sceneRasterHeight * 0.5f, (float)easting, (float)northing, (float)pixelSizeX, (float)pixelSizeY, Datum.ITRF_97);
            mapInfo.setOrientation((float)this._leaderFile.getPSOrientationAngle());
            mapInfo.setSceneWidth(sceneRasterWidth);
            mapInfo.setSceneHeight(sceneRasterHeight);
            product.setGeoCoding((GeoCoding)new MapGeoCoding(mapInfo));
        } else {
            Debug.trace((String)"Unknown map projection method. Could not create geo-coding.");
        }
    }

    Avnir2ImageFile getImageFile(Band band) throws IOException, IllegalCeosFormatException {
        return this._imageFileMap.get(band);
    }

    void close() throws IOException {
        for (int i = 0; i < this._imageFiles.length; ++i) {
            this._imageFiles[i].close();
            this._imageFiles[i] = null;
        }
        this._imageFiles = null;
        this._imageFileMap.clear();
        this._volumeDirectoryFile.close();
        this._volumeDirectoryFile = null;
        this._leaderFile.close();
        this._leaderFile = null;
        this._trailerFile.close();
        this._trailerFile = null;
        if (this._supplementalFile != null) {
            this._supplementalFile.close();
            this._supplementalFile = null;
        }
    }

    private Band createBand(Avnir2ImageFile avnir2ImageFile) throws IOException, IllegalCeosFormatException {
        Band band = new Band(avnir2ImageFile.getBandName(), 20, this._sceneWidth, this._sceneHeight);
        int bandIndex = avnir2ImageFile.getBandIndex();
        band.setSpectralBandIndex(bandIndex - 1);
        band.setSpectralWavelength(avnir2ImageFile.getSpectralWavelength());
        band.setSpectralBandwidth(avnir2ImageFile.getSpectralBandwidth());
        band.setUnit(avnir2ImageFile.getGeophysicalUnit());
        double scalingFactor = this._leaderFile.getAbsoluteCalibrationGain(bandIndex);
        double scalingOffset = this._leaderFile.getAbsoluteCalibrationOffset(bandIndex);
        band.setScalingFactor(scalingFactor);
        band.setScalingOffset(scalingOffset);
        band.setNoDataValueUsed(false);
        band.setDescription("Radiance band " + avnir2ImageFile.getBandIndex());
        return band;
    }

    private void addMetaData(Product product) throws IOException, IllegalCeosFormatException {
        MetadataElement metadata = new MetadataElement("SPH");
        metadata.addElement(this._leaderFile.getMapProjectionMetadata());
        metadata.addElement(this._leaderFile.getRadiometricMetadata());
        metadata.addElement(this._leaderFile.getPlatformMetadata());
        this.addSummaryMetadata(metadata);
        product.getMetadataRoot().addElement(metadata);
        MetadataElement volumeDescriptor = new MetadataElement("VOLUME_DESCRIPTOR");
        this._volumeDirectoryFile.assignMetadataTo(volumeDescriptor);
        product.getMetadataRoot().addElement(volumeDescriptor);
    }

    private void addSummaryMetadata(MetadataElement parent) throws IOException {
        MetadataElement summaryMetadata = new MetadataElement("Summary Information");
        Properties properties = new Properties();
        File file = new File(this._baseDir, "summary.txt");
        if (!file.exists()) {
            return;
        }
        properties.load(new FileInputStream(file));
        Set<Map.Entry<Object, Object>> unsortedEntries = properties.entrySet();
        TreeSet<Map.Entry<Object, Object>> sortedEntries = new TreeSet<Map.Entry<Object, Object>>(new Comparator(){

            public int compare(Object a, Object b) {
                Map.Entry entryA = (Map.Entry)a;
                Map.Entry entryB = (Map.Entry)b;
                return ((String)entryA.getKey()).compareTo((String)entryB.getKey());
            }
        });
        sortedEntries.addAll(unsortedEntries);
        for (Map.Entry entry : sortedEntries) {
            String data = (String)entry.getValue();
            String strippedData = data.substring(1, data.length() - 1);
            MetadataAttribute attribute = new MetadataAttribute((String)entry.getKey(), (ProductData)new ProductData.ASCII(strippedData), true);
            summaryMetadata.addAttribute(attribute);
        }
        parent.addElement(summaryMetadata);
    }

    private int getMaxSampleValue(int[] histogram) {
        for (int i = histogram.length - 1; i >= 0; --i) {
            if (histogram[i] == 0) continue;
            return i;
        }
        return 0;
    }

    private String getProductDescription() throws IOException, IllegalCeosFormatException {
        return "AVNIR-2 product Level " + this._leaderFile.getProductLevel();
    }

    private void assertSameWidthAndHeightForAllImages() throws IOException, IllegalCeosFormatException {
        for (int i = 0; i < this._imageFiles.length; ++i) {
            Avnir2ImageFile imageFile = this._imageFiles[i];
            Guardian.assertTrue((String)("_sceneWidth == imageFile[" + i + "].getRasterWidth()"), (this._sceneWidth == imageFile.getRasterWidth() ? 1 : 0) != 0);
            Guardian.assertTrue((String)("_sceneHeight == imageFile[" + i + "].getRasterHeight()"), (this._sceneHeight == imageFile.getRasterHeight() ? 1 : 0) != 0);
        }
    }

    private ProductData.UTC getUTCScanStartTime() throws IOException, IllegalCeosFormatException {
        Calendar imageStartDate = this._leaderFile.getDateImageWasTaken();
        imageStartDate.add(14, this._imageFiles[0].getTotalMillisInDayOfLine(0));
        return ProductData.UTC.create((Date)imageStartDate.getTime(), (long)this._imageFiles[0].getMicrosecondsOfLine(0));
    }

    private ProductData.UTC getUTCScanStopTime() throws IOException, IllegalCeosFormatException {
        Calendar imageStartDate = this._leaderFile.getDateImageWasTaken();
        imageStartDate.add(14, this._imageFiles[0].getTotalMillisInDayOfLine(this._sceneHeight - 1));
        return ProductData.UTC.create((Date)imageStartDate.getTime(), (long)this._imageFiles[0].getMicrosecondsOfLine(this._sceneHeight - 1));
    }

    private ImageInputStream createInputStream(String fileName) throws IOException {
        return new FileImageInputStream(new File(this._baseDir, fileName));
    }
}

