/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.avnir2;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosHelper;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.avnir2.Avnir2ImageFile;
import org.esa.beam.dataio.ceos.avnir2.Avnir2ProductDirectory;
import org.esa.beam.framework.dataio.AbstractProductReader;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.TreeNode;

public class Avnir2ProductReader
extends AbstractProductReader {
    private Avnir2ProductDirectory _avnir2Dir;

    public Avnir2ProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    public void close() throws IOException {
        if (this._avnir2Dir != null) {
            this._avnir2Dir.close();
            this._avnir2Dir = null;
        }
        super.close();
    }

    public TreeNode<File> getProductComponents() {
        File input = CeosHelper.getFileFromInput(this.getInput());
        if (input == null) {
            return null;
        }
        return this._avnir2Dir.getProductComponents();
    }

    protected Product readProductNodesImpl() throws IOException {
        Product product;
        Object input;
        ProductReaderPlugIn readerPlugIn = this.getReaderPlugIn();
        if (readerPlugIn.getDecodeQualification(input = this.getInput()) == DecodeQualification.UNABLE) {
            throw new IOException("Unsupported product format.");
        }
        File fileFromInput = CeosHelper.getFileFromInput(this.getInput());
        try {
            this._avnir2Dir = new Avnir2ProductDirectory(fileFromInput.getParentFile());
            product = this._avnir2Dir.createProduct();
        }
        catch (IllegalCeosFormatException e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
        product.setProductReader((ProductReader)this);
        product.setModified(false);
        return product;
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        try {
            Avnir2ImageFile imageFile = this._avnir2Dir.getImageFile(destBand);
            imageFile.readBandRasterData(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destOffsetX, destOffsetY, destWidth, destHeight, destBuffer, pm);
        }
        catch (IllegalCeosFormatException e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
    }
}

