/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.avnir2;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import org.esa.beam.dataio.ceos.CeosHelper;
import org.esa.beam.dataio.ceos.avnir2.Avnir2Constants;
import org.esa.beam.dataio.ceos.avnir2.Avnir2ProductReader;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.util.io.FileUtils;

public class Avnir2ProductReaderPlugIn
implements ProductReaderPlugIn {
    private static final String _AVNIR2_INDICATION_KEY = "ALAV2";
    private static final int _MINIMUM_FILES = 7;

    public DecodeQualification getDecodeQualification(Object input) {
        FilenameFilter filter;
        File[] files;
        File file = CeosHelper.getFileFromInput(input);
        if (file == null) {
            return DecodeQualification.UNABLE;
        }
        String filename = FileUtils.getFilenameWithoutExtension((File)file);
        if (!filename.startsWith("VOL-ALAV2")) {
            return DecodeQualification.UNABLE;
        }
        File parentDir = file.getParentFile();
        if (file.isFile() && parentDir.isDirectory() && (files = parentDir.listFiles(filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(Avnir2ProductReaderPlugIn._AVNIR2_INDICATION_KEY);
            }
        })) != null && files.length >= 7) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return Avnir2Constants.VALID_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new Avnir2ProductReader(this);
    }

    public BeamFileFilter getProductFileFilter() {
        return new Avnir2FileFilter();
    }

    public String[] getFormatNames() {
        return Avnir2Constants.FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return Avnir2Constants.FORMAT_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return "AVNIR-2 Products";
    }

    public static class Avnir2FileFilter
    extends BeamFileFilter {
        public Avnir2FileFilter() {
            this.setFormatName(Avnir2Constants.FORMAT_NAMES[0]);
            this.setDescription("AVNIR-2 Products");
        }

        public boolean accept(File file) {
            return super.accept(file) && (file.isDirectory() || file.getName().startsWith("VOL-ALAV2"));
        }
    }
}

