/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.avnir2.records;

import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.CeosHelper;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.Ancillary1Record;

public class Avnir2Ancillary1Record
extends Ancillary1Record {
    private double[][][] _bandCoeffs;

    public Avnir2Ancillary1Record(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public Avnir2Ancillary1Record(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
    }

    @Override
    public double[][] getTransformationCoefficientsFor(int bandIndex) throws IOException, IllegalCeosFormatException {
        if (bandIndex < 1 || bandIndex > 4) {
            throw new IllegalArgumentException("The band index must be between 1 and 4");
        }
        if (this._bandCoeffs == null) {
            this._bandCoeffs = new double[4][4][10];
            long[] tempLongs = new long[this._bandCoeffs[0][0].length];
            this.getReader().seek(this.getAbsolutPosition(1964L));
            for (int i = 0; i < this._bandCoeffs.length; ++i) {
                double[][] bandCoeff = this._bandCoeffs[i];
                for (int j = 0; j < bandCoeff.length; ++j) {
                    this.getReader().readB8(tempLongs);
                    bandCoeff[j] = CeosHelper.convertLongToDouble(tempLongs);
                }
            }
        }
        return this._bandCoeffs[bandIndex - 1];
    }
}

