/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.prism;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.prism.DataBuffer;
import org.esa.beam.dataio.ceos.prism.records.ImageFileDescriptorRecord;
import org.esa.beam.dataio.ceos.records.ImageRecord;

class PrismImageFile {
    public final ImageFileDescriptorRecord _imageFileDescriptorRecord;
    public final ImageRecord[] _imageRecords;
    private final int _height;
    private final int _width;
    private CeosFileReader _ceosReader;
    private final int _imageNumber;
    private int _imageRecordLength;
    private long _startPosImageRecords;

    public PrismImageFile(ImageInputStream imageStream) throws IOException, IllegalCeosFormatException {
        this._ceosReader = new CeosFileReader(imageStream);
        this._imageFileDescriptorRecord = new ImageFileDescriptorRecord(this._ceosReader);
        this._width = this._imageFileDescriptorRecord.getNumImagePixelsPerLine();
        this._height = this._imageFileDescriptorRecord.getNumLinesPerBand();
        this._imageRecords = new ImageRecord[this._height];
        this._imageRecords[0] = new ImageRecord(this._ceosReader);
        this._imageRecordLength = this._imageRecords[0].getRecordLength();
        this._startPosImageRecords = this._imageRecords[0].getStartPos();
        this._imageNumber = this._imageRecords[0].getImageNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readBandRasterData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, DataBuffer destBuffer, int destOffsetX, int destWidth, ProgressMonitor pm) throws IOException, IllegalCeosFormatException {
        int sourceMinY = sourceOffsetY;
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int ccdBorder = this.getOverlap() / 2;
        int adjustedSourceOffsetX = sourceOffsetX + ccdBorder;
        pm.beginTask("Reading band ...", sourceMaxY - sourceMinY);
        try {
            byte[] srcLine = new byte[sourceWidth];
            byte[] destLine = new byte[destWidth];
            for (int y = sourceMinY; y <= sourceMaxY; y += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                this.readSourceLine(y, adjustedSourceOffsetX, srcLine);
                this.copyLine(srcLine, destLine, sourceStepX);
                int currentLineIndex = (y - sourceMinY) * destBuffer.getDimension().width + destOffsetX;
                System.arraycopy(destLine, 0, destBuffer.getBuffer().getElems(), currentLineIndex, destWidth);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSourceLine(int y, int sourceOffsetX, byte[] srcLine) throws IOException, IllegalCeosFormatException {
        CeosFileReader ceosFileReader = this._ceosReader;
        synchronized (ceosFileReader) {
            ImageRecord imageRecord = this.getImageRecord(y);
            this._ceosReader.seek(imageRecord.getImageDataStart() + (long)sourceOffsetX);
            this._ceosReader.readB1(srcLine);
        }
    }

    private ImageRecord getImageRecord(int line) throws IOException, IllegalCeosFormatException {
        if (this._imageRecords[line] == null) {
            this._ceosReader.seek((long)(this._imageRecordLength * line) + this._startPosImageRecords);
            this._imageRecords[line] = new ImageRecord(this._ceosReader);
        }
        return this._imageRecords[line];
    }

    private void copyLine(byte[] srcLine, byte[] destLine, int sourceStepX) {
        if (sourceStepX == 1) {
            System.arraycopy(srcLine, 0, destLine, 0, destLine.length);
        } else {
            int x = 0;
            int i = 0;
            while (x < destLine.length) {
                destLine[x] = srcLine[i];
                ++x;
                i += sourceStepX;
            }
        }
    }

    public void close() throws IOException {
        this._ceosReader.close();
        this._ceosReader = null;
    }

    public int getHeight() {
        return this._height;
    }

    public int getWidth() {
        return this._width;
    }

    public int getImageNumber() {
        return this._imageNumber;
    }

    public boolean canGetStartAndEndTime() {
        return this._imageNumber != 0;
    }

    public boolean isLevel_1A_or_1B1() {
        return this.canGetStartAndEndTime();
    }

    public int getOverlap() {
        return this.isLevel_1A_or_1B1() ? 32 : 0;
    }

    public int getTotalMillisInDayOfLine(int y) throws IOException, IllegalCeosFormatException {
        return this.getImageRecord(y).getScanStartTimeMillisAtDay();
    }

    public int getMicrosecondsOfLine(int y) throws IOException, IllegalCeosFormatException {
        return this.getImageRecord(y).getScanStartTimeMicros();
    }
}

