/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.prism;

import java.io.IOException;
import java.util.Calendar;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.prism.records.LeaderFileDescriptorRecord;
import org.esa.beam.dataio.ceos.prism.records.PrismAncillary1Record;
import org.esa.beam.dataio.ceos.prism.records.PrismAncillary2Record;
import org.esa.beam.dataio.ceos.prism.records.SceneHeaderRecord;
import org.esa.beam.dataio.ceos.records.Ancillary1Record;
import org.esa.beam.dataio.ceos.records.Ancillary3Record;
import org.esa.beam.framework.datamodel.GeoPos;

class PrismLeaderFile {
    private final LeaderFileDescriptorRecord _leaderFDR;
    private final SceneHeaderRecord _sceneHeaderRecord;
    private final PrismAncillary1Record _ancillary1Record;
    private final PrismAncillary2Record _ancillary2Record;
    private final Ancillary3Record _ancillary3Record;
    private final CeosFileReader _reader;

    public PrismLeaderFile(ImageInputStream leaderStream) throws IOException, IllegalCeosFormatException {
        this._reader = new CeosFileReader(leaderStream);
        this._leaderFDR = new LeaderFileDescriptorRecord(this._reader);
        this._sceneHeaderRecord = new SceneHeaderRecord(this._reader);
        this._ancillary1Record = new PrismAncillary1Record(this._reader);
        this._ancillary2Record = new PrismAncillary2Record(this._reader);
        this._ancillary3Record = new Ancillary3Record(this._reader);
    }

    public Ancillary1Record getAncillary1Record() {
        return this._ancillary1Record;
    }

    public PrismAncillary2Record getAncillary2Record() {
        return this._ancillary2Record;
    }

    public Ancillary3Record getAncillary3Record() {
        return this._ancillary3Record;
    }

    public SceneHeaderRecord getSceneHeaderRecord() {
        return this._sceneHeaderRecord;
    }

    public LeaderFileDescriptorRecord getLeaderFileDescriptorRecord() {
        return this._leaderFDR;
    }

    public String getProductLevel() {
        return this._sceneHeaderRecord.getProductLevel();
    }

    public int getSceneWidth() {
        return (int)this._sceneHeaderRecord.getNumPixelsPerLineInImage();
    }

    public int getSceneHeight() {
        return (int)this._sceneHeaderRecord.getNumLinesInImage();
    }

    public Calendar getDateImageWasTaken() {
        return this._sceneHeaderRecord.getDateImageWasTaken();
    }

    public String getProductName() {
        return this._sceneHeaderRecord.getSceneId().trim() + "-" + this._sceneHeaderRecord.getProductId().trim();
    }

    public String getProductType() {
        return "PRM" + this.getProductLevel();
    }

    public void close() throws IOException {
        this._reader.close();
    }

    public String getDatumName() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getGeodeticCoordinateName();
    }

    public double getSemiMinorAxis() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getSemiminorAxisOfReferenceEllipsoid();
    }

    public double getSemiMajorAxis() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getSemimajorAxisOfReferenceEllipsoid();
    }

    public long getUTMZoneIndex() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getUTMZoneNumber();
    }

    public boolean isUTMSouthHemisphere() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getHemisphere() == 1;
    }

    public double getUTMEasting() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getSceneCenterEasting();
    }

    public double getUTMNorthing() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getSceneCenterNorthing();
    }

    public long getNominalPixelsPerLine_1A_1B1() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNumNominalPixelsPerLine_1A_1B1();
    }

    public long getNominalLinesPerScene_1A_1B1() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNumNominalLinesPerScene_1A_1B1();
    }

    public double getNominalInterPixelDistance_1A_1B1() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNominalInterPixelDistance_1A_1B1();
    }

    public double getNominalInterLineDistance_1A_1B1() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNominalInterLineDistance_1A_1B1();
    }

    public double getImageSkew() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getImageSkew();
    }

    public double getNominalInterPixelDistance() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNominalInterPixelDistance();
    }

    public double getNominalInterLineDistance() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getNominalInterLineDistance();
    }

    public double getUTMOrientationAngle() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getAngleBetweenMapUTMVerticalAndTrueNorth();
    }

    public double[][] getCorrectedTransformationCoeffs() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getTransformationCoeffsL1B2();
    }

    public double[][] getUncorrectedTransformationCoeffs(int ccdNumber) throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getTransformationCoefficientsFor(ccdNumber);
    }

    public GeoPos getPSReferencePoint() throws IOException, IllegalCeosFormatException {
        float referenceLat = (float)this._ancillary1Record.getPSReferenceLat();
        float referenceLon = (float)this._ancillary1Record.getPSReferenceLon();
        return new GeoPos(referenceLat, referenceLon);
    }

    public GeoPos getPSProjectionOrigin() throws IOException, IllegalCeosFormatException {
        float originLat = (float)this._ancillary1Record.getMapProjOriginLat();
        float originLon = (float)this._ancillary1Record.getMapProjOriginLon();
        return new GeoPos(originLat, originLon);
    }

    public double getPSXCoordinate() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getSceneCenterX();
    }

    public double getPSYCoordinate() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getSceneCenterY();
    }

    public double getPSOrientationAngle() throws IOException, IllegalCeosFormatException {
        return this._ancillary1Record.getAngleBetweenMapPSVerticalAndTrueNorth();
    }
}

