/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.prism;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.File;
import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosHelper;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.prism.DataBuffer;
import org.esa.beam.dataio.ceos.prism.PrismImageFile;
import org.esa.beam.dataio.ceos.prism.PrismProductDirectory;
import org.esa.beam.framework.dataio.AbstractProductReader;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.TreeNode;

public class PrismProductReader
extends AbstractProductReader {
    private PrismProductDirectory _prismDir;

    public PrismProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    public void close() throws IOException {
        if (this._prismDir != null) {
            this._prismDir.close();
            this._prismDir = null;
        }
        super.close();
    }

    public TreeNode<File> getProductComponents() {
        File input = CeosHelper.getFileFromInput(this.getInput());
        if (input == null) {
            return null;
        }
        return this._prismDir.getProductComponents();
    }

    protected Product readProductNodesImpl() throws IOException {
        Product product;
        Object input;
        ProductReaderPlugIn readerPlugIn = this.getReaderPlugIn();
        if (readerPlugIn.getDecodeQualification(input = this.getInput()) == DecodeQualification.UNABLE) {
            throw new IOException("Unsupported product format.");
        }
        File fileFromInput = CeosHelper.getFileFromInput(this.getInput());
        try {
            this._prismDir = new PrismProductDirectory(fileFromInput.getParentFile());
            product = this._prismDir.createProduct();
        }
        catch (IllegalCeosFormatException e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
        product.setProductReader((ProductReader)this);
        product.setModified(false);
        return product;
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int bufferX, int bufferY, int bufferWidth, int bufferHeight, ProductData buffer, ProgressMonitor pm) throws IOException {
        DataBuffer destBuffer = new DataBuffer(buffer, bufferX, bufferY, bufferWidth, bufferHeight);
        PrismImageFile[] imageFiles = this._prismDir.getImageFiles();
        pm.beginTask("Reading band ...", imageFiles.length);
        try {
            for (int i = 0; i < imageFiles.length; ++i) {
                int scenePos;
                int ccdSourceWidth;
                int destOffsetX;
                int ccdSourceOffsetX;
                if (pm.isCanceled()) {
                    break;
                }
                PrismImageFile imageFile = imageFiles[i];
                int overlap = imageFile.getOverlap();
                int ccdWidth = imageFile.getWidth() - overlap;
                int sceneOffsetX = ccdWidth * i;
                if (sceneOffsetX < sourceOffsetX) {
                    ccdSourceOffsetX = sourceOffsetX - sceneOffsetX;
                    destOffsetX = 0;
                } else {
                    ccdSourceOffsetX = 0;
                    int destSceneOffsetX = sceneOffsetX / sourceStepX;
                    int destBufferPosX = sourceOffsetX / sourceStepX;
                    destOffsetX = destSceneOffsetX - destBufferPosX;
                }
                if (ccdSourceOffsetX > ccdWidth || (ccdSourceWidth = (scenePos = sourceOffsetX + sourceWidth) > sceneOffsetX + ccdWidth ? ccdWidth - ccdSourceOffsetX : scenePos - sceneOffsetX - ccdSourceOffsetX) <= 0) continue;
                int destWidth = ccdSourceWidth / sourceStepX;
                imageFile.readBandRasterData(ccdSourceOffsetX, sourceOffsetY, ccdSourceWidth, sourceHeight, sourceStepX, sourceStepY, destBuffer, destOffsetX, destWidth, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            }
        }
        catch (IllegalCeosFormatException e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
        finally {
            pm.done();
        }
    }
}

