/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.prism.records;

import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.CeosHelper;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.Ancillary1Record;

public class PrismAncillary1Record
extends Ancillary1Record {
    private double[][][] _ccdCoeffs;

    public PrismAncillary1Record(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public PrismAncillary1Record(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
    }

    @Override
    public double[][] getTransformationCoefficientsFor(int ccdIndex) throws IOException, IllegalCeosFormatException {
        if (ccdIndex < 1 || ccdIndex > 8) {
            throw new IllegalArgumentException("The CCD number must be between 1 and 8");
        }
        if (this._ccdCoeffs == null) {
            this._ccdCoeffs = new double[8][4][10];
            this.getReader().seek(this.getAbsolutPosition(1964L));
            for (int i = 0; i < this._ccdCoeffs.length; ++i) {
                double[][] ccdCoeff = this._ccdCoeffs[i];
                for (int j = 0; j < ccdCoeff.length; ++j) {
                    long[] longs = new long[this._ccdCoeffs[0][0].length];
                    this.getReader().readB8(longs);
                    ccdCoeff[j] = CeosHelper.convertLongToDouble(longs);
                }
            }
        }
        return this._ccdCoeffs[ccdIndex - 1];
    }
}

