/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.CeosHelper;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.BaseRecord;

public abstract class Ancillary1Record
extends BaseRecord {
    private String _referenceEllipsoid;
    private double _semimajorAxisOfReferenceEllipsoid;
    private double _semiminorAxisOfReferenceEllipsoid;
    private String _GeodeticCoordinateName;
    private double[][] _L1B2Coeffs;

    public Ancillary1Record(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public Ancillary1Record(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
        this.readGeneralFields(reader);
        reader.seek(this.getAbsolutPosition(this.getRecordLength()));
    }

    private void readGeneralFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        reader.skipBytes(752L);
        this._referenceEllipsoid = reader.readAn(16);
        this._semimajorAxisOfReferenceEllipsoid = reader.readFn(16);
        this._semiminorAxisOfReferenceEllipsoid = reader.readFn(16);
        this._GeodeticCoordinateName = reader.readAn(16);
    }

    public long getNumNominalPixelsPerLine_1A_1B1() throws IOException, IllegalCeosFormatException {
        return this.readIn(16, 12);
    }

    public long getNumNominalLinesPerScene_1A_1B1() throws IOException, IllegalCeosFormatException {
        return this.readIn(16, 28);
    }

    public double getNominalInterPixelDistance_1A_1B1() throws IOException, IllegalCeosFormatException {
        return this.readF16(44);
    }

    public double getNominalInterLineDistance_1A_1B1() throws IOException, IllegalCeosFormatException {
        return this.readF16(61);
    }

    public double getImageSkew() throws IOException, IllegalCeosFormatException {
        return this.readF16(76);
    }

    public int getHemisphere() throws IOException, IllegalCeosFormatException {
        this.getReader().seek(this.getAbsolutPosition(92L));
        return this.getReader().readI4();
    }

    public long getUTMZoneNumber() throws IOException, IllegalCeosFormatException {
        return this.readIn(12, 96);
    }

    public double getSceneCenterNorthing() throws IOException, IllegalCeosFormatException {
        return this.readF16(140);
    }

    public double getSceneCenterEasting() throws IOException, IllegalCeosFormatException {
        return this.readF16(156);
    }

    public double getAngleBetweenMapUTMVerticalAndTrueNorth() throws IOException, IllegalCeosFormatException {
        return this.readF16(204);
    }

    public double getMapProjOriginLat() throws IOException, IllegalCeosFormatException {
        return this.readF16(332);
    }

    public double getMapProjOriginLon() throws IOException, IllegalCeosFormatException {
        return this.readF16(348);
    }

    public double getPSReferenceLat() throws IOException, IllegalCeosFormatException {
        return this.readF16(364);
    }

    public double getPSReferenceLon() throws IOException, IllegalCeosFormatException {
        return this.readF16(380);
    }

    public double getSceneCenterX() throws IOException, IllegalCeosFormatException {
        return this.readF16(428);
    }

    public double getSceneCenterY() throws IOException, IllegalCeosFormatException {
        return this.readF16(444);
    }

    public double getAngleBetweenMapPSVerticalAndTrueNorth() throws IOException, IllegalCeosFormatException {
        return this.readF16(492);
    }

    public double getNumNominalPixelsPerLine() throws IOException, IllegalCeosFormatException {
        return this.readF16(508);
    }

    public double getNumNominalLinesPerScene() throws IOException, IllegalCeosFormatException {
        return this.readF16(524);
    }

    public double getNominalInterPixelDistance() throws IOException, IllegalCeosFormatException {
        return this.readF16(540);
    }

    public double getNominalInterLineDistance() throws IOException, IllegalCeosFormatException {
        return this.readF16(556);
    }

    public double getAngleBetweenMapVerticalAndTrueNorth() throws IOException, IllegalCeosFormatException {
        return this.readF16(620);
    }

    public double getNominalSateliteOrbitInclination() throws IOException, IllegalCeosFormatException {
        return this.readF16(636);
    }

    public double getNominalAscendingNodeLon() throws IOException, IllegalCeosFormatException {
        return this.readF16(652);
    }

    public double getNominalSateliteAltitude() throws IOException, IllegalCeosFormatException {
        return this.readF16(668);
    }

    public double getNominalGroundSpeed() throws IOException, IllegalCeosFormatException {
        return this.readF16(684);
    }

    public double getSatteliteHeadingAngleIncludingEarthRotationOfSceneCenter() throws IOException, IllegalCeosFormatException {
        return this.readF16(700);
    }

    public double getSwathAngle() throws IOException, IllegalCeosFormatException {
        return this.readF16(732);
    }

    public double getNominalScanRate() throws IOException, IllegalCeosFormatException {
        return this.readF16(748);
    }

    public String getReferenceEllipsoid() {
        return this._referenceEllipsoid;
    }

    public double getSemimajorAxisOfReferenceEllipsoid() {
        return this._semimajorAxisOfReferenceEllipsoid;
    }

    public double getSemiminorAxisOfReferenceEllipsoid() {
        return this._semiminorAxisOfReferenceEllipsoid;
    }

    public String getGeodeticCoordinateName() {
        return this._GeodeticCoordinateName;
    }

    public double[] getLatCoeffs_1B2() throws IOException, IllegalCeosFormatException {
        return this.readDoubles(10, 956);
    }

    public double[] getLonCoeffs_1B2() throws IOException, IllegalCeosFormatException {
        return this.readDoubles(10, 1196);
    }

    public double[] getXCoeffs_1B2() throws IOException, IllegalCeosFormatException {
        return this.readDoubles(10, 1436);
    }

    public double[] getYCoeffs_1B2() throws IOException, IllegalCeosFormatException {
        return this.readDoubles(10, 1676);
    }

    public double[][] getTransformationCoeffsL1B2() throws IOException, IllegalCeosFormatException {
        if (this._L1B2Coeffs == null) {
            this._L1B2Coeffs = new double[4][10];
            long[] tempLongs = new long[this._L1B2Coeffs[0].length];
            this.getReader().seek(this.getAbsolutPosition(956L));
            for (int i = 0; i < this._L1B2Coeffs.length; ++i) {
                this.getReader().readB8(tempLongs);
                this._L1B2Coeffs[i] = CeosHelper.convertLongToDouble(tempLongs);
            }
        }
        return this._L1B2Coeffs;
    }

    public double[] getF4FunctionCoeffs_1B2() throws IOException, IllegalCeosFormatException {
        long[] longs = this.readLongs(6, 1916);
        return CeosHelper.convertLongToDouble(longs);
    }

    public abstract double[][] getTransformationCoefficientsFor(int var1) throws IOException, IllegalCeosFormatException;

    private double readF16(int relativePosition) throws IOException, IllegalCeosFormatException {
        this.getReader().seek(this.getAbsolutPosition(relativePosition));
        return this.getReader().readFn(16);
    }

    private double[] readDoubles(int numDoubles, int relativePosition) throws IOException, IllegalCeosFormatException {
        double[] coeffs = new double[numDoubles];
        this.getReader().seek(this.getAbsolutPosition(relativePosition));
        this.getReader().readGn(24, coeffs);
        return coeffs;
    }

    private long readIn(int n, int relativePosition) throws IOException, IllegalCeosFormatException {
        this.getReader().seek(this.getAbsolutPosition(relativePosition));
        return this.getReader().readIn(n);
    }
}

