/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.BaseRecord;

public class Ancillary2Record
extends BaseRecord {
    private String _sensorOperationMode;
    private int _lowerLimitOfStrengthAfterCorrection;
    private int _upperLimitOfStrengthAfterCorrection;
    private String _sensorGains;

    public Ancillary2Record(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public Ancillary2Record(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
        this.readGeneralFields(reader);
        reader.seek(this.getAbsolutPosition(this.getRecordLength()));
    }

    private void readGeneralFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this._sensorOperationMode = reader.readAn(4);
        this._lowerLimitOfStrengthAfterCorrection = reader.readI4();
        this._upperLimitOfStrengthAfterCorrection = reader.readI4();
        reader.skipBytes(32L);
        this._sensorGains = reader.readAn(6);
        this.readSpecificFields(reader);
    }

    protected void readSpecificFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
    }

    public String getSensorOperationMode() {
        return this._sensorOperationMode;
    }

    public int getLowerLimitOfStrengthAfterCorrection() {
        return this._lowerLimitOfStrengthAfterCorrection;
    }

    public int getUpperLimitOfStrengthAfterCorrection() {
        return this._upperLimitOfStrengthAfterCorrection;
    }

    public String getSensorGains() {
        return this._sensorGains;
    }
}

