/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.BaseRecord;

public class Ancillary3Record
extends BaseRecord {
    private final String _orbitalElementsType;
    private final int _numDataPoints;
    private final int _firstPointYear;
    private final int _firstPointMonth;
    private final int _firstPointDay;
    private final int _firstPointTotalDays;
    private final double _firstPointTotalSeconds;
    private final double _intervalTimeBetweenPoints;
    private final String _referenceCoordinateSystem;
    private final double _positionalErrorFlightDirection;
    private final double _positionalErrorFlightVerticalDirection;
    private final double _positionalErrorRadiusDirection;
    private final double _velocityErrorFlightDirection;
    private final double _velocityErrorFlightVerticalDirection;
    private final double _velocityErrorRadiusDirection;
    private final DataPoint[] _dataPoints;
    private final int _flagLeapSecond;

    public Ancillary3Record(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public Ancillary3Record(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
        this._orbitalElementsType = reader.readAn(32);
        reader.skipBytes(96L);
        this._numDataPoints = reader.readI4();
        this._firstPointYear = reader.readI4();
        this._firstPointMonth = reader.readI4();
        this._firstPointDay = reader.readI4();
        this._firstPointTotalDays = reader.readI4();
        this._firstPointTotalSeconds = reader.readFn(22);
        this._intervalTimeBetweenPoints = reader.readFn(22);
        this._referenceCoordinateSystem = reader.readAn(64);
        reader.skipBytes(22L);
        this._positionalErrorFlightDirection = reader.readFn(16);
        this._positionalErrorFlightVerticalDirection = reader.readFn(16);
        this._positionalErrorRadiusDirection = reader.readFn(16);
        this._velocityErrorFlightDirection = reader.readFn(16);
        this._velocityErrorFlightVerticalDirection = reader.readFn(16);
        this._velocityErrorRadiusDirection = reader.readFn(16);
        this._dataPoints = new DataPoint[28];
        for (int i = 0; i < this._dataPoints.length; ++i) {
            this._dataPoints[i] = new DataPoint(reader.readFn(22), reader.readFn(22), reader.readFn(22), reader.readFn(22), reader.readFn(22), reader.readFn(22));
        }
        reader.skipBytes(18L);
        this._flagLeapSecond = (int)reader.readIn(1);
        reader.skipBytes(579L);
    }

    public String getOrbitalElementsType() {
        return this._orbitalElementsType;
    }

    public int getNumDataPoints() {
        return this._numDataPoints;
    }

    public int getFirstPointYear() {
        return this._firstPointYear;
    }

    public int getFirstPointMonth() {
        return this._firstPointMonth;
    }

    public int getFirstPointDay() {
        return this._firstPointDay;
    }

    public int getFirstPointTotalDays() {
        return this._firstPointTotalDays;
    }

    public double getFirstPointTotalSeconds() {
        return this._firstPointTotalSeconds;
    }

    public double getIntervalTimeBetweenPoints() {
        return this._intervalTimeBetweenPoints;
    }

    public String getReferenceCoordinateSystem() {
        return this._referenceCoordinateSystem;
    }

    public double getPositionalErrorFlightDirection() {
        return this._positionalErrorFlightDirection;
    }

    public double getPositionalErrorFlightVerticalDirection() {
        return this._positionalErrorFlightVerticalDirection;
    }

    public double getPositionalErrorRadiusDirection() {
        return this._positionalErrorRadiusDirection;
    }

    public double getVelocityErrorFlightDirection() {
        return this._velocityErrorFlightDirection;
    }

    public double getVelocityErrorFlightVerticalDirection() {
        return this._velocityErrorFlightVerticalDirection;
    }

    public double getVelocityErrorRadiusDirection() {
        return this._velocityErrorRadiusDirection;
    }

    public DataPoint[] getDataPoints() {
        return this._dataPoints;
    }

    public int getFlagLeapSecond() {
        return this._flagLeapSecond;
    }

    public static class DataPoint {
        private final double _positionalVectorDataPointX;
        private final double _positionalVectorDataPointY;
        private final double _positionalVectorDataPointZ;
        private final double _velocityVectorDataPointX;
        private final double _velocityVectorDataPointY;
        private final double _velocityVectorDataPointZ;

        public DataPoint(double positionalVectorDataPointX, double positionalVectorDataPointY, double positionalVectorDataPointZ, double velocityVectorDataPointX, double velocityVectorDataPointY, double velocityVectorDataPointZ) {
            this._positionalVectorDataPointX = positionalVectorDataPointX;
            this._positionalVectorDataPointY = positionalVectorDataPointY;
            this._positionalVectorDataPointZ = positionalVectorDataPointZ;
            this._velocityVectorDataPointX = velocityVectorDataPointX;
            this._velocityVectorDataPointY = velocityVectorDataPointY;
            this._velocityVectorDataPointZ = velocityVectorDataPointZ;
        }

        public double getPositionalVectorDataPointX() {
            return this._positionalVectorDataPointX;
        }

        public double getPositionalVectorDataPointY() {
            return this._positionalVectorDataPointY;
        }

        public double getPositionalVectorDataPointZ() {
            return this._positionalVectorDataPointZ;
        }

        public double getVelocityVectorDataPointX() {
            return this._velocityVectorDataPointX;
        }

        public double getVelocityVectorDataPointY() {
            return this._velocityVectorDataPointY;
        }

        public double getVelocityVectorDataPointZ() {
            return this._velocityVectorDataPointZ;
        }
    }
}

