/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.CommonFileDescriptorRecord;

public abstract class BaseImageFileDescriptorRecord
extends CommonFileDescriptorRecord {
    private int _numImageRecords;
    private int _imageRecordLength;
    private int _numBitsPerPixel;
    private int _numPixelsPerData;
    private int _numBytesPerData;
    private String _bitlistOfPixel;
    private int _numBandsPerFile;
    private int _numLinesPerBand;
    private int _numLeftBorderPixelsPerLine;
    private int _numImagePixelsPerLine;
    private int _numRightBorderPixelsPerLine;
    private int _numTopBorderLines;
    private int _numBottomBorderLines;
    private String _imageFormatID;
    private int _numRecordsPerLineSingleUnit;
    private int _numRecordsPerLine;
    private int _numBytesCoverIdentifierAndHeader;
    private int _numImgDataBytesPerRecAndDummyPix;
    private int _numBytesOfSuffixDataPerRecord;
    private String _flagPrefixDataRepeat;
    private String _locatorLineNumber;
    private String _locatorBandNumber;
    private String _locatorScanStartTime;
    private String _locatorLeftDummyPixel;
    private String _locatorRightDummyPixel;
    private String _dataFormatTypeId;
    private String _dataFormatTypeIdCode;
    private int _numLeftUnusedBitsInPixelData;
    private int _numRightUnusedBitsInPixelData;
    private int _maxPixelDataValue;

    public BaseImageFileDescriptorRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public BaseImageFileDescriptorRecord(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
        this.readFields(reader);
        reader.seek(this.getAbsolutPosition(this.getRecordLength()));
    }

    private void readFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this._numImageRecords = (int)reader.readIn(6);
        this._imageRecordLength = (int)reader.readIn(6);
        reader.skipBytes(24L);
        this._numBitsPerPixel = reader.readI4();
        this._numPixelsPerData = reader.readI4();
        this._numBytesPerData = reader.readI4();
        this._bitlistOfPixel = reader.readAn(4);
        this._numBandsPerFile = reader.readI4();
        this._numLinesPerBand = (int)reader.readIn(8);
        this._numLeftBorderPixelsPerLine = reader.readI4();
        this._numImagePixelsPerLine = (int)reader.readIn(8);
        this._numRightBorderPixelsPerLine = reader.readI4();
        this._numTopBorderLines = reader.readI4();
        this._numBottomBorderLines = reader.readI4();
        this._imageFormatID = reader.readAn(4);
        this._numRecordsPerLineSingleUnit = reader.readI4();
        this._numRecordsPerLine = reader.readI4();
        this._numBytesCoverIdentifierAndHeader = reader.readI4();
        this._numImgDataBytesPerRecAndDummyPix = (int)reader.readIn(8);
        this._numBytesOfSuffixDataPerRecord = reader.readI4();
        this._flagPrefixDataRepeat = reader.readAn(4);
        this._locatorLineNumber = reader.readAn(8);
        this._locatorBandNumber = reader.readAn(8);
        this._locatorScanStartTime = reader.readAn(8);
        this._locatorLeftDummyPixel = reader.readAn(8);
        this._locatorRightDummyPixel = reader.readAn(8);
        reader.skipBytes(52L);
        this._dataFormatTypeId = reader.readAn(36);
        this._dataFormatTypeIdCode = reader.readAn(4);
        this._numLeftUnusedBitsInPixelData = reader.readI4();
        this._numRightUnusedBitsInPixelData = reader.readI4();
        this._maxPixelDataValue = reader.readI4();
        this.readSpecificFields(reader);
    }

    protected void readSpecificFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
    }

    public int getNumImageRecords() {
        return this._numImageRecords;
    }

    public int getImageRecordLength() {
        return this._imageRecordLength;
    }

    public int getNumBitsPerPixel() {
        return this._numBitsPerPixel;
    }

    public int getNumPixelsPerData() {
        return this._numPixelsPerData;
    }

    public int getNumBytesPerData() {
        return this._numBytesPerData;
    }

    public String getBitlistOfPixel() {
        return this._bitlistOfPixel;
    }

    public int getNumBandsPerFile() {
        return this._numBandsPerFile;
    }

    public int getNumLinesPerBand() {
        return this._numLinesPerBand;
    }

    public int getNumLeftBorderPixelsPerLine() {
        return this._numLeftBorderPixelsPerLine;
    }

    public int getNumImagePixelsPerLine() {
        return this._numImagePixelsPerLine;
    }

    public int getNumRightBorderPixelsPerLine() {
        return this._numRightBorderPixelsPerLine;
    }

    public int getNumTopBorderLines() {
        return this._numTopBorderLines;
    }

    public int getNumBottomBorderLines() {
        return this._numBottomBorderLines;
    }

    public String getImageFormatID() {
        return this._imageFormatID;
    }

    public int getNumRecordsPerLineSingleUnit() {
        return this._numRecordsPerLineSingleUnit;
    }

    public int getNumRecordsPerLine() {
        return this._numRecordsPerLine;
    }

    public int getNumBytesCoverIdentifierAndHeader() {
        return this._numBytesCoverIdentifierAndHeader;
    }

    public int getNumImgDataBytesPerRecAndDummyPix() {
        return this._numImgDataBytesPerRecAndDummyPix;
    }

    public int getNumBytesOfSuffixDataPerRecord() {
        return this._numBytesOfSuffixDataPerRecord;
    }

    public String getFlagPrefixDataRepeat() {
        return this._flagPrefixDataRepeat;
    }

    public String getLocatorBandNumber() {
        return this._locatorBandNumber;
    }

    public String getLocatorLeftDummyPixel() {
        return this._locatorLeftDummyPixel;
    }

    public String getLocatorLineNumber() {
        return this._locatorLineNumber;
    }

    public String getLocatorRightDummyPixel() {
        return this._locatorRightDummyPixel;
    }

    public String getLocatorScanStartTime() {
        return this._locatorScanStartTime;
    }

    public String getDataFormatTypeId() {
        return this._dataFormatTypeId;
    }

    public String getDataFormatTypeIdCode() {
        return this._dataFormatTypeIdCode;
    }

    public int getNumLeftUnusedBitsInPixelData() {
        return this._numLeftUnusedBitsInPixelData;
    }

    public int getNumRightUnusedBitsInPixelData() {
        return this._numRightUnusedBitsInPixelData;
    }

    public int getMaxPixelDataValue() {
        return this._maxPixelDataValue;
    }
}

