/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.CommonFileDescriptorRecord;

public class BaseLeaderFileDescriptorRecord
extends CommonFileDescriptorRecord {
    private int _numSceneHeaderRecords;
    private int _sceneHeaderRecordLength;
    private int _numAncillaryRecords;
    private int _ancillaryRecordLength;
    private int _sceneIdFieldLocator;
    private int _sceneIdFieldDataStart;
    private int _sceneIdFieldNumBytes;
    private String _sceneIdFieldDataType;
    private int _RSPIdLocator;
    private int _RSPIdDataStart;
    private int _RSPIdNumBytes;
    private String _RSPIdDataType;
    private int _missionIdLocator;
    private int _missionIdDataStart;
    private int _missionIdNumBytes;
    private String _missionIdDataType;
    private int _sensorIdLocator;
    private int _sensorIdDataStart;
    private int _sensorIdNumBytes;
    private String _sensorIdDataType;
    private int _sceneCenterTimeLocator;
    private int _sceneCenterTimeDataStart;
    private int _sceneCenterTimeNumBytes;
    private String _sceneCenterTimeDataType;
    private int _sceneCenterLatLonLocator;
    private int _sceneCenterLatLonDataStart;
    private int _sceneCenterLatLonNumBytes;
    private String _sceneCenterLatLonDataType;
    private int _processingLevelLocator;
    private int _processingLevelDataStart;
    private int _processingLevelNumBytes;
    private String _processingLevelDataType;
    private int _imageFormatLocator;
    private int _imageFormatDataStart;
    private int _imageFormatNumBytes;
    private String _imageFormatDataType;
    private int _effektiveBandLocator;
    private int _effektiveBandDataStart;
    private int _effektiveBandNumBytes;
    private String _effektiveBandDataType;

    public BaseLeaderFileDescriptorRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public BaseLeaderFileDescriptorRecord(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
        this.readGeneralFields(reader);
        this.readSpecificFields(reader);
        reader.seek(this.getAbsolutPosition(this.getRecordLength()));
    }

    private void readGeneralFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this._numSceneHeaderRecords = (int)reader.readIn(6);
        this._sceneHeaderRecordLength = (int)reader.readIn(6);
        this._numAncillaryRecords = (int)reader.readIn(6);
        this._ancillaryRecordLength = (int)reader.readIn(6);
        reader.skipBytes(12L);
        this._sceneIdFieldLocator = (int)reader.readIn(6);
        this._sceneIdFieldDataStart = (int)reader.readIn(6);
        this._sceneIdFieldNumBytes = (int)reader.readIn(3);
        this._sceneIdFieldDataType = reader.readAn(1);
        this._RSPIdLocator = (int)reader.readIn(6);
        this._RSPIdDataStart = (int)reader.readIn(6);
        this._RSPIdNumBytes = (int)reader.readIn(3);
        this._RSPIdDataType = reader.readAn(1);
        this._missionIdLocator = (int)reader.readIn(6);
        this._missionIdDataStart = (int)reader.readIn(6);
        this._missionIdNumBytes = (int)reader.readIn(3);
        this._missionIdDataType = reader.readAn(1);
        this._sensorIdLocator = (int)reader.readIn(6);
        this._sensorIdDataStart = (int)reader.readIn(6);
        this._sensorIdNumBytes = (int)reader.readIn(3);
        this._sensorIdDataType = reader.readAn(1);
        this._sceneCenterTimeLocator = (int)reader.readIn(6);
        this._sceneCenterTimeDataStart = (int)reader.readIn(6);
        this._sceneCenterTimeNumBytes = (int)reader.readIn(3);
        this._sceneCenterTimeDataType = reader.readAn(1);
        this._sceneCenterLatLonLocator = (int)reader.readIn(6);
        this._sceneCenterLatLonDataStart = (int)reader.readIn(6);
        this._sceneCenterLatLonNumBytes = (int)reader.readIn(3);
        this._sceneCenterLatLonDataType = reader.readAn(1);
        this._processingLevelLocator = (int)reader.readIn(6);
        this._processingLevelDataStart = (int)reader.readIn(6);
        this._processingLevelNumBytes = (int)reader.readIn(3);
        this._processingLevelDataType = reader.readAn(1);
        this._imageFormatLocator = (int)reader.readIn(6);
        this._imageFormatDataStart = (int)reader.readIn(6);
        this._imageFormatNumBytes = (int)reader.readIn(3);
        this._imageFormatDataType = reader.readAn(1);
        this._effektiveBandLocator = (int)reader.readIn(6);
        this._effektiveBandDataStart = (int)reader.readIn(6);
        this._effektiveBandNumBytes = (int)reader.readIn(3);
        this._effektiveBandDataType = reader.readAn(1);
    }

    protected void readSpecificFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
    }

    public int getNumSceneHeaderRecords() {
        return this._numSceneHeaderRecords;
    }

    public int getSceneHeaderRecordLength() {
        return this._sceneHeaderRecordLength;
    }

    public int getNumAncillaryRecords() {
        return this._numAncillaryRecords;
    }

    public int getAncillaryRecordLength() {
        return this._ancillaryRecordLength;
    }

    public int getSceneIdFieldLocator() {
        return this._sceneIdFieldLocator;
    }

    public int getSceneIdFieldDataStart() {
        return this._sceneIdFieldDataStart;
    }

    public int getSceneIdFieldNumBytes() {
        return this._sceneIdFieldNumBytes;
    }

    public String getSceneIdFieldDataType() {
        return this._sceneIdFieldDataType;
    }

    public int getRSPIdLocator() {
        return this._RSPIdLocator;
    }

    public int getRSPIdDataStart() {
        return this._RSPIdDataStart;
    }

    public int getRSPIdNumBytes() {
        return this._RSPIdNumBytes;
    }

    public String getRSPIdDataType() {
        return this._RSPIdDataType;
    }

    public int getMissionIdLocator() {
        return this._missionIdLocator;
    }

    public int getMissionIdDataStart() {
        return this._missionIdDataStart;
    }

    public int getMissionIdNumBytes() {
        return this._missionIdNumBytes;
    }

    public String getMissionIdDataType() {
        return this._missionIdDataType;
    }

    public int getSensorIdLocator() {
        return this._sensorIdLocator;
    }

    public int getSensorIdDataStart() {
        return this._sensorIdDataStart;
    }

    public int getSensorIdNumBytes() {
        return this._sensorIdNumBytes;
    }

    public String getSensorIdDataType() {
        return this._sensorIdDataType;
    }

    public int getSceneCenterTimeLocator() {
        return this._sceneCenterTimeLocator;
    }

    public int getSceneCenterTimeDataStart() {
        return this._sceneCenterTimeDataStart;
    }

    public int getSceneCenterTimeNumBytes() {
        return this._sceneCenterTimeNumBytes;
    }

    public String getSceneCenterTimeDataType() {
        return this._sceneCenterTimeDataType;
    }

    public int getSceneCenterLatLonLocator() {
        return this._sceneCenterLatLonLocator;
    }

    public int getSceneCenterLatLonDataStart() {
        return this._sceneCenterLatLonDataStart;
    }

    public int getSceneCenterLatLonNumBytes() {
        return this._sceneCenterLatLonNumBytes;
    }

    public String getSceneCenterLatLonDataType() {
        return this._sceneCenterLatLonDataType;
    }

    public int getProcessingLevelLocator() {
        return this._processingLevelLocator;
    }

    public int getProcessingLevelDataStart() {
        return this._processingLevelDataStart;
    }

    public int getProcessingLevelNumBytes() {
        return this._processingLevelNumBytes;
    }

    public String getProcessingLevelDataType() {
        return this._processingLevelDataType;
    }

    public int getImageFormatLocator() {
        return this._imageFormatLocator;
    }

    public int getImageFormatDataStart() {
        return this._imageFormatDataStart;
    }

    public int getImageFormatNumBytes() {
        return this._imageFormatNumBytes;
    }

    public String getImageFormatDataType() {
        return this._imageFormatDataType;
    }

    public int getEffektiveBandLocator() {
        return this._effektiveBandLocator;
    }

    public int getEffektiveBandDataStart() {
        return this._effektiveBandDataStart;
    }

    public int getEffektiveBandNumBytes() {
        return this._effektiveBandNumBytes;
    }

    public String getEffektiveBandDataType() {
        return this._effektiveBandDataType;
    }
}

