/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.BaseRecord;

public abstract class BaseSceneHeaderRecord
extends BaseRecord {
    private static final int YEAR_OFFSET = 2000;
    private static final HashMap MONTH_TABLE = new HashMap();
    private int _headerRecordNumber;
    private String _productId;
    private String _uncorrectedSceneId;
    private double _sceneCenterLat_L1A_L1B1;
    private double _sceneCenterLon_L1A_L1B1;
    private double _sceneCenterLineNum_L1A_L1B1;
    private double _sceneCenterPixelNum_L1A_L1B1;
    private String _sceneCenterTime;
    private long _timeOffsetFromNominalRspCenter;
    private String _rspId;
    private long _orbitsPerCycle;
    private String _sceneID_L1B2;
    private double _sceneCenterLat_L1B2;
    private double _sceneCenterLon_L1B2;
    private double _sceneCenterLineNum_L1B2;
    private double _sceneCenterPixelNum_L1B2;
    private String _orientationAngle;
    private String _incidentAngle;
    private String _missionId;
    private String _sensorId;
    private long _calcOrbitNo;
    private String _orbitDirection;
    private String _dateImageWasTaken;
    private String _sceneCenterLonLat;
    private String _sensorTypeAndSpectrumBandIdentification;
    private String _sceneCenterSunAngle;
    private String _processingCode;
    private String _competentAgentAndProjectIdentification;
    private String _sceneId;
    private long _numEffectiveBands;
    private long _numPixelsPerLineInImage;
    private long _numLinesInImage;
    private long _radiometricResolution;
    private String _level1B2Option;
    private String _resamplingMethod;
    private String _mapProjectionMethod;
    private String _correctionLevel;
    private long _numMapProjAncillaryRecords;
    private long _numRadiometricAncillaryRecords;
    private int[] _effektiveBands;
    private String _imageFormat;
    private double _sceneCornerUpperLeftLat;
    private double _sceneCornerUpperLeftLon;
    private double _sceneCornerUpperRightLat;
    private double _sceneCornerUpperRightLon;
    private double _sceneCornerLowerLeftLat;
    private double _sceneCornerLowerLeftLon;
    private double _sceneCornerLowerRightLat;
    private double _sceneCornerLowerRightLon;
    private String _statusTimeSystem;
    private String _statusAbsoluteNavigation;
    private String _flagAttitudeDetermination;
    private String _accuracyUsedOrbitData;
    private String _accuracyUsedAttitudeData;

    public BaseSceneHeaderRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public BaseSceneHeaderRecord(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
        this.readGeneralFields(reader);
        reader.seek(this.getAbsolutPosition(this.getRecordLength()));
    }

    private void readGeneralFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this._headerRecordNumber = reader.readI4();
        reader.skipBytes(4L);
        this._productId = reader.readAn(16);
        this._uncorrectedSceneId = reader.readAn(16);
        this._sceneCenterLat_L1A_L1B1 = reader.readFn(16);
        this._sceneCenterLon_L1A_L1B1 = reader.readFn(16);
        this._sceneCenterLineNum_L1A_L1B1 = reader.readFn(16);
        this._sceneCenterPixelNum_L1A_L1B1 = reader.readFn(16);
        this._sceneCenterTime = reader.readAn(32);
        this._timeOffsetFromNominalRspCenter = reader.readIn(16);
        this._rspId = reader.readAn(16);
        this._orbitsPerCycle = reader.readIn(16);
        this._sceneID_L1B2 = reader.readAn(16);
        this._sceneCenterLat_L1B2 = reader.readFn(16);
        this._sceneCenterLon_L1B2 = reader.readFn(16);
        this._sceneCenterLineNum_L1B2 = reader.readFn(16);
        this._sceneCenterPixelNum_L1B2 = reader.readFn(16);
        this._orientationAngle = reader.readAn(16);
        this._incidentAngle = reader.readAn(16);
        this._missionId = reader.readAn(16);
        this._sensorId = reader.readAn(16);
        this._calcOrbitNo = reader.readIn(16);
        this._orbitDirection = reader.readAn(16);
        reader.skipBytes(28L);
        this._dateImageWasTaken = reader.readAn(8);
        this._sceneCenterLonLat = reader.readAn(17);
        reader.skipBytes(17L);
        this._sensorTypeAndSpectrumBandIdentification = reader.readAn(10);
        this._sceneCenterSunAngle = reader.readAn(14);
        this._processingCode = reader.readAn(12);
        this._competentAgentAndProjectIdentification = reader.readAn(12);
        this._sceneId = reader.readAn(16);
        reader.skipBytes(906L);
        this._numEffectiveBands = reader.readIn(16);
        this._numPixelsPerLineInImage = reader.readIn(16);
        this._numLinesInImage = reader.readIn(16);
        reader.skipBytes(32L);
        this._radiometricResolution = reader.readIn(16);
        reader.skipBytes(16L);
        this._level1B2Option = reader.readAn(16);
        this._resamplingMethod = reader.readAn(16);
        this._mapProjectionMethod = reader.readAn(16);
        this._correctionLevel = reader.readAn(16);
        this._numMapProjAncillaryRecords = reader.readIn(16);
        this._numRadiometricAncillaryRecords = reader.readIn(16);
        reader.skipBytes(32L);
        this._effektiveBands = reader.readInArray(64, 1);
        this._imageFormat = reader.readAn(16);
        this._sceneCornerUpperLeftLat = reader.readFn(16);
        this._sceneCornerUpperLeftLon = reader.readFn(16);
        this._sceneCornerUpperRightLat = reader.readFn(16);
        this._sceneCornerUpperRightLon = reader.readFn(16);
        this._sceneCornerLowerLeftLat = reader.readFn(16);
        this._sceneCornerLowerLeftLon = reader.readFn(16);
        this._sceneCornerLowerRightLat = reader.readFn(16);
        this._sceneCornerLowerRightLon = reader.readFn(16);
        this._statusTimeSystem = reader.readAn(2);
        this._statusAbsoluteNavigation = reader.readAn(2);
        this._flagAttitudeDetermination = reader.readAn(2);
        this._accuracyUsedOrbitData = reader.readAn(2);
        this._accuracyUsedAttitudeData = reader.readAn(2);
        this.readSpecificFields(reader);
    }

    protected void readSpecificFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
    }

    public int getHeaderRecordNumber() {
        return this._headerRecordNumber;
    }

    public String getProductId() {
        return this._productId;
    }

    public String getProductLevel() {
        String levelString = this._productId.substring(1, 4);
        levelString = levelString.replace('_', ' ');
        return levelString.trim();
    }

    public String getUncorrectedSceneId() {
        return this._uncorrectedSceneId;
    }

    public double getSceneCenterLat_L1A_L1B1() {
        return this._sceneCenterLat_L1A_L1B1;
    }

    public double getSceneCenterLon_L1A_L1B1() {
        return this._sceneCenterLon_L1A_L1B1;
    }

    public double getSceneCenterLineNum_L1A_L1B1() {
        return this._sceneCenterLineNum_L1A_L1B1;
    }

    public double getSceneCenterPixelNum_L1A_L1B1() {
        return this._sceneCenterPixelNum_L1A_L1B1;
    }

    public String getSceneCenterTime() {
        return this._sceneCenterTime;
    }

    public long getTimeOffsetFromNominalRspCenter() {
        return this._timeOffsetFromNominalRspCenter;
    }

    public String getRspId() {
        return this._rspId;
    }

    public long getOrbitsPerCycle() {
        return this._orbitsPerCycle;
    }

    public String getSceneID_L1B2() {
        return this._sceneID_L1B2;
    }

    public double getSceneCenterLat_L1B2() {
        return this._sceneCenterLat_L1B2;
    }

    public double getSceneCenterLon_L1B2() {
        return this._sceneCenterLon_L1B2;
    }

    public double getSceneCenterLineNum_L1B2() {
        return this._sceneCenterLineNum_L1B2;
    }

    public double getSceneCenterPixelNum_L1B2() {
        return this._sceneCenterPixelNum_L1B2;
    }

    public String getOrientationAngle() {
        return this._orientationAngle;
    }

    public String getIncidentAngle() {
        return this._incidentAngle;
    }

    public String getMissionId() {
        return this._missionId;
    }

    public String getSensorId() {
        return this._sensorId;
    }

    public long getCalcOrbitNo() {
        return this._calcOrbitNo;
    }

    public String getOrbitDirection() {
        return this._orbitDirection;
    }

    public Calendar getDateImageWasTaken() {
        Calendar calendar = Calendar.getInstance();
        int days = Integer.parseInt(this._dateImageWasTaken.substring(0, 2));
        int month = (Integer)MONTH_TABLE.get(this._dateImageWasTaken.substring(2, 5));
        int year = Integer.parseInt(this._dateImageWasTaken.substring(5, 7)) + 2000;
        calendar.set(year, month - 1, days, 0, 0, 0);
        return calendar;
    }

    public String getSceneCenterLonLat() {
        return this._sceneCenterLonLat;
    }

    public String getSensorTypeAndSpectrumBandIdentification() {
        return this._sensorTypeAndSpectrumBandIdentification;
    }

    public String getSceneCenterSunAngle() {
        return this._sceneCenterSunAngle;
    }

    public String getProcessingCode() {
        return this._processingCode;
    }

    public String getCompetentAgentAndProjectIdentification() {
        return this._competentAgentAndProjectIdentification;
    }

    public String getSceneId() {
        return this._sceneId;
    }

    public long getNumEffectiveBands() {
        return this._numEffectiveBands;
    }

    public long getNumPixelsPerLineInImage() {
        return this._numPixelsPerLineInImage;
    }

    public long getNumLinesInImage() {
        return this._numLinesInImage;
    }

    public long getRadiometricResolution() {
        return this._radiometricResolution;
    }

    public String getLevel1B2Option() {
        return this._level1B2Option;
    }

    public String getResamplingMethod() {
        return this._resamplingMethod;
    }

    public String getMapProjectionMethod() {
        return this._mapProjectionMethod;
    }

    public String getCorrectionLevel() {
        return this._correctionLevel;
    }

    public long getNumMapProjAncillaryRecords() {
        return this._numMapProjAncillaryRecords;
    }

    public long getNumRadiometricAncillaryRecords() {
        return this._numRadiometricAncillaryRecords;
    }

    public int[] getEffektiveBands() {
        return this._effektiveBands;
    }

    public String getImageFormat() {
        return this._imageFormat;
    }

    public double getSceneCornerUpperLeftLat() {
        return this._sceneCornerUpperLeftLat;
    }

    public double getSceneCornerUpperLeftLon() {
        return this._sceneCornerUpperLeftLon;
    }

    public double getSceneCornerUpperRightLat() {
        return this._sceneCornerUpperRightLat;
    }

    public double getSceneCornerUpperRightLon() {
        return this._sceneCornerUpperRightLon;
    }

    public double getSceneCornerLowerLeftLat() {
        return this._sceneCornerLowerLeftLat;
    }

    public double getSceneCornerLowerLeftLon() {
        return this._sceneCornerLowerLeftLon;
    }

    public double getSceneCornerLowerRightLat() {
        return this._sceneCornerLowerRightLat;
    }

    public double getSceneCornerLowerRightLon() {
        return this._sceneCornerLowerRightLon;
    }

    public String getStatusTimeSystem() {
        return this._statusTimeSystem;
    }

    public String getStatusAbsoluteNavigation() {
        return this._statusAbsoluteNavigation;
    }

    public String getFlagAttitudeDetermination() {
        return this._flagAttitudeDetermination;
    }

    public String getAccuracyUsedOrbitData() {
        return this._accuracyUsedOrbitData;
    }

    public String getAccuracyUsedAttitudeData() {
        return this._accuracyUsedAttitudeData;
    }

    public abstract String getYawSteeringFlag();

    static {
        MONTH_TABLE.put("Jan", 1);
        MONTH_TABLE.put("Feb", 2);
        MONTH_TABLE.put("Mar", 3);
        MONTH_TABLE.put("Apr", 4);
        MONTH_TABLE.put("May", 5);
        MONTH_TABLE.put("Jun", 6);
        MONTH_TABLE.put("Jul", 7);
        MONTH_TABLE.put("Aug", 8);
        MONTH_TABLE.put("Sep", 9);
        MONTH_TABLE.put("Oct", 10);
        MONTH_TABLE.put("Nov", 11);
        MONTH_TABLE.put("Dec", 12);
    }
}

