/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.BaseRecord;

public abstract class BaseTrailerRecord
extends BaseRecord {
    private int _numTrailerRecords;
    private int _numTrailerRecordsInOneCCDUnit;

    public BaseTrailerRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public BaseTrailerRecord(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
        this.readGeneralFields(reader);
        reader.seek(this.getAbsolutPosition(this.getRecordLength()));
    }

    private void readGeneralFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this._numTrailerRecords = reader.readI4();
        this._numTrailerRecordsInOneCCDUnit = reader.readI4();
        this.readSpecificFields(reader);
    }

    protected void readSpecificFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
    }

    public int getNumTrailerRecords() {
        return this._numTrailerRecords;
    }

    public int getNumTrailerRecordsInOneCCDUnit() {
        return this._numTrailerRecordsInOneCCDUnit;
    }

    protected final void readHistograms(CeosFileReader reader, int[][] histos) throws IOException, IllegalCeosFormatException {
        for (int i = 0; i < histos.length; ++i) {
            int[] histoCCD = histos[i];
            reader.readB4(histoCCD);
        }
    }

    protected abstract int[] getHistogramFor(int var1);
}

