/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.BaseRecord;

public class CommonFileDescriptorRecord
extends BaseRecord {
    private String _codeCharacter;
    private String _fileDocumentNumber;
    private String _fileDokumentRevisionNumber;
    private String _fileDesignRevisionLetter;
    private String _logicalVolPrepSysRelNum;
    private int _fileNumber;
    private String _fileID;
    private String _flagRecordComposition;
    private int _recordNumberPositionOfEachFile;
    private int _fieldLengthForRecordData;
    private String _flagOfRecordTypeCode;
    private int _recordTypeCodeBytePosition;
    private int _recordTypeCodeFieldLength;
    private String _flagRecordLength;
    private int _bytePosOfRecLength;
    private int _numOfBytesOfRecLength;
    private String _flagDataConvInfFileDescRec;
    private String _flagDataConvInOtherRecords;
    private String _flagDataDispFileDescRecord;
    private String _flagDataDispInOtherRecords;

    public CommonFileDescriptorRecord(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
        this._codeCharacter = reader.readAn(2);
        reader.skipBytes(2L);
        this._fileDocumentNumber = reader.readAn(12);
        this._fileDokumentRevisionNumber = reader.readAn(2);
        this._fileDesignRevisionLetter = reader.readAn(2);
        this._logicalVolPrepSysRelNum = reader.readAn(12);
        this._fileNumber = reader.readI4();
        this._fileID = reader.readAn(16);
        this._flagRecordComposition = reader.readAn(4);
        this._recordNumberPositionOfEachFile = (int)reader.readIn(8);
        this._fieldLengthForRecordData = reader.readI4();
        this._flagOfRecordTypeCode = reader.readAn(4);
        this._recordTypeCodeBytePosition = (int)reader.readIn(8);
        this._recordTypeCodeFieldLength = reader.readI4();
        this._flagRecordLength = reader.readAn(4);
        this._bytePosOfRecLength = (int)reader.readIn(8);
        this._numOfBytesOfRecLength = reader.readI4();
        this._flagDataConvInfFileDescRec = reader.readAn(1);
        this._flagDataConvInOtherRecords = reader.readAn(1);
        this._flagDataDispFileDescRecord = reader.readAn(1);
        this._flagDataDispInOtherRecords = reader.readAn(1);
        reader.skipBytes(64L);
    }

    public String getCodeCharacter() {
        return this._codeCharacter;
    }

    public String getFileDocumentNumber() {
        return this._fileDocumentNumber;
    }

    public String getFileDokumentRevisionNumber() {
        return this._fileDokumentRevisionNumber;
    }

    public String getFileDesignRevisionLetter() {
        return this._fileDesignRevisionLetter;
    }

    public String getLogicalVolPrepSysRelNum() {
        return this._logicalVolPrepSysRelNum;
    }

    public int getFileNumber() {
        return this._fileNumber;
    }

    public String getFileID() {
        return this._fileID;
    }

    public String getFlagRecordComposition() {
        return this._flagRecordComposition;
    }

    public int getRecordNumberPositionOfEachFile() {
        return this._recordNumberPositionOfEachFile;
    }

    public int getFieldLengthForRecordData() {
        return this._fieldLengthForRecordData;
    }

    public String getFlagOfRecordTypeCode() {
        return this._flagOfRecordTypeCode;
    }

    public int getRecordTypeCodeBytePosition() {
        return this._recordTypeCodeBytePosition;
    }

    public int getRecordTypeCodeFieldLength() {
        return this._recordTypeCodeFieldLength;
    }

    public String getFlagRecordLength() {
        return this._flagRecordLength;
    }

    public int getBytePosOfRecLength() {
        return this._bytePosOfRecLength;
    }

    public int getNumOfBytesOfRecLength() {
        return this._numOfBytesOfRecLength;
    }

    public String getFlagDataConvInfFileDescRec() {
        return this._flagDataConvInfFileDescRec;
    }

    public String getFlagDataConvInOtherRecords() {
        return this._flagDataConvInOtherRecords;
    }

    public String getFlagDataDispFileDescRecord() {
        return this._flagDataDispFileDescRecord;
    }

    public String getFlagDataDispInOtherRecords() {
        return this._flagDataDispInOtherRecords;
    }
}

