/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.BaseRecord;
import org.esa.beam.framework.datamodel.MetadataElement;

public class FilePointerRecord
extends BaseRecord {
    public static final int RECORD_LENGTH = 360;
    private static final String IMAGE_FILE_CLASS_CODE = "IMGY";
    private final String _codeCharacter;
    private final int _filePointerNumber;
    private final String _fileID;
    private final String _fileClass;
    private final String _fileClassCode;
    private final String _fileDataType;
    private final String _fileDataTypeCode;
    private final int _numberOfRecords;
    private final int _firstRecordLength;
    private final int _maxRecordLength;
    private final String _recordLengthType;
    private final String _recordLengthTypeCode;
    private final int _firstRecordVolumeNumber;
    private final int _finalRecordVolumeNumber;
    private final int _firstRecordNumberOfReferencedFile;

    public FilePointerRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public FilePointerRecord(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
        this._codeCharacter = reader.readAn(2);
        reader.skipBytes(2L);
        this._filePointerNumber = reader.readI4();
        this._fileID = reader.readAn(16);
        this._fileClass = reader.readAn(28);
        this._fileClassCode = reader.readAn(4);
        this._fileDataType = reader.readAn(28);
        this._fileDataTypeCode = reader.readAn(4);
        this._numberOfRecords = (int)reader.readIn(8);
        this._firstRecordLength = (int)reader.readIn(8);
        this._maxRecordLength = (int)reader.readIn(8);
        this._recordLengthType = reader.readAn(12);
        this._recordLengthTypeCode = reader.readAn(4);
        this._firstRecordVolumeNumber = (int)reader.readIn(2);
        this._finalRecordVolumeNumber = (int)reader.readIn(2);
        this._firstRecordNumberOfReferencedFile = (int)reader.readIn(8);
        reader.skipBytes(208L);
    }

    public String getCodeCharacter() {
        return this._codeCharacter;
    }

    public String getFileClass() {
        return this._fileClass;
    }

    public String getFileClassCode() {
        return this._fileClassCode;
    }

    public String getFileDataType() {
        return this._fileDataType;
    }

    public String getFileDataTypeCode() {
        return this._fileDataTypeCode;
    }

    public String getFileID() {
        return this._fileID;
    }

    public int getFilePointerNumber() {
        return this._filePointerNumber;
    }

    public int getFirstRecordLength() {
        return this._firstRecordLength;
    }

    public int getMaxRecordLength() {
        return this._maxRecordLength;
    }

    public int getNumberOfRecords() {
        return this._numberOfRecords;
    }

    public String getRecordLengthType() {
        return this._recordLengthType;
    }

    public String getRecordLengthTypeCode() {
        return this._recordLengthTypeCode;
    }

    public boolean isImageFileRecord() {
        return IMAGE_FILE_CLASS_CODE.equalsIgnoreCase(this._fileClassCode);
    }

    public int getFirstRecordVolumeNumber() {
        return this._firstRecordVolumeNumber;
    }

    public int getFinalRecordVolumeNumber() {
        return this._finalRecordVolumeNumber;
    }

    public int getFirstRecordNumberOfReferencedFile() {
        return this._firstRecordNumberOfReferencedFile;
    }

    @Override
    public void assignMetadataTo(MetadataElement root, String suffix) {
        MetadataElement elem = FilePointerRecord.createMetadataElement("FilePointerRecord", suffix);
        root.addElement(elem);
        super.assignMetadataTo(elem, null);
        elem.setAttributeString("Code character", this._codeCharacter);
        elem.setAttributeInt("File pointer number", this._filePointerNumber);
        elem.setAttributeString("File ID", this._fileID);
        elem.setAttributeString("File class", this._fileClass);
        elem.setAttributeString("File class code", this._fileClassCode);
        elem.setAttributeString("File datatype", this._fileDataType);
        elem.setAttributeString("File datatype code", this._fileDataTypeCode);
        elem.setAttributeInt("Number of records", this._numberOfRecords);
        elem.setAttributeInt("First record length", this._firstRecordLength);
        elem.setAttributeInt("Max record length", this._maxRecordLength);
        elem.setAttributeString("Record lengthtype", this._recordLengthType);
        elem.setAttributeString("Record lengthtype code", this._recordLengthTypeCode);
        elem.setAttributeInt("First record volume numer", this._firstRecordVolumeNumber);
        elem.setAttributeInt("Final record volume number", this._finalRecordVolumeNumber);
        elem.setAttributeInt("First record number of referenced file", this._firstRecordNumberOfReferencedFile);
    }
}

