/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.ceos.records;

import java.io.IOException;
import org.esa.beam.dataio.ceos.CeosFileReader;
import org.esa.beam.dataio.ceos.IllegalCeosFormatException;
import org.esa.beam.dataio.ceos.records.BaseRecord;

public class ImageRecord
extends BaseRecord {
    public int _prefixDataLineNumber;
    public int _imageNumber;
    public int _scanStartTimeMillisAtDay;
    public short _scanStartTimeMicros;
    public int _numLeftDummyPixels;
    public int _numRightDummyPixels;
    public long _imageDataStart;

    public ImageRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public ImageRecord(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
        this._prefixDataLineNumber = reader.readB4();
        this._imageNumber = reader.readB4();
        this._scanStartTimeMillisAtDay = reader.readB4();
        this._scanStartTimeMicros = reader.readB2();
        this._numLeftDummyPixels = reader.readB4();
        this._numRightDummyPixels = reader.readB4();
        this._imageDataStart = reader.getCurrentPos();
        reader.skipBytes(this.getStartPos() + (long)this.getRecordLength() - this._imageDataStart);
    }

    public int getPrefixDataLineNumber() {
        return this._prefixDataLineNumber;
    }

    public int getImageNumber() {
        return this._imageNumber;
    }

    public int getScanStartTimeMillisAtDay() {
        return this._scanStartTimeMillisAtDay;
    }

    public short getScanStartTimeMicros() {
        return this._scanStartTimeMicros;
    }

    public int getNumLeftDummyPixels() {
        return this._numLeftDummyPixels;
    }

    public int getNumRightDummyPixels() {
        return this._numRightDummyPixels;
    }

    public long getImageDataStart() {
        return this._imageDataStart;
    }
}

