/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff;

import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.visat.VisatApp;
import org.esa.beam.visat.actions.ProductExportAction;

public class GeoTiffExportAction
extends ProductExportAction {
    protected File promptForFile(Product product) {
        GeoCoding geoCoding = product.getGeoCoding();
        if (!(geoCoding instanceof MapGeoCoding) && !(geoCoding instanceof CrsGeoCoding)) {
            String message = String.format("The product %s is not reprojected to a map.\nUn-projected raster data is not well supported by other GIS software.\n\nDo you want to export the product without a reprojection?", product.getName());
            int answer = JOptionPane.showConfirmDialog((Component)VisatApp.getApp().getMainFrame(), message, this.getText(), 0, 2);
            if (answer != 0) {
                return null;
            }
        }
        return super.promptForFile(product);
    }
}

