/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFRenderedImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.esa.beam.dataio.dimap.DimapProductHelpers;
import org.esa.beam.dataio.geotiff.TiffFileInfo;
import org.esa.beam.dataio.geotiff.TiffTagToMetadataConverter;
import org.esa.beam.dataio.geotiff.Utils;
import org.esa.beam.dataio.geotiff.internal.GeoKeyEntry;
import org.esa.beam.framework.dataio.AbstractProductReader;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ColorPaletteDef;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.FilterBand;
import org.esa.beam.framework.datamodel.GcpDescriptor;
import org.esa.beam.framework.datamodel.GcpGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.IndexCoding;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.PlacemarkGroup;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.SampleCoding;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.util.io.FileUtils;
import org.esa.beam.util.jai.JAIUtils;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffMetadata2CRSAdapter;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class GeoTiffProductReader
extends AbstractProductReader {
    private static final int FIRST_IMAGE = 0;
    private ImageInputStream inputStream;
    private Map<Band, Integer> bandMap;
    private TIFFImageReader imageReader;

    public GeoTiffProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    protected synchronized Product readProductNodesImpl() throws IOException {
        File inputFile = null;
        Object input = this.getInput();
        if (input instanceof String) {
            input = new File((String)input);
        }
        if (input instanceof File) {
            inputFile = (File)input;
        }
        this.inputStream = ImageIO.createImageInputStream(input);
        return this.readGeoTIFFProduct(this.inputStream, inputFile);
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        int destSize = destWidth * destHeight;
        try {
            Raster data = this.readRect(sourceOffsetX, sourceOffsetY, sourceStepX, sourceStepY, destOffsetX, destOffsetY, destWidth, destHeight);
            Integer bandIdx = this.bandMap.get(destBand);
            if (bandIdx == null) {
                bandIdx = 0;
            }
            DataBuffer dataBuffer = data.getDataBuffer();
            SampleModel sampleModel = data.getSampleModel();
            int dataBufferType = dataBuffer.getDataType();
            if ((dataBufferType == 2 || dataBufferType == 1 || dataBufferType == 3) && destBuffer.getElems() instanceof int[]) {
                sampleModel.getSamples(0, 0, data.getWidth(), data.getHeight(), (int)bandIdx, (int[])destBuffer.getElems(), dataBuffer);
            } else if (dataBufferType == 4 && destBuffer.getElems() instanceof float[]) {
                sampleModel.getSamples(0, 0, data.getWidth(), data.getHeight(), (int)bandIdx, (float[])destBuffer.getElems(), dataBuffer);
            } else {
                double[] dArray = new double[destSize];
                sampleModel.getSamples(0, 0, data.getWidth(), data.getHeight(), (int)bandIdx, dArray, dataBuffer);
                int length = dArray.length;
                if (destBuffer.getElems() instanceof double[]) {
                    System.arraycopy(dArray, 0, destBuffer.getElems(), 0, length);
                } else {
                    int i = 0;
                    for (double val : dArray) {
                        destBuffer.setElemDoubleAt(i++, val);
                    }
                }
            }
        }
        catch (Throwable e) {
            for (int i = 0; i < destSize; ++i) {
                destBuffer.setElemDoubleAt(i, 0.0);
            }
        }
    }

    private synchronized Raster readRect(int sourceOffsetX, int sourceOffsetY, int sourceStepX, int sourceStepY, int destOffsetX, int destOffsetY, int destWidth, int destHeight) throws IOException {
        ImageReadParam readParam = this.imageReader.getDefaultReadParam();
        int subsamplingXOffset = sourceOffsetX % sourceStepX;
        int subsamplingYOffset = sourceOffsetY % sourceStepY;
        readParam.setSourceSubsampling(sourceStepX, sourceStepY, subsamplingXOffset, subsamplingYOffset);
        RenderedImage subsampledImage = this.imageReader.readAsRenderedImage(0, readParam);
        return subsampledImage.getData(new Rectangle(destOffsetX, destOffsetY, destWidth, destHeight));
    }

    public synchronized void close() throws IOException {
        super.close();
        this.inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Product readGeoTIFFProduct(ImageInputStream stream, File inputFile) throws IOException {
        String s;
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(stream);
        while (imageReaders.hasNext()) {
            ImageReader reader = imageReaders.next();
            if (!(reader instanceof TIFFImageReader)) continue;
            this.imageReader = (TIFFImageReader)reader;
            break;
        }
        if (this.imageReader == null) {
            throw new IOException("GeoTiff imageReader not found");
        }
        this.imageReader.setInput((Object)stream);
        Product product = null;
        TIFFImageMetadata imageMetadata = (TIFFImageMetadata)this.imageReader.getImageMetadata(0);
        TiffFileInfo tiffInfo = new TiffFileInfo((TIFFDirectory)imageMetadata.getRootIFD());
        TIFFField field = tiffInfo.getField(65000);
        if (field != null && field.getType() == 2 && (s = field.getAsString(0).trim()).contains("<Dimap_Document")) {
            try (InputStream is = null;){
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                is = new ByteArrayInputStream(s.getBytes());
                Document document = new DOMBuilder().build(builder.parse(is));
                product = DimapProductHelpers.createProduct((Document)document);
                GeoTiffProductReader.removeGeoCodingAndTiePointGrids(product);
                this.initBandsMap(product);
            }
        }
        if (product == null) {
            String productName = inputFile != null ? FileUtils.getFilenameWithoutExtension((File)inputFile) : "geotiff";
            String productType = this.getReaderPlugIn().getFormatNames()[0];
            int width = this.imageReader.getWidth(0);
            int height = this.imageReader.getHeight(0);
            product = new Product(productName, productType, width, height, (ProductReader)this);
            this.addBandsToProduct(tiffInfo, product);
        }
        if (tiffInfo.isGeotiff()) {
            GeoTiffProductReader.applyGeoCoding(tiffInfo, imageMetadata, product);
        }
        TiffTagToMetadataConverter.addTiffTagsToMetadata(imageMetadata, tiffInfo, product.getMetadataRoot());
        if (inputFile != null) {
            this.initMetadata(product, inputFile);
            product.setFileLocation(inputFile);
        }
        this.setPreferredTiling(product);
        return product;
    }

    protected void initMetadata(Product product, File inputFile) throws IOException {
    }

    private void initBandsMap(Product product) {
        Band[] bands = product.getBands();
        this.bandMap = new HashMap<Band, Integer>(bands.length);
        for (Band band : bands) {
            if (band instanceof VirtualBand || band instanceof FilterBand) continue;
            this.bandMap.put(band, this.bandMap.size());
        }
    }

    private static void removeGeoCodingAndTiePointGrids(Product product) {
        TiePointGrid[] pointGrids;
        product.setGeoCoding(null);
        for (TiePointGrid pointGrid : pointGrids = product.getTiePointGrids()) {
            product.removeTiePointGrid(pointGrid);
        }
    }

    private void addBandsToProduct(TiffFileInfo tiffInfo, Product product) throws IOException {
        ImageReadParam readParam = this.imageReader.getDefaultReadParam();
        TIFFRenderedImage baseImage = (TIFFRenderedImage)this.imageReader.readAsRenderedImage(0, readParam);
        SampleModel sampleModel = baseImage.getSampleModel();
        int numBands = sampleModel.getNumBands();
        int productDataType = GeoTiffProductReader.getProductDataType(sampleModel.getDataType());
        this.bandMap = new HashMap<Band, Integer>(numBands);
        for (int i = 0; i < numBands; ++i) {
            String bandName = String.format("band_%d", i + 1);
            Band band = product.addBand(bandName, productDataType);
            band.setUnit("amplitude");
            if (tiffInfo.containsField(320) && baseImage.getColorModel() instanceof IndexColorModel) {
                band.setImageInfo(GeoTiffProductReader.createIndexedImageInfo(product, baseImage, band));
            }
            this.bandMap.put(band, i);
        }
    }

    public static int getProductDataType(int dataBufferType) {
        switch (dataBufferType) {
            case 0: {
                return 12;
            }
            case 2: {
                return 12;
            }
            case 1: {
                return 12;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
        }
        throw new IllegalArgumentException("dataBufferType");
    }

    private void setPreferredTiling(Product product) throws IOException {
        Dimension dimension = this.isBadTiling() ? JAIUtils.computePreferredTileSize((int)this.imageReader.getWidth(0), (int)this.imageReader.getHeight(0), (int)1) : new Dimension(this.imageReader.getTileWidth(0), this.imageReader.getTileHeight(0));
        product.setPreferredTileSize(dimension);
    }

    private boolean isBadTiling() throws IOException {
        int imageHeight = this.imageReader.getHeight(0);
        int tileHeight = this.imageReader.getTileHeight(0);
        int imageWidth = this.imageReader.getWidth(0);
        int tileWidth = this.imageReader.getTileWidth(0);
        return tileWidth <= 1 || tileHeight <= 1 || imageWidth == tileWidth || imageHeight == tileHeight;
    }

    private static ImageInfo createIndexedImageInfo(Product product, TIFFRenderedImage baseImage, Band band) {
        IndexColorModel colorModel = (IndexColorModel)baseImage.getColorModel();
        IndexCoding indexCoding = new IndexCoding("color_map");
        int colorCount = colorModel.getMapSize();
        ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[colorCount];
        for (int j = 0; j < colorCount; ++j) {
            String name = String.format("I%3d", j);
            indexCoding.addIndex(name, j, "");
            points[j] = new ColorPaletteDef.Point((double)j, new Color(colorModel.getRGB(j)), name);
        }
        product.getIndexCodingGroup().add((ProductNode)indexCoding);
        band.setSampleCoding((SampleCoding)indexCoding);
        return new ImageInfo(new ColorPaletteDef(points, points.length));
    }

    private static void applyGeoCoding(TiffFileInfo info, TIFFImageMetadata metadata, Product product) {
        if (info.containsField(33922)) {
            double[] tiePoints = info.getField(33922).getAsDoubles();
            if (GeoTiffProductReader.canCreateTiePointGeoCoding(tiePoints)) {
                GeoTiffProductReader.applyTiePointGeoCoding(info, tiePoints, product);
            } else if (GeoTiffProductReader.canCreateGcpGeoCoding(tiePoints)) {
                GeoTiffProductReader.applyGcpGeoCoding(info, tiePoints, product);
            }
        }
        if (product.getGeoCoding() == null) {
            try {
                GeoTiffProductReader.applyGeoCodingFromGeoTiff(metadata, product);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void applyGeoCodingFromGeoTiff(TIFFImageMetadata metadata, Product product) throws Exception {
        CoordinateReferenceSystem crs;
        Rectangle imageBounds = new Rectangle(product.getSceneRasterWidth(), product.getSceneRasterHeight());
        GeoTiffIIOMetadataDecoder metadataDecoder = new GeoTiffIIOMetadataDecoder((IIOMetadata)metadata);
        GeoTiffMetadata2CRSAdapter geoTiff2CRSAdapter = new GeoTiffMetadata2CRSAdapter(null);
        MathTransform toModel = GeoTiffMetadata2CRSAdapter.getRasterToModel((GeoTiffIIOMetadataDecoder)metadataDecoder, (boolean)false);
        try {
            crs = geoTiff2CRSAdapter.createCoordinateSystem(metadataDecoder);
        }
        catch (UnsupportedOperationException e) {
            if (toModel == null) {
                throw e;
            }
            crs = DefaultGeographicCRS.WGS84;
        }
        CrsGeoCoding geoCoding = new CrsGeoCoding(crs, imageBounds, (AffineTransform)toModel);
        product.setGeoCoding((GeoCoding)geoCoding);
    }

    private static void applyTiePointGeoCoding(TiffFileInfo info, double[] tiePoints, Product product) {
        TreeSet<Double> xSet = new TreeSet<Double>();
        TreeSet<Double> ySet = new TreeSet<Double>();
        for (int i = 0; i < tiePoints.length; i += 6) {
            xSet.add(tiePoints[i]);
            ySet.add(tiePoints[i + 1]);
        }
        double xMin = (Double)xSet.first();
        double xMax = (Double)xSet.last();
        double xDiff = (xMax - xMin) / (double)(xSet.size() - 1);
        double yMin = (Double)ySet.first();
        double yMax = (Double)ySet.last();
        double yDiff = (yMax - yMin) / (double)(ySet.size() - 1);
        int width = xSet.size();
        int height = ySet.size();
        int idx = 0;
        HashMap<Double, Integer> xIdx = new HashMap<Double, Integer>();
        for (Double val : xSet) {
            xIdx.put(val, idx);
            ++idx;
        }
        idx = 0;
        HashMap<Double, Integer> yIdx = new HashMap<Double, Integer>();
        for (Double val : ySet) {
            yIdx.put(val, idx);
            ++idx;
        }
        float[] lats = new float[width * height];
        float[] lons = new float[width * height];
        for (int i = 0; i < tiePoints.length; i += 6) {
            int idxX = (Integer)xIdx.get(tiePoints[i + 0]);
            int idxY = (Integer)yIdx.get(tiePoints[i + 1]);
            int arrayIdx = idxY * width + idxX;
            lons[arrayIdx] = (float)tiePoints[i + 3];
            lats[arrayIdx] = (float)tiePoints[i + 4];
        }
        String[] names = Utils.findSuitableLatLonNames(product);
        TiePointGrid latGrid = new TiePointGrid(names[0], width, height, (float)xMin, (float)yMin, (float)xDiff, (float)yDiff, lats);
        TiePointGrid lonGrid = new TiePointGrid(names[1], width, height, (float)xMin, (float)yMin, (float)xDiff, (float)yDiff, lons);
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        SortedMap<Integer, GeoKeyEntry> geoKeyEntries = info.getGeoKeyEntries();
        Datum datum = GeoTiffProductReader.getDatum(geoKeyEntries);
        product.setGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid, datum));
    }

    private static boolean canCreateGcpGeoCoding(double[] tiePoints) {
        int numTiePoints = tiePoints.length / 6;
        if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL3.getTermCountP()) {
            return true;
        }
        if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL2.getTermCountP()) {
            return true;
        }
        return numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL1.getTermCountP();
    }

    private static boolean canCreateTiePointGeoCoding(double[] tiePoints) {
        if (tiePoints.length / 6 <= 1) {
            return false;
        }
        for (double tiePoint : tiePoints) {
            if (!Double.isNaN(tiePoint)) continue;
            return false;
        }
        TreeSet<Double> xSet = new TreeSet<Double>();
        TreeSet<Double> ySet = new TreeSet<Double>();
        for (int i = 0; i < tiePoints.length; i += 6) {
            xSet.add(tiePoints[i]);
            ySet.add(tiePoints[i + 1]);
        }
        return GeoTiffProductReader.isEquiDistance(xSet) && GeoTiffProductReader.isEquiDistance(ySet);
    }

    private static boolean isEquiDistance(SortedSet<Double> set) {
        double min = set.first();
        double max = set.last();
        double diff = (max - min) / (double)(set.size() - 1);
        double diff100000 = diff / 100000.0;
        double maxDiff = diff + diff100000;
        double minDiff = diff - diff100000;
        Double[] values = set.toArray(new Double[set.size()]);
        for (int i = 1; i < values.length; ++i) {
            double currentDiff = values[i] - values[i - 1];
            if (!(currentDiff > maxDiff) && !(currentDiff < minDiff)) continue;
            return false;
        }
        return true;
    }

    private static void applyGcpGeoCoding(TiffFileInfo info, double[] tiePoints, Product product) {
        GcpGeoCoding.Method method;
        int numTiePoints = tiePoints.length / 6;
        if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL3.getTermCountP()) {
            method = GcpGeoCoding.Method.POLYNOMIAL3;
        } else if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL2.getTermCountP()) {
            method = GcpGeoCoding.Method.POLYNOMIAL2;
        } else if (numTiePoints >= GcpGeoCoding.Method.POLYNOMIAL1.getTermCountP()) {
            method = GcpGeoCoding.Method.POLYNOMIAL1;
        } else {
            return;
        }
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        GcpDescriptor gcpDescriptor = GcpDescriptor.getInstance();
        PlacemarkGroup gcpGroup = product.getGcpGroup();
        for (int i = 0; i < numTiePoints; ++i) {
            int offset = i * 6;
            float x = (float)tiePoints[offset + 0];
            float y = (float)tiePoints[offset + 1];
            float lon = (float)tiePoints[offset + 3];
            float lat = (float)tiePoints[offset + 4];
            if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(lon) || Double.isNaN(lat)) continue;
            PixelPos pixelPos = new PixelPos(x, y);
            GeoPos geoPos = new GeoPos(lat, lon);
            String name = gcpDescriptor.getRoleName() + "_" + i;
            String label = gcpDescriptor.getRoleLabel() + "_" + i;
            Placemark gcp = Placemark.createPointPlacemark((PlacemarkDescriptor)gcpDescriptor, (String)name, (String)label, (String)"", (PixelPos)pixelPos, (GeoPos)geoPos, (GeoCoding)product.getGeoCoding());
            gcpGroup.add((ProductNode)gcp);
        }
        try {
            Placemark[] gcps = (Placemark[])gcpGroup.toArray((ProductNode[])new Placemark[gcpGroup.getNodeCount()]);
            SortedMap<Integer, GeoKeyEntry> geoKeyEntries = info.getGeoKeyEntries();
            Datum datum = GeoTiffProductReader.getDatum(geoKeyEntries);
            product.setGeoCoding((GeoCoding)new GcpGeoCoding(method, gcps, width, height, datum));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Datum getDatum(Map<Integer, GeoKeyEntry> geoKeyEntries) {
        int value;
        Datum datum = geoKeyEntries.containsKey(2048) ? ((value = geoKeyEntries.get(2048).getIntValue().intValue()) == 4322 ? Datum.WGS_72 : (value == 4326 ? Datum.WGS_84 : Datum.WGS_84)) : Datum.WGS_84;
        return datum;
    }
}

