/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import org.esa.beam.dataio.geotiff.GeoTiffBandWriter;
import org.esa.beam.dataio.geotiff.GeoTiffProductWriterPlugIn;
import org.esa.beam.dataio.geotiff.Utils;
import org.esa.beam.dataio.geotiff.internal.TiffHeader;
import org.esa.beam.framework.dataio.AbstractProductWriter;
import org.esa.beam.framework.dataio.ProductWriterPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.util.io.FileUtils;
import org.esa.nest.dataio.FileImageOutputStreamExtImpl;

public class GeoTiffProductWriter
extends AbstractProductWriter {
    private File outputFile;
    private ImageOutputStream outputStream;
    private GeoTiffBandWriter bandWriter;

    public GeoTiffProductWriter(ProductWriterPlugIn writerPlugIn) {
        super(writerPlugIn);
    }

    protected void writeProductNodesImpl() throws IOException {
        this.outputFile = null;
        this.outputStream = null;
        this.bandWriter = null;
        File file = this.getOutput() instanceof String ? new File((String)this.getOutput()) : (File)this.getOutput();
        this.outputFile = FileUtils.ensureExtension((File)file, (String)GeoTiffProductWriterPlugIn.GEOTIFF_FILE_EXTENSION[0]);
        this.outputFile.getParentFile().mkdirs();
        this.deleteOutput();
        this.ensureNamingConvention();
        this.writeGeoTIFFProduct(FileImageOutputStreamExtImpl.createOutputStream((File)this.outputFile), this.getSourceProduct());
    }

    private void ensureNamingConvention() {
        if (this.outputFile != null) {
            this.getSourceProduct().setName(FileUtils.getFilenameWithoutExtension((File)this.outputFile));
        }
    }

    void writeGeoTIFFProduct(ImageOutputStream stream, Product sourceProduct) throws IOException {
        this.outputStream = stream;
        TiffHeader tiffHeader = new TiffHeader(new Product[]{sourceProduct});
        tiffHeader.write(stream);
        this.bandWriter = new GeoTiffBandWriter(tiffHeader.getIfdAt(0), stream, sourceProduct);
    }

    public synchronized void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        this.bandWriter.writeBandRasterData(sourceBand, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceBuffer, pm);
    }

    public boolean shouldWrite(ProductNode node) {
        return Utils.shouldWriteNode(node);
    }

    public void deleteOutput() {
        if (this.outputFile != null && this.outputFile.isFile()) {
            this.outputFile.delete();
        }
    }

    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public void close() throws IOException {
        if (this.bandWriter != null) {
            this.bandWriter.dispose();
            this.bandWriter = null;
        }
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.close();
            this.outputStream = null;
        }
    }
}

