/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff;

import com.sun.media.jai.codec.TIFFField;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.esa.beam.framework.datamodel.FilterBand;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.util.geotiff.GeoTIFFMetadata;

public class Utils {
    public static final int PRIVATE_BEAM_TIFF_TAG_NUMBER = 65000;

    public static List<TIFFField> createGeoTIFFFields(GeoTIFFMetadata geoTIFFMetadata) {
        double[] modelTransformation;
        int numModelTiePoints;
        double[] modelPixelScale;
        String geoAsciiString;
        double[] geoDoubleParams;
        ArrayList<TIFFField> list = new ArrayList<TIFFField>(6);
        int numGeoKeyEntries = geoTIFFMetadata.getNumGeoKeyEntries();
        if (numGeoKeyEntries > 0) {
            GeoTIFFMetadata.KeyEntry[] keyEntries = geoTIFFMetadata.getGeoKeyEntries();
            char[] values = new char[keyEntries.length * 4];
            for (int i = 0; i < keyEntries.length; ++i) {
                int[] data = keyEntries[i].getData();
                for (int j = 0; j < data.length; ++j) {
                    values[i * 4 + j] = (char)data[j];
                }
            }
            TIFFField geoKeyDirectory = new TIFFField(34735, 3, values.length, (Object)values);
            list.add(geoKeyDirectory);
        }
        if ((geoDoubleParams = geoTIFFMetadata.getGeoDoubleParams()) != null && geoDoubleParams.length > 0) {
            list.add(new TIFFField(34736, 12, geoDoubleParams.length, (Object)geoDoubleParams));
        }
        if ((geoAsciiString = geoTIFFMetadata.getGeoAsciiParams()) != null && geoAsciiString.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(geoAsciiString, "|");
            String[] geoAsciiStrings = new String[tokenizer.countTokens()];
            for (int i = 0; i < geoAsciiStrings.length; ++i) {
                geoAsciiStrings[i] = tokenizer.nextToken().concat("|");
            }
            list.add(new TIFFField(34737, 2, geoAsciiStrings.length, (Object)geoAsciiStrings));
        }
        if (Utils.isValidModelPixelScale(modelPixelScale = geoTIFFMetadata.getModelPixelScale())) {
            list.add(new TIFFField(33550, 12, modelPixelScale.length, (Object)modelPixelScale));
        }
        if ((numModelTiePoints = geoTIFFMetadata.getNumModelTiePoints()) > 0) {
            double[] tiePointValues = new double[numModelTiePoints * 6];
            for (int i = 0; i < numModelTiePoints; ++i) {
                GeoTIFFMetadata.TiePoint tiePoint = geoTIFFMetadata.getModelTiePointAt(i);
                double[] data = tiePoint.getData();
                System.arraycopy(data, 0, tiePointValues, i * data.length, data.length);
            }
            list.add(new TIFFField(33922, 12, tiePointValues.length, (Object)tiePointValues));
        }
        if (Utils.isValidModelTransformation(modelTransformation = geoTIFFMetadata.getModelTransformation())) {
            list.add(new TIFFField(34264, 12, modelTransformation.length, (Object)modelTransformation));
        }
        return list;
    }

    public static boolean isValidModelTransformation(double[] modelTransformation) {
        double[] defaultValues = new double[16];
        return Utils.isValidData(modelTransformation, defaultValues);
    }

    public static boolean isValidModelPixelScale(double[] modelTransformation) {
        double[] defaultValues = new double[]{1.0, 1.0, 0.0};
        return Utils.isValidData(modelTransformation, defaultValues);
    }

    private static boolean isValidData(double[] modelTransformation, double[] defaultValues) {
        if (modelTransformation != null && modelTransformation.length == defaultValues.length) {
            for (int i = 0; i < modelTransformation.length; ++i) {
                double v = modelTransformation[i];
                double dv = defaultValues[i];
                if (v == dv) continue;
                return true;
            }
        }
        return false;
    }

    static String[] findSuitableLatLonNames(Product product) {
        String latName;
        String[] latNames = new String[]{"latitude", "latitude_tpg", "lat", "lat_tpg"};
        String[] lonNames = new String[]{"longitude", "longitude_tpg", "lon", "lon_tpg"};
        String[] names = new String[2];
        for (int i = 0; i < latNames.length; ++i) {
            latName = latNames[i];
            String lonName = lonNames[i];
            if (product.containsRasterDataNode(latName) || product.containsRasterDataNode(lonName)) continue;
            names[0] = latName;
            names[1] = lonName;
            return names;
        }
        String lonName = lonNames[0] + "_";
        latName = latNames[0] + "_";
        int index = 1;
        while (product.containsRasterDataNode(latName + index) || product.containsRasterDataNode(lonName + index)) {
            ++index;
        }
        return new String[]{latName + index, lonName + index};
    }

    public static boolean shouldWriteNode(ProductNode node) {
        if (node instanceof VirtualBand) {
            return false;
        }
        return !(node instanceof FilterBand);
    }
}

