/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff.internal;

import org.esa.beam.dataio.geotiff.internal.GeoTiffAscii;
import org.esa.beam.dataio.geotiff.internal.TiffAscii;
import org.esa.beam.dataio.geotiff.internal.TiffDouble;
import org.esa.beam.dataio.geotiff.internal.TiffLong;
import org.esa.beam.dataio.geotiff.internal.TiffRational;
import org.esa.beam.dataio.geotiff.internal.TiffShort;
import org.esa.beam.dataio.geotiff.internal.TiffValue;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.util.Guardian;

class TiffType {
    public static final byte BYTE_TYPE = 1;
    public static final TiffShort BYTE = new TiffShort(1);
    public static final byte ASCII_TYPE = 2;
    public static final TiffShort ASCII = new TiffShort(2);
    public static final byte SHORT_TYPE = 3;
    public static final TiffShort SHORT = new TiffShort(3);
    public static final byte LONG_TYPE = 4;
    public static final TiffShort LONG = new TiffShort(4);
    public static final byte RATIONAL_TYPE = 5;
    public static final TiffShort RATIONAL = new TiffShort(5);
    public static final byte SBYTE_TYPE = 6;
    public static final TiffShort SBYTE = new TiffShort(6);
    public static final byte UNDEFINED_TYPE = 7;
    public static final TiffShort UNDEFINED = new TiffShort(7);
    public static final byte SSHORT_TYPE = 8;
    public static final TiffShort SSHORT = new TiffShort(8);
    public static final byte SLONG_TYPE = 9;
    public static final TiffShort SLONG = new TiffShort(9);
    public static final byte SRATIONAL_TYPE = 10;
    public static final TiffShort SRATIONAL = new TiffShort(10);
    public static final byte FLOAT_TYPE = 11;
    public static final TiffShort FLOAT = new TiffShort(11);
    public static final byte DOUBLE_TYPE = 12;
    public static final TiffShort DOUBLE = new TiffShort(12);

    TiffType() {
    }

    public static short getBytesForType(TiffShort type) {
        switch (type.getValue()) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                return 1;
            }
            case 3: 
            case 8: {
                return 2;
            }
            case 4: 
            case 9: 
            case 11: {
                return 4;
            }
            case 5: 
            case 10: 
            case 12: {
                return 8;
            }
        }
        throw new IllegalArgumentException("illegal tiff data type");
    }

    public static TiffShort getType(TiffValue[] values) {
        Guardian.assertNotNull((String)"values", (Object)values);
        Guardian.assertGreaterThan((String)"values.length", (long)values.length, (long)0L);
        TiffValue value = values[0];
        Guardian.assertNotNull((String)"value", (Object)value);
        if (value instanceof TiffShort) {
            TiffType.ensureElementsEqualValueType(values, TiffShort.class);
            return SHORT;
        }
        if (value instanceof TiffLong) {
            TiffType.ensureElementsEqualValueType(values, TiffLong.class);
            return LONG;
        }
        if (value instanceof TiffRational) {
            TiffType.ensureElementsEqualValueType(values, TiffRational.class);
            return RATIONAL;
        }
        if (value instanceof GeoTiffAscii) {
            TiffType.ensureElementsEqualValueType(values, GeoTiffAscii.class);
            return ASCII;
        }
        if (value instanceof TiffAscii) {
            TiffType.ensureElementsEqualValueType(values, TiffAscii.class);
            return ASCII;
        }
        if (value instanceof TiffDouble) {
            TiffType.ensureElementsEqualValueType(values, TiffDouble.class);
            return DOUBLE;
        }
        throw new IllegalArgumentException("the given type [" + values.getClass() + "] is not supported");
    }

    private static void ensureElementsEqualValueType(TiffValue[] values, Class compareClass) {
        for (int i = 0; i < values.length; ++i) {
            if (compareClass.isInstance(values[i])) continue;
            throw new IllegalArgumentException("all elements of the given values array must be instances of the same type [" + compareClass.getName() + "]");
        }
    }

    public static TiffShort getTiffTypeFrom(Band band) {
        int dataType = band.getGeophysicalDataType();
        switch (dataType) {
            case 20: {
                return BYTE;
            }
            case 21: {
                return SHORT;
            }
            case 22: {
                return LONG;
            }
            case 10: {
                return SBYTE;
            }
            case 11: {
                return SSHORT;
            }
            case 12: {
                return SLONG;
            }
            case 30: {
                return FLOAT;
            }
            case 31: {
                return DOUBLE;
            }
        }
        throw new IllegalArgumentException("the given band has an unsupported geophysical data type");
    }
}

