/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.actions;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.ConfigurationElement;
import javax.swing.ImageIcon;
import org.esa.beam.framework.ui.ModelessDialog;
import org.esa.beam.visat.actions.DefaultOperatorAction;
import org.esa.nest.dat.dialogs.NestSingleTargetProductDialog;
import org.esa.nest.util.ResourceUtils;

public class OperatorAction
extends DefaultOperatorAction {
    private String iconName;

    public void configure(ConfigurationElement config) throws CoreException {
        super.configure(config);
        this.iconName = this.getConfigString(config, "icon");
    }

    protected ModelessDialog createOperatorDialog() {
        NestSingleTargetProductDialog dialog = new NestSingleTargetProductDialog(this.operatorName, this.getAppContext(), this.dialogTitle, this.getHelpId());
        if (this.targetProductNameSuffix != null) {
            dialog.setTargetProductNameSuffix(this.targetProductNameSuffix);
        }
        this.addIcon((ModelessDialog)dialog);
        return dialog;
    }

    protected void addIcon(ModelessDialog dlg) {
        if (this.iconName == null) {
            OperatorAction.setIcon(dlg, ResourceUtils.nestIcon);
        } else if (this.iconName.equals("esaIcon")) {
            OperatorAction.setIcon(dlg, ResourceUtils.esaPlanetIcon);
        } else if (this.iconName.equals("rstbIcon")) {
            OperatorAction.setIcon(dlg, ResourceUtils.rstbIcon);
        } else if (this.iconName.equals("geoAusIcon")) {
            OperatorAction.setIcon(dlg, ResourceUtils.geoAusIcon);
        } else {
            ImageIcon icon = ResourceUtils.LoadIcon((String)this.iconName);
            if (icon != null) {
                OperatorAction.setIcon(dlg, icon);
            }
        }
    }

    private static void setIcon(ModelessDialog dlg, ImageIcon ico) {
        if (ico == null) {
            return;
        }
        dlg.getJDialog().setIconImage(ico.getImage());
    }
}

