/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.dialogs;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.graph.GraphException;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.ModelessDialog;
import org.esa.beam.util.io.FileChooserFactory;
import org.esa.beam.util.io.FileUtils;
import org.esa.nest.dat.dialogs.ProductSetPanel;
import org.esa.nest.dat.plugins.graphbuilder.GraphExecuter;
import org.esa.nest.dat.plugins.graphbuilder.GraphNode;
import org.esa.nest.dat.plugins.graphbuilder.ProgressBarProgressMonitor;
import org.esa.nest.db.ProductEntry;
import org.esa.nest.util.MemUtils;
import org.esa.nest.util.ProcessTimeMonitor;
import org.esa.nest.util.ResourceUtils;
import org.esa.nest.util.Settings;

public class BatchGraphDialog
extends ModelessDialog {
    private final AppContext appContext;
    private final ProductSetPanel productSetPanel;
    private final List<GraphExecuter> graphExecutorList = new ArrayList<GraphExecuter>(10);
    private static final File defaultGraphPath = ResourceUtils.getGraphFolder((String)"");
    private final JTabbedPane tabbedPane;
    private final JLabel statusLabel;
    private final JLabel bottomStatusLabel;
    private final JPanel progressPanel;
    private final JProgressBar progressBar;
    private final JLabel progressMsgLabel;
    private ProgressBarProgressMonitor progBarMonitor = null;
    private Map<File, File[]> slaveFileMap = null;
    private final List<BatchProcessListener> listenerList = new ArrayList<BatchProcessListener>(1);
    private final boolean closeOnDone;
    private boolean isProcessing = false;
    private File graphFile;

    public BatchGraphDialog(AppContext theAppContext, String title, String helpID, boolean closeOnDone) {
        super(theAppContext.getApplicationWindow(), title, 154, helpID);
        this.appContext = theAppContext;
        this.closeOnDone = closeOnDone;
        JPanel mainPanel = new JPanel(new BorderLayout(4, 4));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BatchGraphDialog.this.ValidateAllNodes();
            }
        });
        mainPanel.add((Component)this.tabbedPane, "Center");
        this.statusLabel = new JLabel("");
        this.statusLabel.setForeground(new Color(255, 0, 0));
        mainPanel.add((Component)this.statusLabel, "North");
        this.bottomStatusLabel = new JLabel("");
        this.getButtonPanel().add((Component)this.bottomStatusLabel, 0);
        this.progressBar = new JProgressBar();
        this.progressBar.setName(((Object)((Object)this)).getClass().getName() + "progressBar");
        this.progressBar.setStringPainted(true);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout(2, 2));
        this.progressPanel.add((Component)this.progressBar, "Center");
        this.progressMsgLabel = new JLabel();
        this.progressPanel.add((Component)this.progressMsgLabel, "North");
        JButton progressCancelBtn = new JButton("Cancel");
        progressCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchGraphDialog.this.CancelProcessing();
            }
        });
        this.progressPanel.add((Component)progressCancelBtn, "East");
        this.progressPanel.setVisible(false);
        mainPanel.add((Component)this.progressPanel, "South");
        this.productSetPanel = new ProductSetPanel(this.appContext);
        this.tabbedPane.add("I/O Parameters", this.productSetPanel);
        this.getButton(8).setText("Run");
        this.getButton(2).setText("Load Graph");
        this.graphFile = new File(defaultGraphPath + File.separator + "internal", "importGraph.xml");
        this.LoadGraphFile(this.graphFile);
        this.setContent(mainPanel);
        super.getJDialog().setMinimumSize(new Dimension(400, 300));
    }

    public int show() {
        return super.show();
    }

    public void hide() {
        if (this.progBarMonitor != null) {
            this.progBarMonitor.setCanceled(true);
        }
        this.notifyMSG(BatchProcessListener.BatchMSG.CLOSE);
        super.hide();
    }

    public void onApply() {
        if (this.isProcessing) {
            return;
        }
        this.productSetPanel.onApply();
        try {
            this.DoProcessing();
        }
        catch (Exception e) {
            this.statusLabel.setText(e.getMessage());
            this.bottomStatusLabel.setText("");
        }
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public void addListener(BatchProcessListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeListener(BatchProcessListener listener) {
        this.listenerList.remove(listener);
    }

    private void notifyMSG(BatchProcessListener.BatchMSG msg, String text) {
        for (BatchProcessListener listener : this.listenerList) {
            listener.notifyMSG(msg, text);
        }
    }

    private void notifyMSG(BatchProcessListener.BatchMSG msg) {
        for (BatchProcessListener listener : this.listenerList) {
            listener.notifyMSG(msg, this.productSetPanel.getFileList(), this.getAllBatchProcessedTargetProducts());
        }
    }

    protected void onYes() {
        if (this.isProcessing) {
            return;
        }
        File file = BatchGraphDialog.getFilePath(this.getContent(), "Graph File");
        if (file != null) {
            this.LoadGraphFile(file);
        }
    }

    public void setInputFiles(File[] productFileList) {
        this.productSetPanel.setProductFileList(productFileList);
    }

    public void setInputFiles(ProductEntry[] productEntryList) {
        this.productSetPanel.setProductEntryList(productEntryList);
    }

    public void setTargetFolder(File path) {
        this.productSetPanel.setTargetFolder(path);
    }

    public void LoadGraphFile(File file) {
        this.graphFile = file;
        this.initGraphs();
        this.addGraphTabs("", true);
    }

    private static File getFilePath(Component component, String title) {
        File graphPath = new File(Settings.getPref((String)"batch.last_graph_path", (String)defaultGraphPath.getAbsolutePath()));
        JFileChooser chooser = FileChooserFactory.getInstance().createFileChooser(graphPath);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(title);
        if (chooser.showDialog(component, "ok") == 0) {
            File file = chooser.getSelectedFile();
            Settings.setPref((String)"batch.last_graph_path", (String)file.getAbsolutePath());
            return file;
        }
        return null;
    }

    protected void onClose() {
        this.CancelProcessing();
        super.onClose();
    }

    void initGraphs() {
        try {
            this.deleteGraphs();
            this.createGraphs();
        }
        catch (Exception e) {
            this.statusLabel.setText(e.getMessage());
            this.bottomStatusLabel.setText("");
        }
    }

    private void DoProcessing() {
        if (this.ValidateAllNodes()) {
            MemUtils.freeAllMemory();
            this.progressBar.setValue(0);
            this.progBarMonitor = new ProgressBarProgressMonitor(this.progressBar, this.progressMsgLabel, this.progressPanel);
            ProcessThread processThread = new ProcessThread(this.progBarMonitor);
            processThread.execute();
        } else if (this.statusLabel.getText() != null && !this.statusLabel.getText().isEmpty()) {
            this.showErrorDialog(this.statusLabel.getText());
        }
    }

    private void CancelProcessing() {
        if (this.progBarMonitor != null) {
            this.progBarMonitor.setCanceled(true);
        }
    }

    private void deleteGraphs() {
        for (GraphExecuter gex : this.graphExecutorList) {
            gex.ClearGraph();
        }
        this.graphExecutorList.clear();
    }

    void LoadGraph(GraphExecuter executer, File file, boolean addUI) {
        try {
            executer.loadGraph(file, addUI);
        }
        catch (GraphException e) {
            this.showErrorDialog(e.getMessage());
        }
    }

    private boolean ValidateAllNodes() {
        boolean result;
        if (this.isProcessing) {
            return false;
        }
        if (this.productSetPanel == null) {
            return false;
        }
        if (this.graphExecutorList.isEmpty()) {
            return false;
        }
        this.statusLabel.setText("");
        try {
            this.cloneGraphs();
            this.assignParameters();
            result = this.graphExecutorList.get(0).InitGraph();
        }
        catch (Exception e) {
            this.statusLabel.setText(e.getMessage());
            this.bottomStatusLabel.setText("");
            result = false;
        }
        return result;
    }

    private void openTargetProducts(ArrayList<File> fileList) {
        if (!fileList.isEmpty()) {
            for (File file : fileList) {
                try {
                    Product product = ProductIO.readProduct((File)file);
                    if (product == null) continue;
                    this.appContext.getProductManager().addProduct(product);
                }
                catch (IOException e) {
                    this.showErrorDialog(e.getMessage());
                }
            }
        }
    }

    protected ProductSetPanel getProductSetPanel() {
        return this.productSetPanel;
    }

    public void setTargetProductNameSuffix(String suffix) {
        this.productSetPanel.setTargetProductNameSuffix(suffix);
    }

    void createGraphs() throws GraphException {
        try {
            GraphExecuter graphEx = new GraphExecuter();
            this.LoadGraph(graphEx, this.graphFile, true);
            this.graphExecutorList.add(graphEx);
        }
        catch (Exception e) {
            throw new GraphException(e.getMessage());
        }
    }

    private void addGraphTabs(String title, boolean addUI) {
        if (this.graphExecutorList.isEmpty()) {
            return;
        }
        this.tabbedPane.setSelectedIndex(0);
        while (this.tabbedPane.getTabCount() > 1) {
            this.tabbedPane.remove(this.tabbedPane.getTabCount() - 1);
        }
        GraphExecuter graphEx = this.graphExecutorList.get(0);
        for (GraphNode n : graphEx.GetGraphNodes()) {
            if (n.GetOperatorUI() == null) continue;
            if (n.getNode().getOperatorName().equals("Read") || n.getNode().getOperatorName().equals("Write") || n.getNode().getOperatorName().equals("ProductSet-Reader")) {
                n.setOperatorUI(null);
                continue;
            }
            if (!addUI) continue;
            String tabTitle = title;
            if (tabTitle.isEmpty()) {
                tabTitle = n.getOperatorName();
            }
            this.tabbedPane.addTab(tabTitle, null, n.GetOperatorUI().CreateOpTab(n.getOperatorName(), n.getParameterMap(), this.appContext), n.getID() + " Operator");
        }
    }

    public void setSlaveFileMap(Map<File, File[]> fileMap) {
        this.slaveFileMap = fileMap;
    }

    void assignParameters() {
        File[] fileList = this.productSetPanel.getFileList();
        int graphIndex = 0;
        for (File f : fileList) {
            File[] slaveFiles;
            Object o = this.productSetPanel.getValueAt(graphIndex, 0);
            String name = o instanceof String ? (String)o : FileUtils.getFilenameWithoutExtension((File)f);
            File targetFile = new File(this.productSetPanel.getTargetFolder(), name);
            String targetFormat = this.productSetPanel.getTargetFormat();
            BatchGraphDialog.setIO(this.graphExecutorList.get(graphIndex), "Read", f, "Write", targetFile, targetFormat);
            if (this.slaveFileMap != null && (slaveFiles = this.slaveFileMap.get(f)) != null) {
                BatchGraphDialog.setSlaveIO(this.graphExecutorList.get(graphIndex), "ProductSet-Reader", f, slaveFiles);
            }
            ++graphIndex;
        }
    }

    private static void setIO(GraphExecuter graphEx, String readID, File readPath, String writeID, File writePath, String format) {
        GraphNode writeNode;
        GraphNode readNode = graphEx.findGraphNodeByOperator(readID);
        if (readNode != null) {
            graphEx.setOperatorParam(readNode.getID(), "file", readPath.getAbsolutePath());
        }
        if (writeID != null && (writeNode = graphEx.findGraphNodeByOperator(writeID)) != null) {
            if (format != null) {
                graphEx.setOperatorParam(writeNode.getID(), "formatName", format);
            }
            graphEx.setOperatorParam(writeNode.getID(), "file", writePath.getAbsolutePath());
        }
    }

    private static void setSlaveIO(GraphExecuter graphEx, String productSetID, File masterFile, File[] slaveFiles) {
        GraphNode productSetNode = graphEx.findGraphNodeByOperator(productSetID);
        if (productSetNode != null) {
            StringBuilder str = new StringBuilder(masterFile.getAbsolutePath());
            for (File slaveFile : slaveFiles) {
                str.append(',');
                str.append(slaveFile.getAbsolutePath());
            }
            graphEx.setOperatorParam(productSetNode.getID(), "fileList", str.toString());
        }
    }

    void cloneGraphs() throws Exception {
        GraphExecuter graphEx = this.graphExecutorList.get(0);
        for (int graphIndex = 1; graphIndex < this.graphExecutorList.size(); ++graphIndex) {
            GraphExecuter cloneGraphEx = this.graphExecutorList.get(graphIndex);
            cloneGraphEx.ClearGraph();
        }
        this.graphExecutorList.clear();
        this.graphExecutorList.add(graphEx);
        File[] fileList = this.productSetPanel.getFileList();
        for (int graphIndex = 1; graphIndex < fileList.length; ++graphIndex) {
            GraphExecuter cloneGraphEx = new GraphExecuter();
            this.LoadGraph(cloneGraphEx, this.graphFile, false);
            this.graphExecutorList.add(cloneGraphEx);
            List<GraphNode> cloneGraphNodes = cloneGraphEx.GetGraphNodes();
            for (GraphNode cloneNode : cloneGraphNodes) {
                GraphNode node = graphEx.findGraphNode(cloneNode.getID());
                if (node == null) continue;
                cloneNode.setOperatorUI(node.GetOperatorUI());
            }
        }
    }

    public File[] getAllBatchProcessedTargetProducts() {
        ArrayList<File> targetFileList = new ArrayList<File>();
        for (GraphExecuter graphEx : this.graphExecutorList) {
            targetFileList.addAll(graphEx.getProductsToOpenInDAT());
        }
        return targetFileList.toArray(new File[targetFileList.size()]);
    }

    void cleanUpTempFiles() {
    }

    public static interface BatchProcessListener {
        public void notifyMSG(BatchMSG var1, File[] var2, File[] var3);

        public void notifyMSG(BatchMSG var1, String var2);

        public static enum BatchMSG {
            DONE,
            UPDATE,
            CLOSE;

        }
    }

    private class ProcessThread
    extends SwingWorker<Boolean, Object> {
        private final ProgressMonitor pm;
        private ProcessTimeMonitor timeMonitor = new ProcessTimeMonitor();
        private boolean errorOccured = false;
        final List<String> errMsgs = new ArrayList<String>();

        public ProcessThread(ProgressMonitor pm) {
            this.pm = pm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Boolean doInBackground() throws Exception {
            this.pm.beginTask("Processing Graph...", 100 * BatchGraphDialog.this.graphExecutorList.size());
            try {
                this.timeMonitor.start();
                BatchGraphDialog.this.isProcessing = true;
                File[] fileList = BatchGraphDialog.this.productSetPanel.getFileList();
                int graphIndex = 0;
                for (GraphExecuter graphEx : BatchGraphDialog.this.graphExecutorList) {
                    if (this.pm.isCanceled()) break;
                    try {
                        String nOfm = String.valueOf(graphIndex + 1) + " of " + fileList.length + ' ';
                        String statusText = "Processing " + nOfm + fileList[graphIndex].getName();
                        BatchGraphDialog.this.statusLabel.setText(statusText);
                        BatchGraphDialog.this.notifyMSG(BatchProcessListener.BatchMSG.UPDATE, statusText);
                        MemUtils.freeAllMemory();
                        graphEx.InitGraph();
                        graphEx.executeGraph((ProgressMonitor)new SubProgressMonitor(this.pm, 100));
                        graphEx.disposeGraphContext();
                    }
                    catch (Exception e) {
                        System.out.print(e.getMessage());
                        String filename = fileList[graphIndex].getName();
                        this.errMsgs.add(filename + " -> " + e.getMessage());
                    }
                    graphEx = null;
                    long duration = this.timeMonitor.getCurrentDuration();
                    double timePerGraph = (double)duration / (double)(++graphIndex);
                    long timeLeft = (long)(timePerGraph * (double)(fileList.length - graphIndex));
                    if (timeLeft <= 0L) continue;
                    String remainingStr = "Estimated " + ProcessTimeMonitor.formatDuration((long)timeLeft) + " remaining";
                    if (!this.errMsgs.isEmpty()) {
                        remainingStr = remainingStr + " (Errors occurred)";
                    }
                    BatchGraphDialog.this.bottomStatusLabel.setText(remainingStr);
                }
                MemUtils.freeAllMemory();
            }
            catch (Exception e) {
                System.out.print(e.getMessage());
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    BatchGraphDialog.this.statusLabel.setText(e.getMessage());
                } else {
                    BatchGraphDialog.this.statusLabel.setText(e.toString());
                }
                this.errorOccured = true;
            }
            finally {
                BatchGraphDialog.this.isProcessing = false;
                this.pm.done();
            }
            return true;
        }

        @Override
        public void done() {
            if (!this.errorOccured) {
                long duration = this.timeMonitor.stop();
                BatchGraphDialog.this.statusLabel.setText("Processing completed in " + ProcessTimeMonitor.formatDuration((long)duration));
                BatchGraphDialog.this.bottomStatusLabel.setText("");
            }
            if (!this.errMsgs.isEmpty()) {
                StringBuilder msg = new StringBuilder("The following errors occurred:\n");
                for (String errStr : this.errMsgs) {
                    msg.append(errStr);
                    msg.append('\n');
                }
                BatchGraphDialog.this.showErrorDialog(msg.toString());
            }
            BatchGraphDialog.this.cleanUpTempFiles();
            BatchGraphDialog.this.notifyMSG(BatchProcessListener.BatchMSG.DONE);
            if (BatchGraphDialog.this.closeOnDone) {
                BatchGraphDialog.this.close();
            }
        }
    }
}

