/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.dialogs;

import java.io.File;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.nest.dat.dialogs.BaseFileModel;
import org.esa.nest.dat.dialogs.FileTableModel;
import org.esa.nest.datamodel.AbstractMetadata;
import org.esa.nest.db.ProductEntry;
import org.esa.nest.gpf.OperatorUtils;

public class FileModel
extends BaseFileModel
implements FileTableModel {
    @Override
    protected void setColumnData() {
        this.titles = new String[]{"File Name", "Type", "Acquisition", "Track", "Orbit"};
        this.types = new Class[]{String.class, String.class, String.class, String.class, String.class};
        this.widths = new int[]{75, 10, 20, 3, 5};
    }

    @Override
    protected BaseFileModel.TableData createFileStats(File file) {
        return new FileStats(file);
    }

    @Override
    protected BaseFileModel.TableData createFileStats(ProductEntry entry) {
        return new FileStats(entry);
    }

    private class FileStats
    extends BaseFileModel.TableData {
        FileStats(File file) {
            super((BaseFileModel)FileModel.this, file);
        }

        FileStats(ProductEntry entry) {
            super((BaseFileModel)FileModel.this, entry);
        }

        @Override
        protected void updateData(File file) throws IOException {
            this.data[0] = file.getName();
            Product product = ProductIO.readProduct((File)file);
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
            this.data[0] = product.getName();
            this.data[1] = product.getProductType();
            this.data[2] = OperatorUtils.getAcquisitionDate((MetadataElement)absRoot);
            this.data[3] = String.valueOf(absRoot.getAttributeInt("REL_ORBIT", 0));
            this.data[4] = String.valueOf(absRoot.getAttributeInt("ABS_ORBIT", 0));
        }

        @Override
        protected void updateData(ProductEntry entry) {
            this.data[0] = entry.getName();
            this.data[1] = entry.getProductType();
            this.data[2] = entry.getFirstLineTime().format();
            MetadataElement meta = entry.getMetadata();
            if (meta != null) {
                this.data[3] = String.valueOf(meta.getAttributeInt("REL_ORBIT", 0));
                this.data[4] = String.valueOf(meta.getAttributeInt("ABS_ORBIT", 0));
            }
        }
    }
}

