/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.dialogs;

import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.esa.nest.dat.dialogs.FileModel;
import org.esa.nest.dat.dialogs.FileTableModel;
import org.esa.nest.db.ProductEntry;
import org.esa.nest.util.ClipboardUtils;
import org.esa.nest.util.ProductFunctions;

public class FileTable
extends JTable {
    private final FileTableModel fileModel;

    public FileTable() {
        this(new FileModel());
    }

    public FileTable(FileTableModel fileModel) {
        if (fileModel == null) {
            fileModel = new FileModel();
        }
        this.fileModel = fileModel;
        this.setModel(fileModel);
        int width = 500;
        int height = 100;
        this.setPreferredScrollableViewportSize(new Dimension(500, 100));
        fileModel.setColumnWidths(this.getColumnModel());
        this.setColumnSelectionAllowed(true);
        this.setDropMode(DropMode.ON);
        this.setDragEnabled(true);
        this.setComponentPopupMenu(this.createTablePopup());
        this.setTransferHandler(new ProductSetTransferHandler(fileModel));
    }

    public void setFiles(File[] fileList) {
        if (fileList != null) {
            this.fileModel.clear();
            for (File file : fileList) {
                this.fileModel.addFile(file);
            }
        }
    }

    public void setFiles(String[] fileList) {
        if (fileList != null) {
            this.fileModel.clear();
            for (String str : fileList) {
                this.fileModel.addFile(new File(str));
            }
        }
    }

    public void setProductEntries(ProductEntry[] productEntryList) {
        if (productEntryList != null) {
            this.fileModel.clear();
            for (ProductEntry entry : productEntryList) {
                this.fileModel.addFile(entry);
            }
        }
    }

    public File[] getFileList() {
        return this.fileModel.getFileList();
    }

    @Override
    public FileTableModel getModel() {
        return this.fileModel;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem pastelItem = new JMenuItem("Paste");
        pastelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTable.this.paste();
            }
        });
        popup.add(pastelItem);
        return popup;
    }

    private void paste() {
        File[] fileList = ClipboardUtils.getClipboardFileList();
        if (fileList != null) {
            this.setFiles(fileList);
        }
    }

    public static class ProductSetTransferHandler
    extends TransferHandler {
        private final FileTableModel fileModel;

        public ProductSetTransferHandler(FileTableModel model) {
            this.fileModel = model;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            String[] values;
            String data;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                data = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                return false;
            }
            for (String value : values = data.split("\n")) {
                File file = new File(value);
                if (!file.exists() || !ProductFunctions.isValidProduct((File)file)) continue;
                this.fileModel.addFile(file);
            }
            return true;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JTable table = (JTable)c;
            int[] rows = table.getSelectedRows();
            StringBuilder listStr = new StringBuilder(256);
            for (int row : rows) {
                File file = this.fileModel.getFileAt(row);
                listStr.append(file.getAbsolutePath());
                listStr.append('\n');
            }
            if (rows.length != 0) {
                return new StringSelection(listStr.toString());
            }
            return null;
        }
    }
}

