/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.dialogs;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.media.jai.JAI;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.GPF;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.OperatorUI;
import org.esa.beam.framework.gpf.experimental.Output;
import org.esa.beam.framework.gpf.internal.OperatorExecutor;
import org.esa.beam.framework.gpf.internal.OperatorProductReader;
import org.esa.beam.framework.gpf.ui.DefaultSingleTargetProductDialog;
import org.esa.beam.framework.gpf.ui.SourceProductSelector;
import org.esa.beam.framework.gpf.ui.TargetProductSelectorModel;
import org.esa.beam.framework.gpf.ui.UIValidation;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.gpf.operators.standard.WriteOp;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.gpf.ProgressMonitorList;
import org.esa.nest.util.ResourceUtils;

public class NestSingleTargetProductDialog
extends DefaultSingleTargetProductDialog {
    private final OperatorUI opUI;
    private JLabel statusLabel;

    public NestSingleTargetProductDialog(String operatorName, AppContext appContext, String title, String helpID) {
        super(operatorName, appContext, title, helpID);
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(operatorName);
        if (operatorSpi == null) {
            throw new IllegalArgumentException("operatorName " + operatorName);
        }
        this.opUI = operatorSpi.createOperatorUI();
        this.addParameters(operatorSpi, appContext, helpID);
        this.getJDialog().setMinimumSize(new Dimension(450, 450));
        this.getJDialog().setIconImage(ResourceUtils.esaPlanetIcon.getImage());
        this.statusLabel = new JLabel("");
        this.statusLabel.setForeground(new Color(255, 0, 0));
        this.getJDialog().getContentPane().add((Component)this.statusLabel, "North");
    }

    protected void addParametersPane(OperatorSpi operatorSpi, AppContext appContext, String helpID) {
    }

    private void addParameters(OperatorSpi operatorSpi, AppContext appContext, String helpID) {
        PropertySet propertyContainer = this.parameterSupport.getPopertySet();
        ArrayList sourceProductSelectorList = this.ioParametersPanel.getSourceProductSelectorList();
        ((SourceProductSelector)sourceProductSelectorList.get(0)).addSelectionChangeListener((SelectionChangeListener)new AbstractSelectionChangeListener(){

            public void selectionChanged(SelectionChangeEvent event) {
                Product selectedProduct = (Product)event.getSelection().getSelectedValue();
                if (selectedProduct != null) {
                    TargetProductSelectorModel targetProductSelectorModel = NestSingleTargetProductDialog.this.getTargetProductSelector().getModel();
                    targetProductSelectorModel.setProductName(selectedProduct.getName() + NestSingleTargetProductDialog.this.getTargetProductNameSuffix());
                    NestSingleTargetProductDialog.this.opUI.setSourceProducts(new Product[]{selectedProduct});
                }
            }
        });
        if (propertyContainer.getProperties().length > 0) {
            if (!sourceProductSelectorList.isEmpty()) {
                Property[] properties = propertyContainer.getProperties();
                ArrayList<PropertyDescriptor> rdnTypeProperties = new ArrayList<PropertyDescriptor>(properties.length);
                for (Property property : properties) {
                    PropertyDescriptor parameterDescriptor = property.getDescriptor();
                    if (parameterDescriptor.getAttribute("rasterDataNodeType") == null) continue;
                    rdnTypeProperties.add(parameterDescriptor);
                }
                this.rasterDataNodeTypeProperties = rdnTypeProperties.toArray(new PropertyDescriptor[rdnTypeProperties.size()]);
            }
            JComponent paremetersPanel = this.opUI.CreateOpTab(this.operatorName, this.parameterSupport.getParameterMap(), appContext);
            paremetersPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
            this.form.add("Processing Parameters", new JScrollPane(paremetersPanel));
        }
    }

    protected Product createTargetProduct() throws Exception {
        if (this.validateUI()) {
            this.opUI.updateParameters();
            HashMap sourceProducts = this.ioParametersPanel.createSourceProductsMap();
            return GPF.createProduct((String)this.operatorName, (Map)this.parameterSupport.getParameterMap(), (Map)sourceProducts);
        }
        return null;
    }

    private boolean validateUI() {
        UIValidation validation = this.opUI.validateParameters();
        if (validation.getState() == UIValidation.State.WARNING) {
            String msg = "Warning: " + validation.getMsg() + "\n\nWould you like to continue?";
            return VisatApp.getApp().showQuestionDialog(msg, null) == 0;
        }
        if (validation.getState() == UIValidation.State.ERROR) {
            String msg = "Error: " + validation.getMsg();
            VisatApp.getApp().showErrorDialog(msg);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onApply() {
        if (!this.canApply()) {
            return;
        }
        String productDir = this.targetProductSelector.getModel().getProductDir().getAbsolutePath();
        this.appContext.getPreferences().setPropertyString("app.file.lastSaveDir", productDir);
        Product targetProduct = null;
        try {
            targetProduct = this.createTargetProduct();
            if (targetProduct != null) {
                // empty if block
            }
        }
        catch (Throwable t) {
            this.handleInitialisationError(t);
        }
        if (targetProduct == null) {
            return;
        }
        targetProduct.setName(this.targetProductSelector.getModel().getProductName());
        if (this.targetProductSelector.getModel().isSaveToFileSelected()) {
            targetProduct.setFileLocation(this.targetProductSelector.getModel().getProductFile());
            ProductWriterWorker worker = new ProductWriterWorker(targetProduct);
            worker.execute();
            return;
        }
        if (!this.targetProductSelector.getModel().isOpenInAppSelected()) return;
        this.appContext.getProductManager().addProduct(targetProduct);
        this.showOpenInAppInfo();
    }

    private class ProductWriterWorker
    extends ProgressMonitorSwingWorker<Product, Object> {
        private final Product targetProduct;
        private long saveTime;
        private Date executeStartTime;

        private ProductWriterWorker(Product targetProduct) {
            super((Component)NestSingleTargetProductDialog.this.getJDialog(), "Writing Target Product");
            this.targetProduct = targetProduct;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Product doInBackground(ProgressMonitor pm) throws Exception {
            TargetProductSelectorModel model = NestSingleTargetProductDialog.this.getTargetProductSelector().getModel();
            pm.beginTask("Writing...", model.isOpenInAppSelected() ? 100 : 95);
            ProgressMonitorList.instance().add(pm);
            this.saveTime = 0L;
            Product product = null;
            try {
                OperatorProductReader opReader;
                JAI.getDefaultInstance().getTileCache().flush();
                System.gc();
                this.executeStartTime = Calendar.getInstance().getTime();
                long t0 = System.currentTimeMillis();
                Operator operator = null;
                if (this.targetProduct.getProductReader() instanceof OperatorProductReader && (opReader = (OperatorProductReader)this.targetProduct.getProductReader()).getOperatorContext().getOperator() instanceof Output) {
                    operator = opReader.getOperatorContext().getOperator();
                }
                if (operator == null) {
                    WriteOp writeOp = new WriteOp(this.targetProduct, model.getProductFile(), model.getFormatName());
                    writeOp.setDeleteOutputOnFailure(true);
                    writeOp.setWriteEntireTileRows(true);
                    writeOp.setClearCacheAfterRowWrite(false);
                    operator = writeOp;
                }
                OperatorExecutor executor = OperatorExecutor.create(operator);
                executor.execute(SubProgressMonitor.create((ProgressMonitor)pm, (int)95));
                this.saveTime = System.currentTimeMillis() - t0;
                File targetFile = model.getProductFile();
                if (model.isOpenInAppSelected() && targetFile.exists()) {
                    product = ProductIO.readProduct((File)targetFile);
                    if (product == null) {
                        product = this.targetProduct;
                    }
                    pm.worked(5);
                }
            }
            finally {
                JAI.getDefaultInstance().getTileCache().flush();
                System.gc();
                pm.done();
                ProgressMonitorList.instance().remove(pm);
                if (product != this.targetProduct) {
                    this.targetProduct.dispose();
                }
            }
            return product;
        }

        protected void done() {
            TargetProductSelectorModel model = NestSingleTargetProductDialog.this.getTargetProductSelector().getModel();
            try {
                Date now = Calendar.getInstance().getTime();
                long diff = (now.getTime() - this.executeStartTime.getTime()) / 1000L;
                if (diff > 120L) {
                    float minutes = (float)diff / 60.0f;
                    NestSingleTargetProductDialog.this.statusLabel.setText("Processing completed in " + minutes + " minutes");
                } else {
                    NestSingleTargetProductDialog.this.statusLabel.setText("Processing completed in " + diff + " seconds");
                }
                Product targetProduct = (Product)this.get();
                if (model.isOpenInAppSelected()) {
                    NestSingleTargetProductDialog.this.appContext.getProductManager().addProduct(targetProduct);
                }
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                NestSingleTargetProductDialog.this.handleProcessingError(e.getCause());
            }
            catch (Throwable t) {
                NestSingleTargetProductDialog.this.handleProcessingError(t);
            }
        }
    }
}

