/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.ui.TargetProductSelectorModel;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.io.FileChooserFactory;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.dialogs.FileTable;
import org.esa.nest.dat.dialogs.FileTableModel;
import org.esa.nest.dat.dialogs.TargetFolderSelector;
import org.esa.nest.db.ProductEntry;
import org.esa.nest.util.DialogUtils;
import org.esa.nest.util.ProductFunctions;

public class ProductSetPanel
extends JPanel {
    private final FileTable productSetTable;
    private final TargetFolderSelector targetProductSelector;
    private final AppContext appContext;
    private String targetProductNameSuffix = "";
    private JPanel buttonPanel = null;

    public ProductSetPanel(AppContext theAppContext, String title) {
        this(theAppContext, title, null, false, false);
    }

    public ProductSetPanel(AppContext theAppContext, String title, FileTableModel fileModel) {
        this(theAppContext, title, fileModel, false, false);
    }

    public ProductSetPanel(AppContext theAppContext) {
        this(theAppContext, null, null, true, true);
    }

    public ProductSetPanel(AppContext theAppContext, String title, FileTableModel fileModel, boolean incTrgProduct, boolean incButtonPanel) {
        super(new BorderLayout());
        this.appContext = theAppContext;
        this.setBorderTitle(title);
        this.productSetTable = new FileTable(fileModel);
        JPanel productSetContent = ProductSetPanel.createComponent(this.productSetTable, false);
        if (incButtonPanel) {
            this.buttonPanel = ProductSetPanel.createButtonPanel(this.productSetTable);
            productSetContent.add((Component)this.buttonPanel, "East");
        }
        this.add((Component)productSetContent, "Center");
        if (incTrgProduct) {
            this.targetProductSelector = new TargetFolderSelector();
            String homeDirPath = SystemUtils.getUserHomeDir().getPath();
            String saveDir = theAppContext.getPreferences().getPropertyString("app.file.lastSaveDir", homeDirPath);
            this.targetProductSelector.getModel().setProductDir(new File(saveDir));
            this.targetProductSelector.getOpenInAppCheckBox().setText("Open in " + theAppContext.getApplicationName());
            this.targetProductSelector.getOpenInAppCheckBox().setVisible(false);
            this.add((Component)this.targetProductSelector.createPanel(), "South");
        } else {
            this.targetProductSelector = null;
        }
    }

    public void setBorderTitle(String title) {
        if (title != null) {
            this.setBorder(BorderFactory.createTitledBorder(title));
        }
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public static JPanel createComponent(FileTable table, boolean incButtonPanel) {
        JPanel fileListPanel = new JPanel(new BorderLayout(4, 4));
        JScrollPane scrollPane = new JScrollPane(table);
        fileListPanel.add((Component)scrollPane, "Center");
        if (incButtonPanel) {
            JPanel buttonPanel = ProductSetPanel.createButtonPanel(table);
            fileListPanel.add((Component)buttonPanel, "East");
        }
        return fileListPanel;
    }

    public static JPanel createButtonPanel(final FileTable table) {
        final FileTableModel tableModel = table.getModel();
        JPanel panel = new JPanel(new GridLayout(10, 1));
        final JLabel countLabel = new JLabel();
        final JButton addButton = DialogUtils.CreateButton((String)"addButton", (String)"Add", null, (JPanel)panel);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] files = ProductSetPanel.GetFilePath(addButton, "Add Product");
                if (files != null) {
                    for (File file : files) {
                        if (!ProductFunctions.isValidProduct((File)file)) continue;
                        tableModel.addFile(file);
                        countLabel.setText(tableModel.getRowCount() + " Products");
                    }
                }
            }
        });
        JButton addAllOpenButton = DialogUtils.CreateButton((String)"addAllOpenButton", (String)"Add Opened", null, (JPanel)panel);
        addAllOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Product[] products;
                for (Product prod : products = VisatApp.getApp().getProductManager().getProducts()) {
                    File file = prod.getFileLocation();
                    if (file == null || !file.exists()) continue;
                    tableModel.addFile(file);
                }
                countLabel.setText(tableModel.getRowCount() + " Products");
            }
        });
        JButton removeButton = DialogUtils.CreateButton((String)"removeButton", (String)"Remove", null, (JPanel)panel);
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selRows = table.getSelectedRows();
                ArrayList<File> filesToRemove = new ArrayList<File>(selRows.length);
                for (int row : selRows) {
                    filesToRemove.add(tableModel.getFileAt(row));
                }
                for (File file : filesToRemove) {
                    int index = tableModel.getIndexOf(file);
                    tableModel.removeFile(index);
                }
                countLabel.setText(tableModel.getRowCount() + " Products");
            }
        });
        JButton moveUpButton = DialogUtils.CreateButton((String)"moveUpButton", (String)"Move Up", null, (JPanel)panel);
        moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selRows = table.getSelectedRows();
                ArrayList<File> filesToMove = new ArrayList<File>(selRows.length);
                for (int row : selRows) {
                    filesToMove.add(tableModel.getFileAt(row));
                }
                for (File file : filesToMove) {
                    int index = tableModel.getIndexOf(file);
                    if (index <= 0) continue;
                    tableModel.move(index, index - 1);
                }
            }
        });
        JButton moveDownButton = DialogUtils.CreateButton((String)"moveDownButton", (String)"Move Down", null, (JPanel)panel);
        moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selRows = table.getSelectedRows();
                ArrayList<File> filesToMove = new ArrayList<File>(selRows.length);
                for (int row : selRows) {
                    filesToMove.add(tableModel.getFileAt(row));
                }
                for (File file : filesToMove) {
                    int index = tableModel.getIndexOf(file);
                    if (index >= tableModel.getRowCount()) continue;
                    tableModel.move(index, index + 1);
                }
            }
        });
        JButton clearButton = DialogUtils.CreateButton((String)"clearButton", (String)"Clear", null, (JPanel)panel);
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.clear();
                countLabel.setText("");
            }
        });
        panel.add(addButton);
        panel.add(addAllOpenButton);
        panel.add(moveUpButton);
        panel.add(moveDownButton);
        panel.add(removeButton);
        panel.add(clearButton);
        panel.add(countLabel);
        return panel;
    }

    private static File[] GetFilePath(Component component, String title) {
        File[] files = null;
        File openDir = new File(VisatApp.getApp().getPreferences().getPropertyString("app.file.lastOpenDir", "."));
        JFileChooser chooser = FileChooserFactory.getInstance().createFileChooser(openDir);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle(title);
        if (chooser.showDialog(component, "ok") == 0) {
            files = chooser.getSelectedFiles();
            VisatApp.getApp().getPreferences().setPropertyString("app.file.lastOpenDir", chooser.getCurrentDirectory().getAbsolutePath());
        }
        return files;
    }

    public void setTargetProductName(String name) {
        if (this.targetProductSelector != null) {
            TargetProductSelectorModel targetProductSelectorModel = this.targetProductSelector.getModel();
            targetProductSelectorModel.setProductName(name + this.getTargetProductNameSuffix());
        }
    }

    public void onApply() {
        if (this.targetProductSelector != null) {
            String productDir = this.targetProductSelector.getModel().getProductDir().getAbsolutePath();
            this.appContext.getPreferences().setPropertyString("app.file.lastSaveDir", productDir);
        }
    }

    String getTargetProductNameSuffix() {
        return this.targetProductNameSuffix;
    }

    public void setTargetProductNameSuffix(String suffix) {
        this.targetProductNameSuffix = suffix;
    }

    public File getTargetFolder() {
        if (this.targetProductSelector != null) {
            TargetProductSelectorModel targetProductSelectorModel = this.targetProductSelector.getModel();
            return targetProductSelectorModel.getProductDir();
        }
        return null;
    }

    public String getTargetFormat() {
        if (this.targetProductSelector != null) {
            TargetProductSelectorModel targetProductSelectorModel = this.targetProductSelector.getModel();
            return targetProductSelectorModel.getFormatName();
        }
        return null;
    }

    public void setTargetFolder(File path) {
        if (this.targetProductSelector != null) {
            TargetProductSelectorModel targetProductSelectorModel = this.targetProductSelector.getModel();
            targetProductSelectorModel.setProductDir(path);
        }
    }

    public File[] getFileList() {
        return this.productSetTable.getFileList();
    }

    public File[] getSelectedFiles() {
        return this.productSetTable.getModel().getFilesAt(this.productSetTable.getSelectedRows());
    }

    public Object getValueAt(int r, int c) {
        return this.productSetTable.getModel().getValueAt(r, c);
    }

    public void setProductFileList(File[] productFileList) {
        this.productSetTable.setFiles(productFileList);
    }

    public void setProductEntryList(ProductEntry[] productEntryList) {
        this.productSetTable.setProductEntries(productEntryList);
    }
}

