/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.plugins.graphbuilder;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.graph.GraphException;
import org.esa.beam.framework.gpf.ui.SourceUI;
import org.esa.beam.framework.gpf.ui.UIValidation;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.ModelessDialog;
import org.esa.beam.gpf.operators.standard.ReadOp;
import org.esa.beam.visat.VisatApp;
import org.esa.beam.visat.dialogs.PromptDialog;
import org.esa.nest.dat.plugins.graphbuilder.GraphExecuter;
import org.esa.nest.dat.plugins.graphbuilder.GraphNode;
import org.esa.nest.dat.plugins.graphbuilder.GraphPanel;
import org.esa.nest.dat.plugins.graphbuilder.ProgressBarProgressMonitor;
import org.esa.nest.gpf.ProductSetReaderOp;
import org.esa.nest.gpf.ProductSetReaderOpUI;
import org.esa.nest.util.DialogUtils;
import org.esa.nest.util.MemUtils;
import org.esa.nest.util.ResourceUtils;

public class GraphBuilderDialog
extends ModelessDialog
implements Observer {
    private static final ImageIcon processIcon = ResourceUtils.LoadIcon((String)"org/esa/nest/icons/cog.png");
    private static final ImageIcon saveIcon = ResourceUtils.LoadIcon((String)"org/esa/nest/icons/save.png");
    private static final ImageIcon loadIcon = ResourceUtils.LoadIcon((String)"org/esa/nest/icons/open.png");
    private static final ImageIcon clearIcon = ResourceUtils.LoadIcon((String)"org/esa/nest/icons/edit-clear.png");
    private static final ImageIcon helpIcon = ResourceUtils.LoadIcon((String)"org/esa/nest/icons/help-browser.png");
    private static final ImageIcon infoIcon = ResourceUtils.LoadIcon((String)"org/esa/nest/icons/info22.png");
    private final AppContext appContext;
    private GraphPanel graphPanel = null;
    private JLabel statusLabel = null;
    private String lastWarningMsg = "";
    private JPanel progressPanel = null;
    private JProgressBar progressBar = null;
    private ProgressBarProgressMonitor progBarMonitor = null;
    private JLabel progressMsgLabel = null;
    private boolean initGraphEnabled = true;
    private final GraphExecuter graphEx;
    private boolean isProcessing = false;
    private boolean allowGraphBuilding = true;
    private final List<ProcessingListener> listenerList = new ArrayList<ProcessingListener>(1);
    private JTabbedPane tabbedPanel = null;

    public GraphBuilderDialog(AppContext theAppContext, String title, String helpID) {
        super(theAppContext.getApplicationWindow(), title, 0, helpID);
        this.appContext = theAppContext;
        this.graphEx = new GraphExecuter();
        this.graphEx.addObserver(this);
        this.initUI();
    }

    public GraphBuilderDialog(AppContext theAppContext, String title, String helpID, boolean allowGraphBuilding) {
        super(theAppContext.getApplicationWindow(), title, 0, helpID);
        this.allowGraphBuilding = allowGraphBuilding;
        this.appContext = theAppContext;
        this.graphEx = new GraphExecuter();
        this.graphEx.addObserver(this);
        this.initUI();
    }

    private void initUI() {
        if (this.allowGraphBuilding) {
            super.getJDialog().setMinimumSize(new Dimension(600, 750));
        } else {
            super.getJDialog().setMinimumSize(new Dimension(600, 500));
        }
        super.getJDialog().setIconImage(ResourceUtils.esaPlanetIcon.getImage());
        JPanel mainPanel = new JPanel(new BorderLayout(4, 4));
        JPanel northPanel = new JPanel(new BorderLayout(4, 4));
        if (this.allowGraphBuilding) {
            this.graphPanel = new GraphPanel(this.graphEx);
            this.graphPanel.setBackground(Color.WHITE);
            this.graphPanel.setPreferredSize(new Dimension(500, 500));
            JScrollPane scrollPane = new JScrollPane(this.graphPanel);
            scrollPane.setPreferredSize(new Dimension(300, 300));
            northPanel.add((Component)scrollPane, "Center");
            mainPanel.add((Component)northPanel, "North");
        }
        JPanel midPanel = new JPanel(new BorderLayout(4, 4));
        this.tabbedPanel = new JTabbedPane();
        this.tabbedPanel.setTabLayoutPolicy(1);
        this.tabbedPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GraphBuilderDialog.this.ValidateAllNodes();
            }
        });
        this.statusLabel = new JLabel("");
        this.statusLabel.setForeground(new Color(255, 0, 0));
        midPanel.add((Component)this.tabbedPanel, "Center");
        midPanel.add((Component)this.statusLabel, "South");
        mainPanel.add((Component)midPanel, "Center");
        JPanel southPanel = new JPanel(new BorderLayout(4, 4));
        JPanel buttonPanel = new JPanel();
        this.initButtonPanel(buttonPanel);
        southPanel.add((Component)buttonPanel, "Center");
        this.progressBar = new JProgressBar();
        this.progressBar.setName(this.getClass().getName() + "progressBar");
        this.progressBar.setStringPainted(true);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout(2, 2));
        this.progressMsgLabel = new JLabel();
        this.progressPanel.add((Component)this.progressMsgLabel, "North");
        this.progressPanel.add((Component)this.progressBar, "Center");
        JButton progressCancelBtn = new JButton("Cancel");
        progressCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.CancelProcessing();
            }
        });
        this.progressPanel.add((Component)progressCancelBtn, "East");
        this.progressPanel.setVisible(false);
        southPanel.add((Component)this.progressPanel, "South");
        mainPanel.add((Component)southPanel, "South");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setContent(mainPanel);
    }

    private void initButtonPanel(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        JButton processButton = DialogUtils.CreateButton((String)"processButton", (String)"Process", (ImageIcon)processIcon, (JPanel)panel);
        processButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.DoProcessing();
            }
        });
        JButton saveButton = DialogUtils.CreateButton((String)"saveButton", (String)"Save", (ImageIcon)saveIcon, (JPanel)panel);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.SaveGraph();
            }
        });
        JButton loadButton = DialogUtils.CreateButton((String)"loadButton", (String)"Load", (ImageIcon)loadIcon, (JPanel)panel);
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.LoadGraph();
            }
        });
        JButton clearButton = DialogUtils.CreateButton((String)"clearButton", (String)"Clear", (ImageIcon)clearIcon, (JPanel)panel);
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.ClearGraph();
            }
        });
        JButton infoButton = DialogUtils.CreateButton((String)"infoButton", (String)"Note", (ImageIcon)infoIcon, (JPanel)panel);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.OnInfo();
            }
        });
        JButton helpButton = DialogUtils.CreateButton((String)"helpButton", (String)"Help", (ImageIcon)helpIcon, (JPanel)panel);
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.OnHelp();
            }
        });
        gbc.weightx = 0.0;
        if (this.allowGraphBuilding) {
            panel.add((Component)loadButton, gbc);
            panel.add((Component)saveButton, gbc);
            panel.add((Component)clearButton, gbc);
            panel.add((Component)infoButton, gbc);
        }
        panel.add((Component)helpButton, gbc);
        panel.add((Component)processButton, gbc);
    }

    public void DoProcessing() {
        if (this.ValidateAllNodes()) {
            MemUtils.freeAllMemory();
            this.progressBar.setValue(0);
            this.progBarMonitor = new ProgressBarProgressMonitor(this.progressBar, this.progressMsgLabel, this.progressPanel);
            ProcessThread processThread = new ProcessThread(this.progBarMonitor);
            processThread.execute();
        } else {
            this.showErrorDialog(this.statusLabel.getText());
        }
    }

    private void CancelProcessing() {
        if (this.progBarMonitor != null) {
            this.progBarMonitor.setCanceled(true);
        }
        this.graphEx.cancel();
    }

    private boolean InitGraph() {
        boolean result = true;
        try {
            if (this.initGraphEnabled) {
                result = this.graphEx.InitGraph();
            }
            if (!result) {
                this.statusLabel.setText("Graph is incomplete");
            }
        }
        catch (GraphException e) {
            if (e.getMessage() != null) {
                this.statusLabel.setText(e.getMessage());
            } else {
                this.statusLabel.setText(e.toString());
            }
            result = false;
        }
        return result;
    }

    private void SaveGraph() {
        try {
            File file = this.graphEx.saveGraph();
            this.setTitle("Graph Builder : " + file.getName());
        }
        catch (GraphException e) {
            this.showErrorDialog(e.getMessage());
        }
    }

    private void LoadGraph() {
        File file = ResourceUtils.GetFilePath((String)"Load Graph", (String)"XML", (String)"xml", null, (String)"Graph", (boolean)false, (String)"graphbuilder.last_graph_path", (String)ResourceUtils.getGraphFolder((String)"").getAbsolutePath());
        if (file == null) {
            return;
        }
        this.LoadGraph(file);
        if (this.allowGraphBuilding) {
            this.setTitle("Graph Builder : " + file.getName());
        }
    }

    public void LoadGraph(File file) {
        try {
            this.initGraphEnabled = false;
            this.tabbedPanel.removeAll();
            this.graphEx.loadGraph(file, true);
            if (this.allowGraphBuilding) {
                this.graphPanel.showRightClickHelp(false);
                this.graphPanel.repaint();
            }
            this.initGraphEnabled = true;
        }
        catch (GraphException e) {
            this.showErrorDialog(e.getMessage());
        }
    }

    public void EnableInitialInstructions(boolean flag) {
        if (this.allowGraphBuilding) {
            this.graphPanel.showRightClickHelp(flag);
        }
    }

    private void ClearGraph() {
        this.initGraphEnabled = false;
        this.tabbedPanel.removeAll();
        this.graphEx.ClearGraph();
        this.graphPanel.repaint();
        this.initGraphEnabled = true;
        this.statusLabel.setText("");
    }

    public void setInputFiles(File[] productFileList) {
        GraphNode productSetNode = this.graphEx.findGraphNodeByOperator(ProductSetReaderOp.Spi.getOperatorAlias(ProductSetReaderOp.class));
        if (productSetNode != null) {
            ProductSetReaderOpUI ui = (ProductSetReaderOpUI)productSetNode.GetOperatorUI();
            ui.setProductFileList(productFileList);
        }
    }

    public void setInputFile(Product product) {
        GraphNode readerNode = this.graphEx.findGraphNodeByOperator(ReadOp.Spi.getOperatorAlias(ReadOp.class));
        if (readerNode != null) {
            SourceUI ui = (SourceUI)readerNode.GetOperatorUI();
            ui.setSourceProduct(product);
            this.ValidateAllNodes();
        }
    }

    private void OnHelp() {
        HelpSys.showTheme((String)super.getHelpID());
    }

    private void OnInfo() {
        PromptDialog dlg = new PromptDialog("Graph Description", "Description", this.graphEx.getGraphDescription(), true);
        dlg.show();
        if (dlg.IsOK()) {
            this.graphEx.setGraphDescription(dlg.getValue());
        }
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    boolean ValidateAllNodes() {
        if (this.isProcessing) {
            return false;
        }
        boolean isValid = true;
        StringBuilder errorMsg = new StringBuilder(100);
        StringBuilder warningMsg = new StringBuilder(100);
        for (GraphNode n : this.graphEx.GetGraphNodes()) {
            try {
                UIValidation validation = n.validateParameterMap();
                if (validation.getState() == UIValidation.State.ERROR) {
                    isValid = false;
                    errorMsg.append(validation.getMsg()).append('\n');
                    continue;
                }
                if (validation.getState() != UIValidation.State.WARNING) continue;
                warningMsg.append(validation.getMsg()).append('\n');
            }
            catch (Exception e) {
                isValid = false;
                errorMsg.append(e.getMessage()).append('\n');
            }
        }
        this.statusLabel.setForeground(new Color(255, 0, 0));
        this.statusLabel.setText("");
        String warningStr = warningMsg.toString();
        if (!isValid) {
            this.statusLabel.setText(errorMsg.toString());
            return false;
        }
        if (!warningStr.isEmpty()) {
            if (warningStr.length() > 100 && !warningStr.equals(this.lastWarningMsg)) {
                VisatApp.getApp().showWarningDialog(warningStr);
                this.lastWarningMsg = warningStr;
            } else {
                this.statusLabel.setForeground(new Color(0, 100, 255));
                this.statusLabel.setText("Warning: " + warningStr);
            }
        }
        return this.InitGraph();
    }

    public void addListener(ProcessingListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeListener(ProcessingListener listener) {
        this.listenerList.remove(listener);
    }

    private void notifyMSG(ProcessingListener.MSG msg, String text) {
        for (ProcessingListener listener : this.listenerList) {
            listener.notifyMSG(msg, text);
        }
    }

    private void notifyMSG(ProcessingListener.MSG msg, File[] fileList) {
        for (ProcessingListener listener : this.listenerList) {
            listener.notifyMSG(msg, fileList);
        }
    }

    @Override
    public void update(Observable subject, Object data) {
        try {
            GraphExecuter.GraphEvent event = (GraphExecuter.GraphEvent)data;
            GraphNode node = (GraphNode)event.getData();
            String opID = node.getID();
            if (event.getEventType() == GraphExecuter.events.ADD_EVENT) {
                this.tabbedPanel.addTab(opID, null, this.CreateOperatorTab(node), opID + " Operator");
            } else if (event.getEventType() == GraphExecuter.events.REMOVE_EVENT) {
                int index = this.tabbedPanel.indexOfTab(opID);
                this.tabbedPanel.remove(index);
            } else if (event.getEventType() == GraphExecuter.events.SELECT_EVENT) {
                int index = this.tabbedPanel.indexOfTab(opID);
                this.tabbedPanel.setSelectedIndex(index);
            }
        }
        catch (Exception e) {
            this.statusLabel.setText(e.getMessage());
        }
    }

    private JComponent CreateOperatorTab(GraphNode node) {
        return node.GetOperatorUI().CreateOpTab(node.getOperatorName(), node.getParameterMap(), this.appContext);
    }

    private void openTargetProducts(File[] fileList) {
        if (fileList.length != 0) {
            for (File file : fileList) {
                try {
                    Product product = ProductIO.readProduct((File)file);
                    if (product == null) continue;
                    this.appContext.getProductManager().addProduct(product);
                }
                catch (IOException e) {
                    this.showErrorDialog(e.getMessage());
                }
            }
        }
    }

    public static File getInternalGraphFolder() {
        return ResourceUtils.getGraphFolder((String)"internal");
    }

    public static File getStandardGraphFolder() {
        return ResourceUtils.getGraphFolder((String)"Standard Graphs");
    }

    public static interface ProcessingListener {
        public void notifyMSG(MSG var1, File[] var2);

        public void notifyMSG(MSG var1, String var2);

        public static enum MSG {
            DONE,
            UPDATE;

        }
    }

    private class ProcessThread
    extends SwingWorker<GraphExecuter, Object> {
        private final ProgressMonitor pm;
        private Date executeStartTime = null;
        private boolean errorOccured = false;

        public ProcessThread(ProgressMonitor pm) {
            this.pm = pm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected GraphExecuter doInBackground() throws Exception {
            this.pm.beginTask("Processing Graph...", 10);
            try {
                this.executeStartTime = Calendar.getInstance().getTime();
                GraphBuilderDialog.this.isProcessing = true;
                GraphBuilderDialog.this.graphEx.executeGraph(this.pm);
            }
            catch (Throwable e) {
                System.out.print(e.getMessage());
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    GraphBuilderDialog.this.statusLabel.setText(e.getMessage());
                } else {
                    GraphBuilderDialog.this.statusLabel.setText(e.getCause().toString());
                }
                this.errorOccured = true;
            }
            finally {
                GraphBuilderDialog.this.isProcessing = false;
                GraphBuilderDialog.this.graphEx.disposeGraphContext();
                MemUtils.freeAllMemory();
                this.pm.done();
            }
            return GraphBuilderDialog.this.graphEx;
        }

        @Override
        public void done() {
            if (!this.errorOccured) {
                Date now = Calendar.getInstance().getTime();
                long diff = (now.getTime() - this.executeStartTime.getTime()) / 1000L;
                if (diff > 120L) {
                    float minutes = (float)diff / 60.0f;
                    GraphBuilderDialog.this.statusLabel.setText("Processing completed in " + minutes + " minutes");
                } else {
                    GraphBuilderDialog.this.statusLabel.setText("Processing completed in " + diff + " seconds");
                }
                List<File> fileList = GraphBuilderDialog.this.graphEx.getProductsToOpenInDAT();
                GraphBuilderDialog.this.notifyMSG(ProcessingListener.MSG.DONE, fileList.toArray(new File[fileList.size()]));
            }
            if (!this.errorOccured) {
                List<File> fileList = GraphBuilderDialog.this.graphEx.getProductsToOpenInDAT();
                GraphBuilderDialog.this.openTargetProducts(fileList.toArray(new File[fileList.size()]));
            }
        }
    }
}

