/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.plugins.graphbuilder;

import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import com.bc.ceres.core.ProgressMonitor;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.StringTokenizer;
import org.esa.beam.framework.gpf.GPF;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.OperatorSpiRegistry;
import org.esa.beam.framework.gpf.OperatorUI;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.graph.Graph;
import org.esa.beam.framework.gpf.graph.GraphContext;
import org.esa.beam.framework.gpf.graph.GraphException;
import org.esa.beam.framework.gpf.graph.GraphIO;
import org.esa.beam.framework.gpf.graph.GraphProcessor;
import org.esa.beam.framework.gpf.graph.Node;
import org.esa.beam.framework.gpf.graph.NodeContext;
import org.esa.beam.gpf.operators.standard.ReadOp;
import org.esa.beam.gpf.operators.standard.WriteOp;
import org.esa.beam.util.io.FileUtils;
import org.esa.nest.dat.plugins.graphbuilder.GraphNode;
import org.esa.nest.gpf.GPFProcessor;
import org.esa.nest.gpf.ProductSetReaderOp;
import org.esa.nest.gpf.ReaderUtils;
import org.esa.nest.util.ResourceUtils;

public class GraphExecuter
extends Observable {
    public static final String LAST_GRAPH_PATH = "graphbuilder.last_graph_path";
    private final GPF gpf;
    private Graph graph;
    private GraphContext graphContext = null;
    private GraphProcessor processor;
    private String graphDescription = "";
    private File lastLoadedGraphFile = null;
    private int idCount = 0;
    private final List<GraphNode> nodeList = new ArrayList<GraphNode>(10);

    public GraphExecuter() {
        this.gpf = GPF.getDefaultInstance();
        this.gpf.getOperatorSpiRegistry().loadOperatorSpis();
        this.graph = new Graph("Graph");
    }

    public List<GraphNode> GetGraphNodes() {
        return this.nodeList;
    }

    public void ClearGraph() {
        this.graph = null;
        this.graph = new Graph("Graph");
        this.lastLoadedGraphFile = null;
        this.nodeList.clear();
        this.idCount = 0;
    }

    public GraphNode findGraphNode(String id) {
        for (GraphNode n : this.nodeList) {
            if (!n.getID().equals(id)) continue;
            return n;
        }
        return null;
    }

    public GraphNode findGraphNodeByOperator(String operatorName) {
        for (GraphNode n : this.nodeList) {
            if (!n.getOperatorName().equals(operatorName)) continue;
            return n;
        }
        return null;
    }

    public void setSelectedNode(GraphNode node) {
        if (node == null) {
            return;
        }
        this.setChanged();
        this.notifyObservers(new GraphEvent(events.SELECT_EVENT, node));
        this.clearChanged();
    }

    public Set<String> GetOperatorList() {
        return this.gpf.getOperatorSpiRegistry().getAliases();
    }

    public boolean isOperatorInternal(String alias) {
        OperatorSpiRegistry registry = this.gpf.getOperatorSpiRegistry();
        OperatorSpi operatorSpi = registry.getOperatorSpi(alias);
        OperatorMetadata operatorMetadata = operatorSpi.getOperatorClass().getAnnotation(OperatorMetadata.class);
        return operatorMetadata == null || operatorMetadata.internal();
    }

    public String getOperatorCategory(String alias) {
        OperatorSpiRegistry registry = this.gpf.getOperatorSpiRegistry();
        OperatorSpi operatorSpi = registry.getOperatorSpi(alias);
        OperatorMetadata operatorMetadata = operatorSpi.getOperatorClass().getAnnotation(OperatorMetadata.class);
        if (operatorMetadata != null) {
            return operatorMetadata.category();
        }
        return "";
    }

    public GraphNode addOperator(String opName) {
        String id = "" + ++this.idCount + '-' + opName;
        GraphNode newGraphNode = this.createNewGraphNode(opName, id);
        this.setChanged();
        this.notifyObservers(new GraphEvent(events.ADD_EVENT, newGraphNode));
        this.clearChanged();
        return newGraphNode;
    }

    private GraphNode createNewGraphNode(String opName, String id) {
        Node newNode = new Node(id, opName);
        XppDomElement parameters = new XppDomElement("parameters");
        newNode.setConfiguration((DomElement)parameters);
        this.graph.addNode(newNode);
        GraphNode newGraphNode = new GraphNode(newNode);
        this.nodeList.add(newGraphNode);
        newGraphNode.setOperatorUI(GraphExecuter.CreateOperatorUI(newGraphNode.getOperatorName()));
        return newGraphNode;
    }

    private static OperatorUI CreateOperatorUI(String operatorName) {
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(operatorName);
        if (operatorSpi == null) {
            return null;
        }
        return operatorSpi.createOperatorUI();
    }

    public void removeOperator(GraphNode node) {
        this.setChanged();
        this.notifyObservers(new GraphEvent(events.REMOVE_EVENT, node));
        this.clearChanged();
        this.removeNode(node);
    }

    private void removeNode(GraphNode node) {
        for (GraphNode n : this.nodeList) {
            n.disconnectOperatorSources(node.getID());
        }
        this.graph.removeNode(node.getID());
        this.nodeList.remove(node);
    }

    public void setOperatorParam(String id, String paramName, String value) {
        Node node = this.graph.getNode(id);
        DomElement xml = (DomElement)node.getConfiguration().getChild(paramName);
        if (xml == null) {
            xml = new XppDomElement(paramName);
            node.getConfiguration().addChild(xml);
        }
        xml.setValue(value);
    }

    private void AssignAllParameters() {
        XppDom presentationXML = new XppDom("Presentation");
        XppDom descXML = new XppDom("Description");
        descXML.setValue(this.graphDescription);
        presentationXML.addChild(descXML);
        for (GraphNode n : this.nodeList) {
            if (n.GetOperatorUI() == null) continue;
            n.AssignParameters(presentationXML);
        }
        this.graph.setAppData("Presentation", presentationXML);
    }

    boolean IsGraphComplete() {
        int nodesWithoutSources = 0;
        for (GraphNode n : this.nodeList) {
            if (n.HasSources()) continue;
            ++nodesWithoutSources;
            if (this.IsNodeASource(n)) continue;
            return false;
        }
        return nodesWithoutSources != this.nodeList.size();
    }

    private boolean IsNodeASource(GraphNode sourceNode) {
        for (GraphNode n : this.nodeList) {
            if (!n.isNodeSource(sourceNode)) continue;
            return true;
        }
        return false;
    }

    private GraphNode[] findConnectedNodes(GraphNode sourceNode) {
        ArrayList<GraphNode> connectedNodes = new ArrayList<GraphNode>();
        for (GraphNode n : this.nodeList) {
            if (!n.isNodeSource(sourceNode)) continue;
            connectedNodes.add(n);
        }
        return connectedNodes.toArray(new GraphNode[connectedNodes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean InitGraph() throws GraphException {
        if (this.IsGraphComplete()) {
            this.AssignAllParameters();
            GraphNode[] savedProductSetList = this.replaceProductSetReaders();
            try {
                this.recreateGraphContext();
                this.updateGraphNodes();
            }
            finally {
                this.restoreProductSetReaders(savedProductSetList);
            }
            return true;
        }
        return false;
    }

    private void recreateGraphContext() throws GraphException {
        if (this.graphContext != null) {
            this.graphContext.dispose();
        }
        this.processor = new GraphProcessor();
        this.graphContext = new GraphContext(this.graph);
    }

    private void updateGraphNodes() {
        if (this.graphContext != null) {
            for (GraphNode n : this.nodeList) {
                NodeContext context = this.graphContext.getNodeContext(n.getNode());
                n.setSourceProducts(context.getSourceProducts());
            }
        }
    }

    public void disposeGraphContext() {
        this.graphContext.dispose();
    }

    public void executeGraph(ProgressMonitor pm) {
        this.processor.executeGraph(this.graphContext, pm);
    }

    public void cancel() {
        this.graphContext.cancel();
    }

    File saveGraph() throws GraphException {
        File filePath;
        String filename = "myGraph";
        if (this.lastLoadedGraphFile != null) {
            filename = this.lastLoadedGraphFile.getAbsolutePath();
        }
        if ((filePath = ResourceUtils.GetFilePath((String)"Save Graph", (String)"XML", (String)"xml", (String)filename, (String)"Graph", (boolean)true, (String)LAST_GRAPH_PATH, (String)ResourceUtils.getGraphFolder((String)"").getAbsolutePath())) != null) {
            this.writeGraph(filePath.getAbsolutePath());
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGraph(String filePath) throws GraphException {
        try (FileWriter fileWriter = new FileWriter(filePath);){
            this.AssignAllParameters();
            GraphIO.write((Graph)this.graph, (Writer)fileWriter);
        }
        catch (Exception e) {
            throw new GraphException("Unable to write graph to " + filePath + '\n' + e.getMessage());
        }
    }

    public void loadGraph(File filePath, boolean addUI) throws GraphException {
        try {
            if (filePath == null) {
                return;
            }
            Graph graphFromFile = GPFProcessor.readGraph(filePath, null);
            this.setGraph(graphFromFile, addUI);
            this.lastLoadedGraphFile = filePath;
        }
        catch (Throwable e) {
            throw new GraphException("Unable to load graph " + filePath + '\n' + e.getMessage());
        }
    }

    public void setGraph(Graph graphFromFile, boolean addUI) {
        if (graphFromFile != null) {
            Node[] nodes;
            XppDom descXML;
            this.graph = graphFromFile;
            this.nodeList.clear();
            XppDom presentationXML = this.graph.getApplicationData("Presentation");
            if (presentationXML != null && (descXML = presentationXML.getChild("Description")) != null && descXML.getValue() != null) {
                this.graphDescription = descXML.getValue();
            }
            for (Node n : nodes = this.graph.getNodes()) {
                GraphNode newGraphNode = new GraphNode(n);
                if (presentationXML != null) {
                    newGraphNode.setDisplayParameters(presentationXML);
                }
                this.nodeList.add(newGraphNode);
                if (addUI) {
                    newGraphNode.setOperatorUI(GraphExecuter.CreateOperatorUI(newGraphNode.getOperatorName()));
                }
                this.setChanged();
                this.notifyObservers(new GraphEvent(events.ADD_EVENT, newGraphNode));
                this.clearChanged();
            }
            this.idCount = nodes.length;
        }
    }

    public String getGraphDescription() {
        return this.graphDescription;
    }

    public void setGraphDescription(String text) {
        this.graphDescription = text;
    }

    private ProductSetData[] findProductSets(String readerName) {
        String SEPARATOR = ",";
        String SEPARATOR_ESC = "\\u002C";
        ArrayList<ProductSetData> productSetDataList = new ArrayList<ProductSetData>();
        for (Node n : this.graph.getNodes()) {
            DomElement[] params;
            if (!n.getOperatorName().equalsIgnoreCase(readerName)) continue;
            ProductSetData psData = new ProductSetData();
            psData.nodeID = n.getId();
            DomElement config = n.getConfiguration();
            for (DomElement p : params = (DomElement[])config.getChildren()) {
                if (!p.getName().equals("fileList") || p.getValue() == null) continue;
                StringTokenizer st = new StringTokenizer(p.getValue(), ",");
                int length = st.countTokens();
                for (int i = 0; i < length; ++i) {
                    String str = st.nextToken().replace("\\u002C", ",");
                    psData.fileList.add(str);
                }
                break;
            }
            productSetDataList.add(psData);
        }
        return productSetDataList.toArray(new ProductSetData[productSetDataList.size()]);
    }

    private GraphNode[] replaceProductSetReaders() {
        ProductSetData[] productSetDataList = this.findProductSets(OperatorSpi.getOperatorAlias(ProductSetReaderOp.class));
        ArrayList<GraphNode> savedProductSetList = new ArrayList<GraphNode>();
        int cnt = 0;
        for (ProductSetData psData : productSetDataList) {
            GraphNode sourceNode = this.findGraphNode(psData.nodeID);
            for (String filePath : psData.fileList) {
                this.replaceProductSetWithReaders(sourceNode, "inserted--" + sourceNode.getID() + "--" + cnt++, filePath);
            }
            if (psData.fileList.isEmpty()) continue;
            this.removeNode(sourceNode);
            savedProductSetList.add(sourceNode);
        }
        return savedProductSetList.toArray(new GraphNode[savedProductSetList.size()]);
    }

    private void restoreProductSetReaders(GraphNode[] savedProductSetList) {
        for (GraphNode multiSrcNode : savedProductSetList) {
            ArrayList<GraphNode> nodesToRemove = new ArrayList<GraphNode>();
            for (GraphNode n : this.nodeList) {
                String id = n.getID();
                if (!id.startsWith("inserted") || !id.contains(multiSrcNode.getID())) continue;
                this.switchConnections(n, multiSrcNode.getID());
                nodesToRemove.add(n);
            }
            for (GraphNode r : nodesToRemove) {
                this.removeNode(r);
            }
            this.nodeList.add(multiSrcNode);
            this.graph.addNode(multiSrcNode.getNode());
        }
    }

    private void replaceProductSetWithReaders(GraphNode sourceNode, String id, String value) {
        GraphNode newReaderNode = this.createNewGraphNode(OperatorSpi.getOperatorAlias(ReadOp.class), id);
        newReaderNode.setOperatorUI(null);
        newReaderNode.getNode().getConfiguration();
        DomElement config = newReaderNode.getNode().getConfiguration();
        XppDomElement fileParam = new XppDomElement("file");
        fileParam.setValue(value);
        config.addChild((DomElement)fileParam);
        this.switchConnections(sourceNode, newReaderNode.getID());
    }

    private void switchConnections(GraphNode oldNode, String newNodeID) {
        GraphNode[] connectedNodes;
        for (GraphNode node : connectedNodes = this.findConnectedNodes(oldNode)) {
            node.connectOperatorSource(newNodeID);
        }
    }

    public List<File> getProductsToOpenInDAT() {
        Node[] nodes;
        ArrayList<File> fileList = new ArrayList<File>(2);
        for (Node n : nodes = this.graph.getNodes()) {
            DomElement config;
            DomElement fileParam;
            String filePath;
            if (!n.getOperatorName().equalsIgnoreCase(OperatorSpi.getOperatorAlias(WriteOp.class)) || (filePath = (fileParam = (DomElement)(config = n.getConfiguration()).getChild("file")).getValue()) == null || filePath.isEmpty()) continue;
            File file = new File(filePath);
            if (file.exists()) {
                fileList.add(file);
                continue;
            }
            DomElement formatParam = (DomElement)config.getChild("formatName");
            String format = formatParam.getValue();
            String ext = ReaderUtils.findExtensionForFormat((String)format);
            File newFile = new File(file.getAbsolutePath() + ext);
            if (newFile.exists()) {
                fileList.add(newFile);
                continue;
            }
            String name = FileUtils.getFilenameWithoutExtension((File)file);
            newFile = new File(name + ext);
            if (!newFile.exists()) continue;
            fileList.add(newFile);
        }
        return fileList;
    }

    public static void setGraphIO(GraphExecuter graphEx, String readID, File readPath, String writeID, File writePath, String format) {
        GraphNode writeNode;
        GraphNode readNode = graphEx.findGraphNode(readID);
        if (readNode != null) {
            graphEx.setOperatorParam(readNode.getID(), "file", readPath.getAbsolutePath());
        }
        if (writeID != null && (writeNode = graphEx.findGraphNode(writeID)) != null) {
            graphEx.setOperatorParam(writeNode.getID(), "formatName", format);
            graphEx.setOperatorParam(writeNode.getID(), "file", writePath.getAbsolutePath());
        }
    }

    public static class GraphEvent {
        private final events eventType;
        private final Object data;

        GraphEvent(events type, Object d) {
            this.eventType = type;
            this.data = d;
        }

        public Object getData() {
            return this.data;
        }

        public events getEventType() {
            return this.eventType;
        }
    }

    private static class ProductSetData {
        String nodeID = null;
        final List<String> fileList = new ArrayList<String>(10);

        private ProductSetData() {
        }
    }

    public static enum events {
        ADD_EVENT,
        REMOVE_EVENT,
        SELECT_EVENT;

    }
}

