/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.plugins.graphbuilder;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.esa.beam.framework.gpf.graph.NodeSource;
import org.esa.beam.util.StringUtils;
import org.esa.nest.dat.plugins.graphbuilder.GraphExecuter;
import org.esa.nest.dat.plugins.graphbuilder.GraphNode;
import org.esa.nest.util.ResourceUtils;

class GraphPanel
extends JPanel
implements ActionListener,
PopupMenuListener,
MouseListener,
MouseMotionListener {
    private final GraphExecuter graphEx;
    private JMenu addMenu;
    private Point lastMousePos = null;
    private final AddMenuListener addListener = new AddMenuListener(this);
    private final ConnectMenuListener connectListener = new ConnectMenuListener(this);
    private final RemoveSourceMenuListener removeSourceListener = new RemoveSourceMenuListener(this);
    private static final Font font = new Font("Ariel", 1, 10);
    private static final Color opColor = new Color(200, 200, 255, 128);
    private static final Color selColor = new Color(200, 255, 200, 150);
    private static final Color helpColor = new Color(250, 255, 250, 150);
    private static final char[] folderDelim = new char[]{'\\'};
    private GraphNode selectedNode = null;
    private boolean showHeadHotSpot = false;
    private boolean showTailHotSpot = false;
    private boolean connectingSourceFromHead = false;
    private boolean connectingSourceFromTail = false;
    private Point connectingSourcePos = null;
    private GraphNode connectSourceTargetNode = null;
    private boolean showRightClickHelp = false;

    GraphPanel(GraphExecuter graphExec) {
        this.graphEx = graphExec;
        this.CreateAddOpMenu();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    /*
     * WARNING - void declaration
     */
    private void CreateAddOpMenu() {
        void var7_13;
        void var7_11;
        String category;
        Object alias;
        void var7_9;
        ImageIcon opIcon = ResourceUtils.LoadIcon((String)"org/esa/nest/icons/cog_add.png");
        this.addMenu = new JMenu("Add");
        Set<String> gpfOperatorSet = this.graphEx.GetOperatorList();
        Object[] gpfOperatorList = new String[gpfOperatorSet.size()];
        gpfOperatorSet.toArray(gpfOperatorList);
        Arrays.sort(gpfOperatorList);
        ArrayList<Object> aliasList = new ArrayList<Object>(gpfOperatorList.length);
        Object[] arr$ = gpfOperatorList;
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_9 < len$) {
            alias = arr$[var7_9];
            category = this.graphEx.getOperatorCategory((String)alias);
            if (category.contains("\\")) {
                aliasList.add(alias);
            }
            ++var7_9;
        }
        arr$ = gpfOperatorList;
        len$ = arr$.length;
        boolean bl2 = false;
        while (var7_11 < len$) {
            alias = arr$[var7_11];
            if (!aliasList.contains(alias) && !(category = this.graphEx.getOperatorCategory((String)alias)).isEmpty()) {
                aliasList.add(alias);
            }
            ++var7_11;
        }
        arr$ = gpfOperatorList;
        len$ = arr$.length;
        boolean bl3 = false;
        while (var7_13 < len$) {
            alias = arr$[var7_13];
            if (!aliasList.contains(alias)) {
                aliasList.add(alias);
            }
            ++var7_13;
        }
        ArrayList<JMenu> subMenuList = new ArrayList<JMenu>(20);
        for (String string : aliasList) {
            if (this.graphEx.isOperatorInternal(string)) continue;
            String category2 = this.graphEx.getOperatorCategory(string);
            JMenu menu = this.addMenu;
            if (!category2.isEmpty()) {
                String[] categoryPath;
                for (String folder : categoryPath = StringUtils.split((String)category2, (char[])folderDelim, (boolean)true)) {
                    menu = GraphPanel.getMenuFolder(subMenuList, folder, menu);
                }
            }
            JMenuItem item = new JMenuItem(string, opIcon);
            item.setHorizontalTextPosition(4);
            item.addActionListener(this.addListener);
            menu.add(item);
        }
    }

    private static JMenu getMenuFolder(List<JMenu> subMenuList, String folderName, JMenu currentMenu) {
        boolean menuExists = false;
        for (JMenu sub : subMenuList) {
            if (!sub.getText().equals(folderName)) continue;
            currentMenu = sub;
            menuExists = true;
            break;
        }
        if (!menuExists) {
            JMenu newMenu = new JMenu(folderName);
            subMenuList.add(newMenu);
            currentMenu.add(newMenu);
            currentMenu = newMenu;
        }
        return currentMenu;
    }

    void AddOperatorAction(String name) {
        GraphNode newGraphNode = this.graphEx.addOperator(name);
        newGraphNode.setPos(this.lastMousePos);
        this.repaint();
    }

    void RemoveSourceAction(String id) {
        if (this.selectedNode != null) {
            GraphNode source = this.graphEx.findGraphNode(id);
            this.selectedNode.disconnectOperatorSources(source.getID());
            this.repaint();
        }
    }

    void AutoConnectGraph() {
        if (!this.graphEx.IsGraphComplete()) {
            List<GraphNode> nodes = this.graphEx.GetGraphNodes();
            Collections.sort(nodes, new GraphNodePosComparator());
            for (int i = 0; i < nodes.size() - 1; ++i) {
                nodes.get(i).disconnectAllSources();
                nodes.get(i).connectOperatorSource(nodes.get(i + 1).getID());
            }
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String name = event.getActionCommand();
        if (name.equals("Delete")) {
            this.graphEx.removeOperator(this.selectedNode);
            this.repaint();
        }
    }

    private void checkPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popup = new JPopupMenu();
            popup.add(this.addMenu);
            if (this.selectedNode != null) {
                JMenuItem item = new JMenuItem("Delete");
                popup.add(item);
                item.setHorizontalTextPosition(4);
                item.addActionListener(this);
                NodeSource[] sources = this.selectedNode.getNode().getSources();
                if (sources.length > 0) {
                    JMenu removeSourcedMenu = new JMenu("Remove Source");
                    for (NodeSource ns : sources) {
                        JMenuItem nsItem = new JMenuItem(ns.getSourceNodeId());
                        removeSourcedMenu.add(nsItem);
                        nsItem.setHorizontalTextPosition(4);
                        nsItem.addActionListener(this.removeSourceListener);
                    }
                    popup.add(removeSourcedMenu);
                }
            }
            if (!this.graphEx.IsGraphComplete()) {
                JMenuItem connectItem = new JMenuItem("Connect Graph", null);
                connectItem.setHorizontalTextPosition(4);
                connectItem.addActionListener(this.connectListener);
                popup.add(connectItem);
            }
            popup.setLabel("Justification");
            popup.setBorder(new BevelBorder(0));
            popup.addPopupMenuListener(this);
            popup.show(this, e.getX(), e.getY());
            this.showRightClickHelp = false;
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.DrawGraph(g, this.graphEx.GetGraphNodes());
    }

    private void DrawGraph(Graphics g, List<GraphNode> nodeList) {
        Point p2;
        Point p1;
        g.setFont(font);
        if (this.showRightClickHelp) {
            GraphPanel.drawHelp(g, helpColor);
        }
        for (GraphNode n : nodeList) {
            if (n == this.selectedNode) {
                n.drawNode(g, selColor);
                continue;
            }
            n.drawNode(g, opColor);
        }
        for (GraphNode n : nodeList) {
            NodeSource[] nSources;
            g.setColor(Color.red);
            for (NodeSource nSource : nSources = n.getNode().getSources()) {
                GraphNode srcNode = this.graphEx.findGraphNode(nSource.getSourceNodeId());
                if (srcNode == null) continue;
                n.drawConnectionLine(g, srcNode);
            }
        }
        if (this.showHeadHotSpot && this.selectedNode != null) {
            this.selectedNode.drawHeadHotspot(g, Color.red);
        }
        if (this.showTailHotSpot && this.selectedNode != null) {
            this.selectedNode.drawTailHotspot(g, Color.red);
        }
        if (this.connectingSourceFromHead && this.connectSourceTargetNode != null) {
            p1 = this.connectSourceTargetNode.getPos();
            p2 = this.connectingSourcePos;
            if (p1 != null && p2 != null) {
                g.setColor(Color.red);
                g.drawLine(p1.x, p1.y + this.connectSourceTargetNode.getHalfNodeHeight(), p2.x, p2.y);
            }
        } else if (this.connectingSourceFromTail && this.connectSourceTargetNode != null) {
            p1 = this.connectSourceTargetNode.getPos();
            p2 = this.connectingSourcePos;
            if (p1 != null && p2 != null) {
                g.setColor(Color.red);
                g.drawLine(p1.x + this.connectSourceTargetNode.getWidth(), p1.y + this.connectSourceTargetNode.getHalfNodeHeight(), p2.x, p2.y);
            }
        }
    }

    void showRightClickHelp(boolean flag) {
        this.showRightClickHelp = flag;
    }

    private static void drawHelp(Graphics g, Color col) {
        int x = (int)(g.getClipBounds().getWidth() / 2.0);
        int y = (int)(g.getClipBounds().getHeight() / 2.0);
        FontMetrics metrics = g.getFontMetrics();
        String name = "Right click here to add an operator";
        Rectangle2D rect = metrics.getStringBounds("Right click here to add an operator", g);
        int stringWidth = (int)rect.getWidth();
        g.setColor(Color.black);
        g.drawString("Right click here to add an operator", x - stringWidth / 2, y);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkPopup(e);
        if (this.showHeadHotSpot) {
            this.connectingSourceFromHead = true;
        } else if (this.showTailHotSpot) {
            this.connectingSourceFromTail = true;
        }
        this.lastMousePos = e.getPoint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkPopup(e);
        this.showRightClickHelp = false;
        if (this.selectedNode != null) {
            this.graphEx.setSelectedNode(this.selectedNode);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        GraphNode n;
        this.checkPopup(e);
        if (this.connectingSourceFromHead) {
            GraphNode n2 = this.findNode(e.getPoint());
            if (n2 != null && this.selectedNode != n2) {
                this.connectSourceTargetNode.connectOperatorSource(n2.getID());
            }
        } else if (this.connectingSourceFromTail && (n = this.findNode(e.getPoint())) != null && this.selectedNode != n) {
            n.connectOperatorSource(this.connectSourceTargetNode.getID());
        }
        this.connectingSourceFromHead = false;
        this.connectingSourceFromTail = false;
        this.connectSourceTargetNode = null;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectedNode != null && !this.connectingSourceFromHead && !this.connectingSourceFromTail) {
            Point p = new Point(e.getX() - (this.lastMousePos.x - this.selectedNode.getPos().x), e.getY() - (this.lastMousePos.y - this.selectedNode.getPos().y));
            this.selectedNode.setPos(p);
            this.lastMousePos = e.getPoint();
            this.repaint();
        }
        if (this.connectingSourceFromHead || this.connectingSourceFromTail) {
            this.connectingSourcePos = e.getPoint();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        GraphNode n = this.findNode(e.getPoint());
        if (this.selectedNode != n) {
            this.showHeadHotSpot = false;
            this.showTailHotSpot = false;
            this.selectedNode = n;
            this.repaint();
        }
        if (this.selectedNode != null) {
            int hotspotSize = GraphNode.getHotSpotSize();
            Point headPoint = new Point(n.getPos().x, n.getPos().y + this.selectedNode.getHotSpotOffset());
            Point tailPoint = new Point(n.getPos().x + n.getWidth() - hotspotSize, n.getPos().y + this.selectedNode.getHotSpotOffset());
            if (GraphPanel.isWithinRect(headPoint, hotspotSize, hotspotSize, e.getPoint())) {
                this.showHeadHotSpot = true;
                this.connectSourceTargetNode = this.selectedNode;
                this.repaint();
            } else if (GraphPanel.isWithinRect(tailPoint, hotspotSize, hotspotSize, e.getPoint())) {
                this.showTailHotSpot = true;
                this.connectSourceTargetNode = this.selectedNode;
                this.repaint();
            } else if (this.showHeadHotSpot || this.showTailHotSpot) {
                this.showHeadHotSpot = false;
                this.showTailHotSpot = false;
                this.repaint();
            }
        }
    }

    private GraphNode findNode(Point p) {
        for (GraphNode n : this.graphEx.GetGraphNodes()) {
            if (!GraphPanel.isWithinRect(n.getPos(), n.getWidth(), n.getHeight(), p)) continue;
            return n;
        }
        return null;
    }

    private static boolean isWithinRect(Point o, int width, int height, Point p) {
        return p.x > o.x && p.y > o.y && p.x < o.x + width && p.y < o.y + height;
    }

    static class GraphNodePosComparator
    implements Comparator<GraphNode> {
        GraphNodePosComparator() {
        }

        @Override
        public int compare(GraphNode o1, GraphNode o2) {
            double h2;
            double x1 = o1.getPos().getX();
            double y1 = o1.getPos().getY();
            double x2 = o2.getPos().getX();
            double y2 = o2.getPos().getY();
            double h1 = Math.hypot(x1, y1);
            if (h1 > (h2 = Math.hypot(x2, y2))) {
                return -1;
            }
            if (h1 < h2) {
                return 1;
            }
            return 0;
        }
    }

    static class RemoveSourceMenuListener
    implements ActionListener {
        final GraphPanel graphPanel;

        RemoveSourceMenuListener(GraphPanel panel) {
            this.graphPanel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.graphPanel.RemoveSourceAction(event.getActionCommand());
        }
    }

    static class ConnectMenuListener
    implements ActionListener {
        final GraphPanel graphPanel;

        ConnectMenuListener(GraphPanel panel) {
            this.graphPanel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.graphPanel.AutoConnectGraph();
        }
    }

    static class AddMenuListener
    implements ActionListener {
        final GraphPanel graphPanel;

        AddMenuListener(GraphPanel panel) {
            this.graphPanel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.graphPanel.AddOperatorAction(event.getActionCommand());
        }
    }
}

