/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.plugins.graphbuilder;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.esa.nest.gpf.ProgressMonitorList;

public class ProgressBarProgressMonitor
implements ProgressMonitor {
    private final JProgressBar progressBar;
    private final JLabel messageLabel;
    private final JPanel progressPanel;
    private double currentWork;
    private double totalWork;
    private int totalWorkUI;
    private int currentWorkUI;
    private int lastWorkUI;
    private boolean cancelRequested;

    public ProgressBarProgressMonitor(JProgressBar progressBar, JLabel messageLabel, JPanel progressPanel) {
        this.progressBar = progressBar;
        this.messageLabel = messageLabel;
        this.progressPanel = progressPanel;
    }

    public void beginTask(String name, int totalWork) {
        Assert.notNull((Object)name, (String)"name");
        this.currentWork = 0.0;
        this.totalWork = totalWork;
        this.currentWorkUI = 0;
        this.lastWorkUI = 0;
        this.totalWorkUI = totalWork;
        if (this.messageLabel != null) {
            this.messageLabel.setText(name);
        }
        this.cancelRequested = false;
        this.setDescription(name);
        this.setVisibility(true);
        this.progressBar.setMaximum(totalWork);
        ProgressMonitorList.instance().add((ProgressMonitor)this);
    }

    public void done() {
        this.runInUI(new Runnable(){

            @Override
            public void run() {
                if (ProgressBarProgressMonitor.this.progressBar != null) {
                    ProgressBarProgressMonitor.this.progressBar.setValue(ProgressBarProgressMonitor.this.progressBar.getMaximum());
                    ProgressBarProgressMonitor.this.setVisibility(false);
                }
            }
        });
        ProgressMonitorList.instance().remove((ProgressMonitor)this);
    }

    public void internalWorked(double work) {
        this.currentWork += work;
        this.currentWorkUI = (int)((double)this.totalWorkUI * this.currentWork / this.totalWork);
        if (this.currentWorkUI > this.lastWorkUI) {
            this.runInUI(new Runnable(){

                @Override
                public void run() {
                    if (ProgressBarProgressMonitor.this.progressBar != null) {
                        int progress = ProgressBarProgressMonitor.this.progressBar.getMinimum() + ProgressBarProgressMonitor.this.currentWorkUI;
                        ProgressBarProgressMonitor.this.progressBar.setValue(progress);
                        ProgressBarProgressMonitor.this.setVisibility(true);
                    }
                    ProgressBarProgressMonitor.this.lastWorkUI = ProgressBarProgressMonitor.this.currentWorkUI;
                }
            });
        }
    }

    public boolean isCanceled() {
        return this.cancelRequested;
    }

    public void setCanceled(boolean canceled) {
        this.cancelRequested = canceled;
        if (canceled) {
            this.done();
        }
    }

    public void setTaskName(final String name) {
        this.runInUI(new Runnable(){

            @Override
            public void run() {
                if (ProgressBarProgressMonitor.this.messageLabel != null) {
                    ProgressBarProgressMonitor.this.messageLabel.setText(name);
                }
            }
        });
    }

    public void setSubTaskName(String name) {
        this.setVisibility(true);
        this.messageLabel.setText(name);
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    private void runInUI(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    private void setDescription(String description) {
    }

    private void setVisibility(boolean visible) {
        this.progressPanel.setVisible(visible);
    }
}

