/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.util;

import java.io.File;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductManager;
import org.esa.beam.visat.VisatApp;

public class ProductOpener {
    private final VisatApp visatApp;

    public ProductOpener(VisatApp visatApp) {
        this.visatApp = visatApp;
    }

    public void openProducts(File[] productFiles) {
        for (File productFile : productFiles) {
            if (!productFile.exists() || this.isProductOpen(productFile)) continue;
            try {
                Product product = ProductIO.readProduct((File)productFile);
                ProductManager productManager = this.visatApp.getProductManager();
                productManager.addProduct(product);
            }
            catch (IOException e) {
                this.visatApp.showErrorDialog("Not able to open product:\n" + productFile.getPath());
            }
        }
    }

    private boolean isProductOpen(File productFile) {
        Product openedProduct = this.visatApp.getOpenProduct(productFile);
        if (openedProduct != null) {
            this.visatApp.showInfoDialog("Product '" + openedProduct.getName() + "' is already opened.", null);
            return true;
        }
        return false;
    }
}

